<?php namespace danog\MadelineProto\TL;
/** @internal Autogenerated using tools/TL/Builder.php */
use danog\MadelineProto\MTProto;
use danog\MadelineProto\Connection;
use danog\MadelineProto\MTProtoTools\PeerDatabase;
use danog\MadelineProto\MTProtoTools\ReferenceDatabase;
use danog\MadelineProto\MTProtoTools\MinDatabase;
use danog\MadelineProto\SecurityException;
use AssertionError;
use danog\MadelineProto\Lang;
final class TLParser {
public function __construct(
            private readonly MTProto $API,
            private readonly Connection $connection,
            private readonly PeerDatabase $peerDatabase,
            private readonly ?ReferenceDatabase $referenceDatabase,
            private readonly ?MinDatabase $minDatabase,
        ) {}
            private  function err(mixed $stream): never {

            fseek($stream, -4, SEEK_CUR);
            throw new AssertionError("Unexpected ID ".bin2hex(fread($stream, 4)));
        
    }
    private  function gzdecode(mixed $stream): mixed {

            $res = fopen('php://memory', 'rw+b');
            fwrite($res, gzdecode(self::deserialize_string($stream)));
            rewind($res);
            return $res;
        
    }
    private  function gzdecode_vector(mixed $stream): mixed {

            $res = fopen('php://memory', 'rw+b');
            fwrite($res, gzdecode(self::deserialize_string($stream)));
            rewind($res);
            return match (stream_get_contents($stream, 4)) {
                'ĵ' => $stream,
                default => self::err($stream)
            };
        
    }
    private  function deserialize_bytes(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return new Types\Bytes($x);
        
    }
    private  function deserialize_string(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return $x;
        
    }
    private  function deserialize_waveform(mixed $stream): mixed {

            
            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                $x = stream_get_contents($stream, $l);
                $resto = (-$l) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            } else {
                $x = $l ? stream_get_contents($stream, $l) : "";
                $resto = (-$l+1) % 4;
                $resto = $resto < 0 ? $resto + 4 : $resto;
                if ($resto > 0) {
                    stream_get_contents($stream, $resto);
                }
            }

            return TL::extractWaveform($x);
        
    }
    private  function deserialize_random_bytes(mixed $stream): void {

            $l = \ord(stream_get_contents($stream, 1));
            if ($l > 254) {
                throw new Exception(Lang::$current_lang["length_too_big"]);
            }
            if ($l === 254) {
                $l = unpack("V", stream_get_contents($stream, 3).\chr(0))[1];
                if ($l < 15) {
                    throw new SecurityException("Random_bytes is too small!");
                }
            } else {
                if ($l < 15) {
                    throw new SecurityException("Random_bytes is too small!");
                }
                $l += 1;
            }
            $resto = (-$l) % 4;
            $resto = $resto < 0 ? $resto + 4 : $resto;
            if ($resto > 0) {
                $l += $resto;
            }
            stream_get_contents($stream, $l);
        
    }
    private  function deserialize_type_array_of_int(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('l', stream_get_contents($stream, 4))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_long(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('q', stream_get_contents($stream, 8))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_double(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= unpack('d', stream_get_contents($stream, 8))[1];
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_strlong(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= stream_get_contents($stream, 8);
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_string(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= self::deserialize_string($stream);
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_bytes(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= self::deserialize_bytes($stream);
                }
                return $result;    
            
    }
    private  function deserialize_peerUser(mixed $stream): mixed {
$tmp = unpack('q', stream_get_contents($stream, 8))[1];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_peerChannel(mixed $stream): mixed {
$tmp = -1000000000000 - unpack('q', stream_get_contents($stream, 8))[1];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_type_Peer(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => $this->deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageEmpty(mixed $stream): mixed {
$tmp = ['_' => 'messageEmpty'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageFwdHeader(mixed $stream): mixed {
$tmp = ['_' => 'messageFwdHeader'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['imported'] = ($flags & 128) !== 0;
$tmp['saved_out'] = ($flags & 2048) !== 0;
if (($flags & 1) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['from_name'] = self::deserialize_string($stream);
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['channel_post'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['post_author'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['saved_from_peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['saved_from_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['saved_from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 512) !== 0) $tmp['saved_from_name'] = self::deserialize_string($stream);
if (($flags & 1024) !== 0) $tmp['saved_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['psa_type'] = self::deserialize_string($stream);
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_type_MessageFwdHeader(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'MN' => self::deserialize_messageFwdHeader($stream),
'r0' => $this->deserialize_type_MessageFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_PhotoSize(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_videoSize(mixed $stream): mixed {
$tmp = ['_' => 'videoSize'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['type'] = self::deserialize_string($stream);
$tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['size'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['video_start_ts'] = unpack('d', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_InputStickerSet(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => $this->deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_VideoSize(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'3' => self::deserialize_videoSize($stream),
'<A\\' => [
'_' => 'videoSizeEmojiMarkup',
'emoji_id' => unpack('q', stream_get_contents($stream, 8))[1],
'background_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'
' => [
'_' => 'videoSizeStickerMarkup',
'stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'sticker_id' => unpack('q', stream_get_contents($stream, 8))[1],
'background_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_VideoSize(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_photo(mixed $stream): mixed {
$tmp = ['_' => 'photo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_stickers'] = ($flags & 1) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['file_reference'] = self::deserialize_bytes($stream);
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['sizes'] = self::deserialize_type_array_of_PhotoSize(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['video_sizes'] = self::deserialize_type_array_of_VideoSize(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$this->referenceDatabase?->addReference($tmp);
return $tmp;

    }
    private  function deserialize_type_Photo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => $this->deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageMediaPhoto(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaPhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 8) !== 0;
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_geoPoint(mixed $stream): mixed {
$tmp = ['_' => 'geoPoint'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['long'] = unpack('d', stream_get_contents($stream, 8))[1];
$tmp['lat'] = unpack('d', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['accuracy_radius'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_GeoPoint(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => $this->deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_MaskCoords(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'֮' => [
'_' => 'maskCoords',
'n' => unpack('l', stream_get_contents($stream, 4))[1],
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'zoom' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_MaskCoords(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_documentAttributeSticker(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeSticker'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['mask'] = ($flags & 2) !== 0;
$tmp['alt'] = self::deserialize_string($stream);
$tmp['stickerset'] = match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['mask_coords'] = match (stream_get_contents($stream, 4)) {
'֮' => [
'_' => 'maskCoords',
'n' => unpack('l', stream_get_contents($stream, 4))[1],
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'zoom' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MaskCoords(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_documentAttributeVideo(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeVideo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['round_message'] = ($flags & 1) !== 0;
$tmp['supports_streaming'] = ($flags & 2) !== 0;
$tmp['nosound'] = ($flags & 8) !== 0;
$tmp['duration'] = unpack('d', stream_get_contents($stream, 8))[1];
$tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['preload_prefix_size'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_documentAttributeAudio(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeAudio'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['voice'] = ($flags & 1024) !== 0;
$tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['performer'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['waveform'] = self::deserialize_waveform($stream);
return $tmp;

    }
    private  function deserialize_documentAttributeCustomEmoji(mixed $stream): mixed {
$tmp = ['_' => 'documentAttributeCustomEmoji'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['free'] = ($flags & 1) !== 0;
$tmp['text_color'] = ($flags & 2) !== 0;
$tmp['alt'] = self::deserialize_string($stream);
$tmp['stickerset'] = match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_DocumentAttribute(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'\\7l' => [
'_' => 'documentAttributeImageSize',
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'9' => [
'_' => 'documentAttributeAnimated',
],
'c' => self::deserialize_documentAttributeSticker($stream),
'' => self::deserialize_documentAttributeVideo($stream),
'R' => self::deserialize_documentAttributeAudio($stream),
'h' . "\0" . 'Y' => [
'_' => 'documentAttributeFilename',
'file_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'documentAttributeHasStickers',
],
'' => self::deserialize_documentAttributeCustomEmoji($stream),
'r0' => $this->deserialize_type_DocumentAttribute(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_document(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('document');
$tmp = ['_' => 'document'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['file_reference'] = self::deserialize_bytes($stream);
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['mime_type'] = self::deserialize_string($stream);
$tmp['size'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['thumbs'] = self::deserialize_type_array_of_PhotoSize(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['video_thumbs'] = self::deserialize_type_array_of_VideoSize(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['attributes'] = self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$this->referenceDatabase?->addReference($tmp);
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_Document(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => $this->deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageMediaDocument(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaDocument'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['nopremium'] = ($flags & 8) !== 0;
$tmp['spoiler'] = ($flags & 16) !== 0;
$tmp['video'] = ($flags & 64) !== 0;
$tmp['round'] = ($flags & 128) !== 0;
$tmp['voice'] = ($flags & 256) !== 0;
if (($flags & 1) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['alt_document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_webPageEmpty(mixed $stream): mixed {
$tmp = ['_' => 'webPageEmpty'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['url'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_webPagePending(mixed $stream): mixed {
$tmp = ['_' => 'webPagePending'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['url'] = self::deserialize_string($stream);
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_RichText(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => $this->deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_RichText(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'textItalic',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'"&' => [
'_' => 'textUnderline',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'textStrike',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'?l' => [
'_' => 'textFixed',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'(<' => [
'_' => 'textUrl',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'^' => [
'_' => 'textSuperscript',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'!K' => [
'_' => 'textMarked',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'j' => [
'_' => 'textPhone',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => $this->deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => $this->deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => $this->deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => $this->deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => $this->deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => $this->deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => $this->deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => $this->deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => $this->deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => $this->deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => $this->deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_PageListItem(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Ͷ/' => [
'_' => 'pageListItemText',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
's%' => [
'_' => 'pageListItemBlocks',
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_PageListItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_PageCaption(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_pageBlockPhoto(mixed $stream): mixed {
$tmp = ['_' => 'pageBlockPhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['photo_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['caption'] = match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['url'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['webpage_id'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_pageBlockVideo(mixed $stream): mixed {
$tmp = ['_' => 'pageBlockVideo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['autoplay'] = ($flags & 1) !== 0;
$tmp['loop'] = ($flags & 2) !== 0;
$tmp['video_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['caption'] = match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_pageBlockEmbed(mixed $stream): mixed {
$tmp = ['_' => 'pageBlockEmbed'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['full_width'] = ($flags & 1) !== 0;
$tmp['allow_scrolling'] = ($flags & 8) !== 0;
if (($flags & 2) !== 0) $tmp['url'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['html'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['poster_photo_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 32) !== 0) $tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['caption'] = match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_chatEmpty(mixed $stream): mixed {
$tmp = [
'_' => 'chatEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->peerDatabase->addChat($tmp);
return $tmp;

    }
    private  function deserialize_chatPhoto(mixed $stream): mixed {
$tmp = ['_' => 'chatPhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_video'] = ($flags & 1) !== 0;
$tmp['photo_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['stripped_thumb'] = self::deserialize_bytes($stream);
$tmp['dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_ChatPhoto(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'7' => [
'_' => 'chatPhotoEmpty',
],
'n' => self::deserialize_chatPhoto($stream),
'r0' => $this->deserialize_type_ChatPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputPeer(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => $this->deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputChannel(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputChannelEmpty',
],
'(Z' => [
'_' => 'inputChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'O[' => [
'_' => 'inputChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputChannel(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_chatAdminRights(mixed $stream): mixed {
$tmp = ['_' => 'chatAdminRights'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['change_info'] = ($flags & 1) !== 0;
$tmp['post_messages'] = ($flags & 2) !== 0;
$tmp['edit_messages'] = ($flags & 4) !== 0;
$tmp['delete_messages'] = ($flags & 8) !== 0;
$tmp['ban_users'] = ($flags & 16) !== 0;
$tmp['invite_users'] = ($flags & 32) !== 0;
$tmp['pin_messages'] = ($flags & 128) !== 0;
$tmp['add_admins'] = ($flags & 512) !== 0;
$tmp['anonymous'] = ($flags & 1024) !== 0;
$tmp['manage_call'] = ($flags & 2048) !== 0;
$tmp['other'] = ($flags & 4096) !== 0;
$tmp['manage_topics'] = ($flags & 8192) !== 0;
$tmp['post_stories'] = ($flags & 16384) !== 0;
$tmp['edit_stories'] = ($flags & 32768) !== 0;
$tmp['delete_stories'] = ($flags & 65536) !== 0;
return $tmp;

    }
    private  function deserialize_type_ChatAdminRights(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => $this->deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_chatBannedRights(mixed $stream): mixed {
$tmp = ['_' => 'chatBannedRights'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['view_messages'] = ($flags & 1) !== 0;
$tmp['send_messages'] = ($flags & 2) !== 0;
$tmp['send_media'] = ($flags & 4) !== 0;
$tmp['send_stickers'] = ($flags & 8) !== 0;
$tmp['send_gifs'] = ($flags & 16) !== 0;
$tmp['send_games'] = ($flags & 32) !== 0;
$tmp['send_inline'] = ($flags & 64) !== 0;
$tmp['embed_links'] = ($flags & 128) !== 0;
$tmp['send_polls'] = ($flags & 256) !== 0;
$tmp['change_info'] = ($flags & 1024) !== 0;
$tmp['invite_users'] = ($flags & 32768) !== 0;
$tmp['pin_messages'] = ($flags & 131072) !== 0;
$tmp['manage_topics'] = ($flags & 262144) !== 0;
$tmp['send_photos'] = ($flags & 524288) !== 0;
$tmp['send_videos'] = ($flags & 1048576) !== 0;
$tmp['send_roundvideos'] = ($flags & 2097152) !== 0;
$tmp['send_audios'] = ($flags & 4194304) !== 0;
$tmp['send_voices'] = ($flags & 8388608) !== 0;
$tmp['send_docs'] = ($flags & 16777216) !== 0;
$tmp['send_plain'] = ($flags & 33554432) !== 0;
$tmp['until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_ChatBannedRights(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => $this->deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_chat(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('chat');
$tmp = ['_' => 'chat'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
$tmp['left'] = ($flags & 4) !== 0;
$tmp['deactivated'] = ($flags & 32) !== 0;
$tmp['call_active'] = ($flags & 8388608) !== 0;
$tmp['call_not_empty'] = ($flags & 16777216) !== 0;
$tmp['noforwards'] = ($flags & 33554432) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['photo'] = match (stream_get_contents($stream, 4)) {
'7' => [
'_' => 'chatPhotoEmpty',
],
'n' => self::deserialize_chatPhoto($stream),
'r0' => self::deserialize_type_ChatPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['participants_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['version'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['migrated_to'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputChannelEmpty',
],
'(Z' => [
'_' => 'inputChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'O[' => [
'_' => 'inputChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputChannel(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16384) !== 0) $tmp['admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 262144) !== 0) $tmp['default_banned_rights'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addChat($tmp);
return $tmp;

    }
    private  function deserialize_chatForbidden(mixed $stream): mixed {
$tmp = [
'_' => 'chatForbidden',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'title' => self::deserialize_string($stream),
];
$this->peerDatabase->addChat($tmp);
return $tmp;

    }
    private  function deserialize_type_array_of_RestrictionReason(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'restrictionReason',
'platform' => self::deserialize_string($stream),
'reason' => self::deserialize_string($stream),
'text' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_RestrictionReason(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_username(mixed $stream): mixed {
$tmp = ['_' => 'username'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['editable'] = ($flags & 1) !== 0;
$tmp['active'] = ($flags & 2) !== 0;
$tmp['username'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_Username(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'G6' => self::deserialize_username($stream),
'r0' => $this->deserialize_type_Username(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_peerColor(mixed $stream): mixed {
$tmp = ['_' => 'peerColor'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['background_emoji_id'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_PeerColor(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => $this->deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_EmojiStatus(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_channel(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('channel');
$tmp = ['_' => 'channel'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
$tmp['left'] = ($flags & 4) !== 0;
$tmp['broadcast'] = ($flags & 32) !== 0;
$tmp['verified'] = ($flags & 128) !== 0;
$tmp['megagroup'] = ($flags & 256) !== 0;
$tmp['restricted'] = ($flags & 512) !== 0;
$tmp['signatures'] = ($flags & 2048) !== 0;
$tmp['min'] = ($flags & 4096) !== 0;
$tmp['scam'] = ($flags & 524288) !== 0;
$tmp['has_link'] = ($flags & 1048576) !== 0;
$tmp['has_geo'] = ($flags & 2097152) !== 0;
$tmp['slowmode_enabled'] = ($flags & 4194304) !== 0;
$tmp['call_active'] = ($flags & 8388608) !== 0;
$tmp['call_not_empty'] = ($flags & 16777216) !== 0;
$tmp['fake'] = ($flags & 33554432) !== 0;
$tmp['gigagroup'] = ($flags & 67108864) !== 0;
$tmp['noforwards'] = ($flags & 134217728) !== 0;
$tmp['join_to_send'] = ($flags & 268435456) !== 0;
$tmp['join_request'] = ($flags & 536870912) !== 0;
$tmp['forum'] = ($flags & 1073741824) !== 0;
$flags2 = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['stories_hidden'] = ($flags2 & 2) !== 0;
$tmp['stories_hidden_min'] = ($flags2 & 4) !== 0;
$tmp['stories_unavailable'] = ($flags2 & 8) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8192) !== 0) $tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 64) !== 0) $tmp['username'] = self::deserialize_string($stream);
$tmp['photo'] = match (stream_get_contents($stream, 4)) {
'7' => [
'_' => 'chatPhotoEmpty',
],
'n' => self::deserialize_chatPhoto($stream),
'r0' => self::deserialize_type_ChatPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 512) !== 0) $tmp['restriction_reason'] = self::deserialize_type_array_of_RestrictionReason(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16384) !== 0) $tmp['admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32768) !== 0) $tmp['banned_rights'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 262144) !== 0) $tmp['default_banned_rights'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 131072) !== 0) $tmp['participants_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags2 & 1) !== 0) $tmp['usernames'] = self::deserialize_type_array_of_Username(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags2 & 16) !== 0) $tmp['stories_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags2 & 128) !== 0) $tmp['color'] = match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 256) !== 0) $tmp['profile_color'] = match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 512) !== 0) $tmp['emoji_status'] = match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 1024) !== 0) $tmp['level'] = unpack('l', stream_get_contents($stream, 4))[1];
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addChat($tmp);
return $tmp;

    }
    private  function deserialize_channelForbidden(mixed $stream): mixed {
$tmp = ['_' => 'channelForbidden'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['broadcast'] = ($flags & 32) !== 0;
$tmp['megagroup'] = ($flags & 256) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 65536) !== 0) $tmp['until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$this->peerDatabase->addChat($tmp);
return $tmp;

    }
    private  function deserialize_type_Chat(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => $this->deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_pageTableCell(mixed $stream): mixed {
$tmp = ['_' => 'pageTableCell'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['header'] = ($flags & 1) !== 0;
$tmp['align_center'] = ($flags & 8) !== 0;
$tmp['align_right'] = ($flags & 16) !== 0;
$tmp['valign_middle'] = ($flags & 32) !== 0;
$tmp['valign_bottom'] = ($flags & 64) !== 0;
if (($flags & 128) !== 0) $tmp['text'] = match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['colspan'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['rowspan'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_PageTableCell(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'jkV4' => self::deserialize_pageTableCell($stream),
'r0' => $this->deserialize_type_PageTableCell(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PageTableRow(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'pageTableRow',
'cells' => self::deserialize_type_array_of_PageTableCell(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_PageTableRow(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_pageBlockTable(mixed $stream): mixed {
$tmp = ['_' => 'pageBlockTable'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['bordered'] = ($flags & 1) !== 0;
$tmp['striped'] = ($flags & 2) !== 0;
$tmp['title'] = match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['rows'] = self::deserialize_type_array_of_PageTableRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_PageListOrderedItem(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'G^' => [
'_' => 'pageListOrderedItemText',
'num' => self::deserialize_string($stream),
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'6ݘ' => [
'_' => 'pageListOrderedItemBlocks',
'num' => self::deserialize_string($stream),
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_PageListOrderedItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_pageBlockDetails(mixed $stream): mixed {
$tmp = ['_' => 'pageBlockDetails'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['open'] = ($flags & 1) !== 0;
$tmp['blocks'] = $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['title'] = match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_pageRelatedArticle(mixed $stream): mixed {
$tmp = ['_' => 'pageRelatedArticle'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['url'] = self::deserialize_string($stream);
$tmp['webpage_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['description'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['photo_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['author'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['published_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_PageRelatedArticle(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ܐ' => self::deserialize_pageRelatedArticle($stream),
'r0' => $this->deserialize_type_PageRelatedArticle(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_PageBlock(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'~V' => [
'_' => 'pageBlockUnsupported',
],
'ëp' => [
'_' => 'pageBlockTitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSubtitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'寺' => [
'_' => 'pageBlockAuthorDate',
'author' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'published_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'dп' => [
'_' => 'pageBlockHeader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+' => [
'_' => 'pageBlockSubheader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'fzF' => [
'_' => 'pageBlockParagraph',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>p' => [
'_' => 'pageBlockPreformatted',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'language' => self::deserialize_string($stream),
],
'	H' => [
'_' => 'pageBlockFooter',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
' ' => [
'_' => 'pageBlockDivider',
],
'7
' => [
'_' => 'pageBlockAnchor',
'name' => self::deserialize_string($stream),
],
'' => [
'_' => 'pageBlockList',
'items' => self::deserialize_type_array_of_PageListItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'&|=&' => [
'_' => 'pageBlockBlockquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'VDO' => [
'_' => 'pageBlockPullquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`Y' => self::deserialize_pageBlockPhoto($stream),
'|' => self::deserialize_pageBlockVideo($stream),
'' . "\0" . '39' => [
'_' => 'pageBlockCover',
'cover' => match (stream_get_contents($stream, 4)) {
'~V' => [
'_' => 'pageBlockUnsupported',
],
'ëp' => [
'_' => 'pageBlockTitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSubtitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'寺' => [
'_' => 'pageBlockAuthorDate',
'author' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'published_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'dп' => [
'_' => 'pageBlockHeader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+' => [
'_' => 'pageBlockSubheader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'fzF' => [
'_' => 'pageBlockParagraph',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>p' => [
'_' => 'pageBlockPreformatted',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'language' => self::deserialize_string($stream),
],
'	H' => [
'_' => 'pageBlockFooter',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
' ' => [
'_' => 'pageBlockDivider',
],
'7
' => [
'_' => 'pageBlockAnchor',
'name' => self::deserialize_string($stream),
],
'' => [
'_' => 'pageBlockList',
'items' => self::deserialize_type_array_of_PageListItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'&|=&' => [
'_' => 'pageBlockBlockquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'VDO' => [
'_' => 'pageBlockPullquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`Y' => self::deserialize_pageBlockPhoto($stream),
'|' => self::deserialize_pageBlockVideo($stream),
'' . "\0" . '39' => [
'_' => 'pageBlockCover',
'cover' => $this->deserialize_type_PageBlock($stream),
],
'ōq' => self::deserialize_pageBlockEmbed($stream),
'Y' => [
'_' => 'pageBlockEmbedPost',
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author_photo_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author' => self::deserialize_string($stream),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Me' => [
'_' => 'pageBlockCollage',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSlideshow',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q' => [
'_' => 'pageBlockChannel',
'channel' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'aC' => [
'_' => 'pageBlockAudio',
'audio_id' => unpack('q', stream_get_contents($stream, 8))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockKicker',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => self::deserialize_pageBlockTable($stream),
'ኚ' => [
'_' => 'pageBlockOrderedList',
'items' => self::deserialize_type_array_of_PageListOrderedItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'vv' => self::deserialize_pageBlockDetails($stream),
'Z' => [
'_' => 'pageBlockRelatedArticles',
'title' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'articles' => self::deserialize_type_array_of_PageRelatedArticle(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'>O' => [
'_' => 'pageBlockMap',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'zoom' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_PageBlock(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ōq' => self::deserialize_pageBlockEmbed($stream),
'Y' => [
'_' => 'pageBlockEmbedPost',
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author_photo_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author' => self::deserialize_string($stream),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Me' => [
'_' => 'pageBlockCollage',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSlideshow',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q' => [
'_' => 'pageBlockChannel',
'channel' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'aC' => [
'_' => 'pageBlockAudio',
'audio_id' => unpack('q', stream_get_contents($stream, 8))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockKicker',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => self::deserialize_pageBlockTable($stream),
'ኚ' => [
'_' => 'pageBlockOrderedList',
'items' => self::deserialize_type_array_of_PageListOrderedItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'vv' => self::deserialize_pageBlockDetails($stream),
'Z' => [
'_' => 'pageBlockRelatedArticles',
'title' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'articles' => self::deserialize_type_array_of_PageRelatedArticle(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'>O' => [
'_' => 'pageBlockMap',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'zoom' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_PageBlock(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_PageBlock(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'~V' => [
'_' => 'pageBlockUnsupported',
],
'ëp' => [
'_' => 'pageBlockTitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSubtitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'寺' => [
'_' => 'pageBlockAuthorDate',
'author' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'published_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'dп' => [
'_' => 'pageBlockHeader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+' => [
'_' => 'pageBlockSubheader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'fzF' => [
'_' => 'pageBlockParagraph',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>p' => [
'_' => 'pageBlockPreformatted',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'language' => self::deserialize_string($stream),
],
'	H' => [
'_' => 'pageBlockFooter',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
' ' => [
'_' => 'pageBlockDivider',
],
'7
' => [
'_' => 'pageBlockAnchor',
'name' => self::deserialize_string($stream),
],
'' => [
'_' => 'pageBlockList',
'items' => self::deserialize_type_array_of_PageListItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'&|=&' => [
'_' => 'pageBlockBlockquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'VDO' => [
'_' => 'pageBlockPullquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`Y' => self::deserialize_pageBlockPhoto($stream),
'|' => self::deserialize_pageBlockVideo($stream),
'' . "\0" . '39' => [
'_' => 'pageBlockCover',
'cover' => match (stream_get_contents($stream, 4)) {
'~V' => [
'_' => 'pageBlockUnsupported',
],
'ëp' => [
'_' => 'pageBlockTitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSubtitle',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'寺' => [
'_' => 'pageBlockAuthorDate',
'author' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'published_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'dп' => [
'_' => 'pageBlockHeader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+' => [
'_' => 'pageBlockSubheader',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'fzF' => [
'_' => 'pageBlockParagraph',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>p' => [
'_' => 'pageBlockPreformatted',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'language' => self::deserialize_string($stream),
],
'	H' => [
'_' => 'pageBlockFooter',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
' ' => [
'_' => 'pageBlockDivider',
],
'7
' => [
'_' => 'pageBlockAnchor',
'name' => self::deserialize_string($stream),
],
'' => [
'_' => 'pageBlockList',
'items' => self::deserialize_type_array_of_PageListItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'&|=&' => [
'_' => 'pageBlockBlockquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'VDO' => [
'_' => 'pageBlockPullquote',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'caption' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`Y' => self::deserialize_pageBlockPhoto($stream),
'|' => self::deserialize_pageBlockVideo($stream),
'' . "\0" . '39' => [
'_' => 'pageBlockCover',
'cover' => self::deserialize_type_PageBlock($stream),
],
'ōq' => self::deserialize_pageBlockEmbed($stream),
'Y' => [
'_' => 'pageBlockEmbedPost',
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author_photo_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author' => self::deserialize_string($stream),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Me' => [
'_' => 'pageBlockCollage',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSlideshow',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q' => [
'_' => 'pageBlockChannel',
'channel' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'aC' => [
'_' => 'pageBlockAudio',
'audio_id' => unpack('q', stream_get_contents($stream, 8))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockKicker',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => self::deserialize_pageBlockTable($stream),
'ኚ' => [
'_' => 'pageBlockOrderedList',
'items' => self::deserialize_type_array_of_PageListOrderedItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'vv' => self::deserialize_pageBlockDetails($stream),
'Z' => [
'_' => 'pageBlockRelatedArticles',
'title' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'articles' => self::deserialize_type_array_of_PageRelatedArticle(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'>O' => [
'_' => 'pageBlockMap',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'zoom' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageBlock(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ōq' => self::deserialize_pageBlockEmbed($stream),
'Y' => [
'_' => 'pageBlockEmbedPost',
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author_photo_id' => unpack('q', stream_get_contents($stream, 8))[1],
'author' => self::deserialize_string($stream),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'blocks' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Me' => [
'_' => 'pageBlockCollage',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockSlideshow',
'items' => $this->deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q' => [
'_' => 'pageBlockChannel',
'channel' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'aC' => [
'_' => 'pageBlockAudio',
'audio_id' => unpack('q', stream_get_contents($stream, 8))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'pageBlockKicker',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => self::deserialize_pageBlockTable($stream),
'ኚ' => [
'_' => 'pageBlockOrderedList',
'items' => self::deserialize_type_array_of_PageListOrderedItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'vv' => self::deserialize_pageBlockDetails($stream),
'Z' => [
'_' => 'pageBlockRelatedArticles',
'title' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'articles' => self::deserialize_type_array_of_PageRelatedArticle(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'>O' => [
'_' => 'pageBlockMap',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'zoom' => unpack('l', stream_get_contents($stream, 4))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'caption' => match (stream_get_contents($stream, 4)) {
'Wvto' => [
'_' => 'pageCaption',
'text' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
'credit' => match (stream_get_contents($stream, 4)) {
'O=' => [
'_' => 'textEmpty',
],
'Ft' => [
'_' => 'textPlain',
'text' => self::deserialize_string($stream),
],
'ī$g' => [
'_' => 'textBold',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textItalic',
'text' => self::deserialize_type_RichText($stream),
],
'"&' => [
'_' => 'textUnderline',
'text' => self::deserialize_type_RichText($stream),
],
'' => [
'_' => 'textStrike',
'text' => self::deserialize_type_RichText($stream),
],
'?l' => [
'_' => 'textFixed',
'text' => self::deserialize_type_RichText($stream),
],
'(<' => [
'_' => 'textUrl',
'text' => self::deserialize_type_RichText($stream),
'url' => self::deserialize_string($stream),
'webpage_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
Z' => [
'_' => 'textEmail',
'text' => self::deserialize_type_RichText($stream),
'email' => self::deserialize_string($stream),
],
'`b~' => [
'_' => 'textConcat',
'texts' => self::deserialize_type_array_of_RichText(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'j' => [
'_' => 'textSubscript',
'text' => self::deserialize_type_RichText($stream),
],
'^' => [
'_' => 'textSuperscript',
'text' => self::deserialize_type_RichText($stream),
],
'!K' => [
'_' => 'textMarked',
'text' => self::deserialize_type_RichText($stream),
],
'j' => [
'_' => 'textPhone',
'text' => self::deserialize_type_RichText($stream),
'phone' => self::deserialize_string($stream),
],
'O' => [
'_' => 'textImage',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
],
'b7U5' => [
'_' => 'textAnchor',
'text' => self::deserialize_type_RichText($stream),
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_RichText(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageCaption(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_PageBlock(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Photo(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Document(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_page(mixed $stream): mixed {
$tmp = ['_' => 'page'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['part'] = ($flags & 1) !== 0;
$tmp['rtl'] = ($flags & 2) !== 0;
$tmp['v2'] = ($flags & 4) !== 0;
$tmp['url'] = self::deserialize_string($stream);
$tmp['blocks'] = self::deserialize_type_array_of_PageBlock(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['photos'] = self::deserialize_type_array_of_Photo(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['documents'] = self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 8) !== 0) $tmp['views'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Page(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
e' => self::deserialize_page($stream),
'r0' => $this->deserialize_type_Page(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_BaseTheme(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'b$' => [
'_' => 'baseThemeClassic',
],
'' => [
'_' => 'baseThemeDay',
],
'' => [
'_' => 'baseThemeNight',
],
'w_m' => [
'_' => 'baseThemeTinted',
],
'Z[' => [
'_' => 'baseThemeArctic',
],
'r0' => $this->deserialize_type_BaseTheme(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_wallPaperSettings(mixed $stream): mixed {
$tmp = ['_' => 'wallPaperSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blur'] = ($flags & 2) !== 0;
$tmp['motion'] = ($flags & 4) !== 0;
if (($flags & 1) !== 0) $tmp['background_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['second_background_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['third_background_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['fourth_background_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['intensity'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['rotation'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 128) !== 0) $tmp['emoticon'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_WallPaperSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'.7' => self::deserialize_wallPaperSettings($stream),
'r0' => $this->deserialize_type_WallPaperSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_wallPaper(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('wallPaper');
$tmp = ['_' => 'wallPaper'];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
$tmp['default'] = ($flags & 2) !== 0;
$tmp['pattern'] = ($flags & 8) !== 0;
$tmp['dark'] = ($flags & 16) !== 0;
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['slug'] = self::deserialize_string($stream);
$tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['settings'] = match (stream_get_contents($stream, 4)) {
'.7' => self::deserialize_wallPaperSettings($stream),
'r0' => self::deserialize_type_WallPaperSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_wallPaperNoFile(mixed $stream): mixed {
$tmp = ['_' => 'wallPaperNoFile'];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['default'] = ($flags & 2) !== 0;
$tmp['dark'] = ($flags & 16) !== 0;
if (($flags & 4) !== 0) $tmp['settings'] = match (stream_get_contents($stream, 4)) {
'.7' => self::deserialize_wallPaperSettings($stream),
'r0' => self::deserialize_type_WallPaperSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_WallPaper(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => $this->deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_themeSettings(mixed $stream): mixed {
$tmp = ['_' => 'themeSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['message_colors_animated'] = ($flags & 4) !== 0;
$tmp['base_theme'] = match (stream_get_contents($stream, 4)) {
'b$' => [
'_' => 'baseThemeClassic',
],
'' => [
'_' => 'baseThemeDay',
],
'' => [
'_' => 'baseThemeNight',
],
'w_m' => [
'_' => 'baseThemeTinted',
],
'Z[' => [
'_' => 'baseThemeArctic',
],
'r0' => self::deserialize_type_BaseTheme(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['accent_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['outbox_accent_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['message_colors'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['wallpaper'] = match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_ThemeSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ԶX' => self::deserialize_themeSettings($stream),
'r0' => $this->deserialize_type_ThemeSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_webPageAttributeTheme(mixed $stream): mixed {
$tmp = ['_' => 'webPageAttributeTheme'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['documents'] = self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['settings'] = match (stream_get_contents($stream, 4)) {
'ԶX' => self::deserialize_themeSettings($stream),
'r0' => self::deserialize_type_ThemeSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_storyItemSkipped(mixed $stream): mixed {
$tmp = ['_' => 'storyItemSkipped'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['close_friends'] = ($flags & 256) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['expire_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_storyFwdHeader(mixed $stream): mixed {
$tmp = ['_' => 'storyFwdHeader'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['modified'] = ($flags & 8) !== 0;
if (($flags & 1) !== 0) $tmp['from'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['from_name'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['story_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_StoryFwdHeader(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'P&' => self::deserialize_storyFwdHeader($stream),
'r0' => $this->deserialize_type_StoryFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageEntityMentionName(mixed $stream): mixed {
$tmp = [
'_' => 'messageEntityMentionName',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_type_InputUser(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_MessageEntity(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'messageEntityUnknown',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'W' => [
'_' => 'messageEntityMention',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
[co' => [
'_' => 'messageEntityHashtag',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ǌl' => [
'_' => 'messageEntityBotCommand',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'8%n' => [
'_' => 'messageEntityUrl',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ud' => [
'_' => 'messageEntityEmail',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'a' => [
'_' => 'messageEntityBold',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'`o' => [
'_' => 'messageEntityItalic',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q(' => [
'_' => 'messageEntityCode',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ks' => [
'_' => 'messageEntityPre',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'language' => self::deserialize_string($stream),
],
'\'Ӧv' => [
'_' => 'messageEntityTextUrl',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'url' => self::deserialize_string($stream),
],
'@{' => self::deserialize_messageEntityMentionName($stream),
'h ' => [
'_' => 'inputMessageEntityMentionName',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ki' => [
'_' => 'messageEntityPhone',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?tNL' => [
'_' => 'messageEntityCashtag',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'~N' => [
'_' => 'messageEntityUnderline',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ԓ' => [
'_' => 'messageEntityStrike',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'jv' => [
'_' => 'messageEntityBankCard',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'2' => [
'_' => 'messageEntitySpoiler',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'messageEntityCustomEmoji',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
' => [
'_' => 'messageEntityBlockquote',
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MessageEntity(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_webPage(mixed $stream): mixed {
$tmp = ['_' => 'webPage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_large_media'] = ($flags & 8192) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['url'] = self::deserialize_string($stream);
$tmp['display_url'] = self::deserialize_string($stream);
$tmp['hash'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['type'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['site_name'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['description'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['embed_url'] = self::deserialize_string($stream);
if (($flags & 32) !== 0) $tmp['embed_type'] = self::deserialize_string($stream);
if (($flags & 64) !== 0) $tmp['embed_width'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['embed_height'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 128) !== 0) $tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['author'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1024) !== 0) $tmp['cached_page'] = match (stream_get_contents($stream, 4)) {
'
e' => self::deserialize_page($stream),
'r0' => self::deserialize_type_Page(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4096) !== 0) $tmp['attributes'] = $this->deserialize_type_array_of_WebPageAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_webPageNotModified(mixed $stream): mixed {
$tmp = ['_' => 'webPageNotModified'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['cached_page_views'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_messageMediaWebPage(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaWebPage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['force_large_media'] = ($flags & 1) !== 0;
$tmp['force_small_media'] = ($flags & 2) !== 0;
$tmp['manual'] = ($flags & 8) !== 0;
$tmp['safe'] = ($flags & 16) !== 0;
$tmp['webpage'] = match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => $this->deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_game(mixed $stream): mixed {
$tmp = ['_' => 'game'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['short_name'] = self::deserialize_string($stream);
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
$tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_Game(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => $this->deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_WebDocument(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_PhotoSize(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageExtendedMediaPreview(mixed $stream): mixed {
$tmp = ['_' => 'messageExtendedMediaPreview'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['w'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['h'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['thumb'] = match (stream_get_contents($stream, 4)) {
'<' => [
'_' => 'photoSizeEmpty',
'type' => self::deserialize_string($stream),
],
'`u' => [
'_' => 'photoSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'photoCachedSize',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'.' => [
'_' => 'photoStrippedSize',
'type' => self::deserialize_string($stream),
'inflated' => new Types\Bytes(Tools::inflateStripped(self::deserialize_string($stream))),
],
'>' => [
'_' => 'photoSizeProgressive',
'type' => self::deserialize_string($stream),
'w' => unpack('l', stream_get_contents($stream, 4))[1],
'h' => unpack('l', stream_get_contents($stream, 4))[1],
'sizes' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'AM!' => [
'_' => 'photoPathSize',
'type' => self::deserialize_string($stream),
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PhotoSize(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['video_duration'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_MessageExtendedMedia(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Ȍb' => self::deserialize_messageExtendedMediaPreview($stream),
'dG' => [
'_' => 'messageExtendedMedia',
'media' => $this->deserialize_type_MessageMedia($stream),
],
'r0' => $this->deserialize_type_MessageExtendedMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageMediaInvoice(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaInvoice'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['shipping_address_requested'] = ($flags & 2) !== 0;
$tmp['test'] = ($flags & 8) !== 0;
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['receipt_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['start_param'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['extended_media'] = match (stream_get_contents($stream, 4)) {
'Ȍb' => self::deserialize_messageExtendedMediaPreview($stream),
'dG' => [
'_' => 'messageExtendedMedia',
'media' => $this->deserialize_type_MessageMedia($stream),
],
'r0' => self::deserialize_type_MessageExtendedMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageMediaGeoLive(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaGeoLive'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['geo'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['heading'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['proximity_notification_radius'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_PollAnswer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'©l' => [
'_' => 'pollAnswer',
'text' => self::deserialize_string($stream),
'option' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_PollAnswer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_poll(mixed $stream): mixed {
$tmp = ['_' => 'poll'];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['closed'] = ($flags & 1) !== 0;
$tmp['public_voters'] = ($flags & 2) !== 0;
$tmp['multiple_choice'] = ($flags & 4) !== 0;
$tmp['quiz'] = ($flags & 8) !== 0;
$tmp['question'] = self::deserialize_string($stream);
$tmp['answers'] = self::deserialize_type_array_of_PollAnswer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['close_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['close_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Poll(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => $this->deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_pollAnswerVoters(mixed $stream): mixed {
$tmp = ['_' => 'pollAnswerVoters'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['chosen'] = ($flags & 1) !== 0;
$tmp['correct'] = ($flags & 2) !== 0;
$tmp['option'] = self::deserialize_bytes($stream);
$tmp['voters'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_PollAnswerVoters(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'm;' => self::deserialize_pollAnswerVoters($stream),
'r0' => $this->deserialize_type_PollAnswerVoters(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Peer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_pollResults(mixed $stream): mixed {
$tmp = ['_' => 'pollResults'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['min'] = ($flags & 1) !== 0;
if (($flags & 2) !== 0) $tmp['results'] = self::deserialize_type_array_of_PollAnswerVoters(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 4) !== 0) $tmp['total_voters'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['recent_voters'] = self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['solution'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['solution_entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_PollResults(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => $this->deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_MediaAreaCoordinates(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_Reaction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_mediaAreaSuggestedReaction(mixed $stream): mixed {
$tmp = ['_' => 'mediaAreaSuggestedReaction'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['dark'] = ($flags & 1) !== 0;
$tmp['flipped'] = ($flags & 2) !== 0;
$tmp['coordinates'] = match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_MediaArea(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ۂ' => [
'_' => 'mediaAreaVenue',
'coordinates' => match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
,
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'!' => [
'_' => 'inputMediaAreaVenue',
'coordinates' => match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
,
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'result_id' => self::deserialize_string($stream),
],
'";' => [
'_' => 'mediaAreaGeoPoint',
'coordinates' => match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
,
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'qXE' => self::deserialize_mediaAreaSuggestedReaction($stream),
'w' => [
'_' => 'mediaAreaChannelPost',
'coordinates' => match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
,
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q"' => [
'_' => 'inputMediaAreaChannelPost',
'coordinates' => match (stream_get_contents($stream, 4)) {
'N' => [
'_' => 'mediaAreaCoordinates',
'x' => unpack('d', stream_get_contents($stream, 8))[1],
'y' => unpack('d', stream_get_contents($stream, 8))[1],
'w' => unpack('d', stream_get_contents($stream, 8))[1],
'h' => unpack('d', stream_get_contents($stream, 8))[1],
'rotation' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_MediaAreaCoordinates(self::gzdecode($stream)),
default => self::err($stream)
}
,
'channel' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputChannelEmpty',
],
'(Z' => [
'_' => 'inputChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'O[' => [
'_' => 'inputChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputChannel(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MediaArea(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PrivacyRule(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'privacyValueAllowContacts',
],
'{Be' => [
'_' => 'privacyValueAllowAll',
],
'_' => [
'_' => 'privacyValueAllowUsers',
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'privacyValueDisallowContacts',
],
'cs' => [
'_' => 'privacyValueDisallowAll',
],
'Ab' => [
'_' => 'privacyValueDisallowUsers',
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Nk' => [
'_' => 'privacyValueAllowChatParticipants',
'chats' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'euA' => [
'_' => 'privacyValueDisallowChatParticipants',
'chats' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'privacyValueAllowCloseFriends',
],
'r0' => $this->deserialize_type_PrivacyRule(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_reactionCount(mixed $stream): mixed {
$tmp = ['_' => 'reactionCount'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['chosen_order'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_ReactionCount(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ѣ' => self::deserialize_reactionCount($stream),
'r0' => $this->deserialize_type_ReactionCount(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_storyViews(mixed $stream): mixed {
$tmp = ['_' => 'storyViews'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_viewers'] = ($flags & 2) !== 0;
$tmp['views_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['forwards_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['reactions'] = self::deserialize_type_array_of_ReactionCount(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['reactions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['recent_viewers'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_StoryViews(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'\\Y' => self::deserialize_storyViews($stream),
'r0' => $this->deserialize_type_StoryViews(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_storyItem(mixed $stream): mixed {
$tmp = ['_' => 'storyItem'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 32) !== 0;
$tmp['public'] = ($flags & 128) !== 0;
$tmp['close_friends'] = ($flags & 256) !== 0;
$tmp['min'] = ($flags & 512) !== 0;
$tmp['noforwards'] = ($flags & 1024) !== 0;
$tmp['edited'] = ($flags & 2048) !== 0;
$tmp['contacts'] = ($flags & 4096) !== 0;
$tmp['selected_contacts'] = ($flags & 8192) !== 0;
$tmp['out'] = ($flags & 65536) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 262144) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 131072) !== 0) $tmp['fwd_from'] = match (stream_get_contents($stream, 4)) {
'P&' => self::deserialize_storyFwdHeader($stream),
'r0' => self::deserialize_type_StoryFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['expire_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['caption'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['media'] = $this->deserialize_type_MessageMedia($stream);
if (($flags & 16384) !== 0) $tmp['media_areas'] = self::deserialize_type_array_of_MediaArea(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 4) !== 0) $tmp['privacy'] = self::deserialize_type_array_of_PrivacyRule(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 8) !== 0) $tmp['views'] = match (stream_get_contents($stream, 4)) {
'\\Y' => self::deserialize_storyViews($stream),
'r0' => self::deserialize_type_StoryViews(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32768) !== 0) $tmp['sent_reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageMediaStory(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaStory'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_mention'] = ($flags & 2) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['story'] = match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => $this->deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageMediaGiveaway(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaGiveaway'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['only_new_subscribers'] = ($flags & 1) !== 0;
$tmp['winners_are_visible'] = ($flags & 4) !== 0;
$tmp['channels'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['countries_iso2'] = self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 8) !== 0) $tmp['prize_description'] = self::deserialize_string($stream);
$tmp['quantity'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_messageMediaGiveawayResults(mixed $stream): mixed {
$tmp = ['_' => 'messageMediaGiveawayResults'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['only_new_subscribers'] = ($flags & 1) !== 0;
$tmp['refunded'] = ($flags & 4) !== 0;
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['additional_peers_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['launch_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['winners_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unclaimed_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['winners'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['prize_description'] = self::deserialize_string($stream);
$tmp['until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_StoryItem(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => $this->deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_webPageAttributeStory(mixed $stream): mixed {
$tmp = ['_' => 'webPageAttributeStory'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['story'] = match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_WebPageAttribute(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'fT' => self::deserialize_webPageAttributeTheme($stream),
'Ô.' => self::deserialize_webPageAttributeStory($stream),
'r0' => $this->deserialize_type_WebPageAttribute(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_WebPage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => $this->deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_MessageMedia(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => $this->deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageReplyHeader(mixed $stream): mixed {
$tmp = ['_' => 'messageReplyHeader'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['reply_to_scheduled'] = ($flags & 4) !== 0;
$tmp['forum_topic'] = ($flags & 8) !== 0;
$tmp['quote'] = ($flags & 512) !== 0;
if (($flags & 16) !== 0) $tmp['reply_to_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['reply_to_peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['reply_from'] = match (stream_get_contents($stream, 4)) {
'MN' => self::deserialize_messageFwdHeader($stream),
'r0' => self::deserialize_type_MessageFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 256) !== 0) $tmp['reply_media'] = match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['reply_to_top_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['quote_text'] = self::deserialize_string($stream);
if (($flags & 128) !== 0) $tmp['quote_entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1024) !== 0) $tmp['quote_offset'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_MessageReplyHeader(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'	' => self::deserialize_messageReplyHeader($stream),
'9Z' => [
'_' => 'messageReplyStoryHeader',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MessageReplyHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_replyKeyboardHide(mixed $stream): mixed {
$tmp = ['_' => 'replyKeyboardHide'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['selective'] = ($flags & 4) !== 0;
return $tmp;

    }
    private  function deserialize_replyKeyboardForceReply(mixed $stream): mixed {
$tmp = ['_' => 'replyKeyboardForceReply'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['single_use'] = ($flags & 2) !== 0;
$tmp['selective'] = ($flags & 4) !== 0;
if (($flags & 8) !== 0) $tmp['placeholder'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_keyboardButtonCallback(mixed $stream): mixed {
$tmp = ['_' => 'keyboardButtonCallback'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['requires_password'] = ($flags & 1) !== 0;
$tmp['text'] = self::deserialize_string($stream);
$tmp['data'] = self::deserialize_bytes($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_InlineQueryPeerType(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'0' => [
'_' => 'inlineQueryPeerTypeSameBotPM',
],
'<' => [
'_' => 'inlineQueryPeerTypePM',
],
'
f' => [
'_' => 'inlineQueryPeerTypeChat',
],
'C^' => [
'_' => 'inlineQueryPeerTypeMegagroup',
],
'4c' => [
'_' => 'inlineQueryPeerTypeBroadcast',
],
'-;' => [
'_' => 'inlineQueryPeerTypeBotPM',
],
'r0' => $this->deserialize_type_InlineQueryPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_keyboardButtonSwitchInline(mixed $stream): mixed {
$tmp = ['_' => 'keyboardButtonSwitchInline'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['same_peer'] = ($flags & 1) !== 0;
$tmp['text'] = self::deserialize_string($stream);
$tmp['query'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['peer_types'] = self::deserialize_type_array_of_InlineQueryPeerType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_keyboardButtonUrlAuth(mixed $stream): mixed {
$tmp = ['_' => 'keyboardButtonUrlAuth'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['text'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['fwd_text'] = self::deserialize_string($stream);
$tmp['url'] = self::deserialize_string($stream);
$tmp['button_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_inputKeyboardButtonUrlAuth(mixed $stream): mixed {
$tmp = ['_' => 'inputKeyboardButtonUrlAuth'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['request_write_access'] = ($flags & 1) !== 0;
$tmp['text'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['fwd_text'] = self::deserialize_string($stream);
$tmp['url'] = self::deserialize_string($stream);
$tmp['bot'] = match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_keyboardButtonRequestPoll(mixed $stream): mixed {
$tmp = ['_' => 'keyboardButtonRequestPoll'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['quiz'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
$tmp['text'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_requestPeerTypeUser(mixed $stream): mixed {
$tmp = ['_' => 'requestPeerTypeUser'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['bot'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 2) !== 0) $tmp['premium'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
return $tmp;

    }
    private  function deserialize_requestPeerTypeChat(mixed $stream): mixed {
$tmp = ['_' => 'requestPeerTypeChat'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
$tmp['bot_participant'] = ($flags & 32) !== 0;
if (($flags & 8) !== 0) $tmp['has_username'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 16) !== 0) $tmp['forum'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 2) !== 0) $tmp['user_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['bot_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_requestPeerTypeBroadcast(mixed $stream): mixed {
$tmp = ['_' => 'requestPeerTypeBroadcast'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
if (($flags & 8) !== 0) $tmp['has_username'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 2) !== 0) $tmp['user_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['bot_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_RequestPeerType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' . "\0" . ';_' => self::deserialize_requestPeerTypeUser($stream),
'n' => self::deserialize_requestPeerTypeChat($stream),
'l3' => self::deserialize_requestPeerTypeBroadcast($stream),
'r0' => $this->deserialize_type_RequestPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_KeyboardButton(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'H' => [
'_' => 'keyboardButton',
'text' => self::deserialize_string($stream),
],
'%' => [
'_' => 'keyboardButtonUrl',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'kۻ5' => self::deserialize_keyboardButtonCallback($stream),
')lj' => [
'_' => 'keyboardButtonRequestPhone',
'text' => self::deserialize_string($stream),
],
'?ky' => [
'_' => 'keyboardButtonRequestGeoLocation',
'text' => self::deserialize_string($stream),
],
'' => self::deserialize_keyboardButtonSwitchInline($stream),
'P' => [
'_' => 'keyboardButtonGame',
'text' => self::deserialize_string($stream),
],
'?ٯ' => [
'_' => 'keyboardButtonBuy',
'text' => self::deserialize_string($stream),
],
')' => self::deserialize_keyboardButtonUrlAuth($stream),
'.' => self::deserialize_inputKeyboardButtonUrlAuth($stream),
']Qǻ' => self::deserialize_keyboardButtonRequestPoll($stream),
'{' => [
'_' => 'inputKeyboardButtonUserProfile',
'text' => self::deserialize_string($stream),
'user_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'`0' => [
'_' => 'keyboardButtonUserProfile',
'text' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'0rv' => [
'_' => 'keyboardButtonWebView',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'\\P' => [
'_' => 'keyboardButtonSimpleWebView',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'ؿS' => [
'_' => 'keyboardButtonRequestPeer',
'text' => self::deserialize_string($stream),
'button_id' => unpack('l', stream_get_contents($stream, 4))[1],
'peer_type' => match (stream_get_contents($stream, 4)) {
'' . "\0" . ';_' => self::deserialize_requestPeerTypeUser($stream),
'n' => self::deserialize_requestPeerTypeChat($stream),
'l3' => self::deserialize_requestPeerTypeBroadcast($stream),
'r0' => self::deserialize_type_RequestPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_quantity' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_KeyboardButton(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_KeyboardButtonRow(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'`w' => [
'_' => 'keyboardButtonRow',
'buttons' => self::deserialize_type_array_of_KeyboardButton(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_KeyboardButtonRow(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_replyKeyboardMarkup(mixed $stream): mixed {
$tmp = ['_' => 'replyKeyboardMarkup'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['resize'] = ($flags & 1) !== 0;
$tmp['single_use'] = ($flags & 2) !== 0;
$tmp['selective'] = ($flags & 4) !== 0;
$tmp['persistent'] = ($flags & 16) !== 0;
$tmp['rows'] = self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 8) !== 0) $tmp['placeholder'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_ReplyMarkup(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageReplies(mixed $stream): mixed {
$tmp = ['_' => 'messageReplies'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['comments'] = ($flags & 1) !== 0;
$tmp['replies'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['replies_pts'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['recent_repliers'] = self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 4) !== 0) $tmp['max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['read_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_MessageReplies(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'փ' => self::deserialize_messageReplies($stream),
'r0' => $this->deserialize_type_MessageReplies(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messagePeerReaction(mixed $stream): mixed {
$tmp = ['_' => 'messagePeerReaction'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['big'] = ($flags & 1) !== 0;
$tmp['unread'] = ($flags & 2) !== 0;
$tmp['my'] = ($flags & 4) !== 0;
$tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_MessagePeerReaction(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'<y' => self::deserialize_messagePeerReaction($stream),
'r0' => $this->deserialize_type_MessagePeerReaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messageReactions(mixed $stream): mixed {
$tmp = ['_' => 'messageReactions'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['min'] = ($flags & 1) !== 0;
$tmp['can_see_list'] = ($flags & 4) !== 0;
$tmp['reactions_as_tags'] = ($flags & 8) !== 0;
$tmp['results'] = self::deserialize_type_array_of_ReactionCount(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['recent_reactions'] = self::deserialize_type_array_of_MessagePeerReaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_MessageReactions(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'y+O' => self::deserialize_messageReactions($stream),
'r0' => $this->deserialize_type_MessageReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_message(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('message');
$this->minDatabase?->addOriginContext('message');
$tmp = ['_' => 'message'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['out'] = ($flags & 2) !== 0;
$tmp['mentioned'] = ($flags & 16) !== 0;
$tmp['media_unread'] = ($flags & 32) !== 0;
$tmp['silent'] = ($flags & 8192) !== 0;
$tmp['post'] = ($flags & 16384) !== 0;
$tmp['from_scheduled'] = ($flags & 262144) !== 0;
$tmp['legacy'] = ($flags & 524288) !== 0;
$tmp['edit_hide'] = ($flags & 2097152) !== 0;
$tmp['pinned'] = ($flags & 16777216) !== 0;
$tmp['noforwards'] = ($flags & 67108864) !== 0;
$tmp['invert_media'] = ($flags & 134217728) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 536870912) !== 0) $tmp['from_boosts_applied'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 268435456) !== 0) $tmp['saved_peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['fwd_from'] = match (stream_get_contents($stream, 4)) {
'MN' => self::deserialize_messageFwdHeader($stream),
'r0' => self::deserialize_type_MessageFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2048) !== 0) $tmp['via_bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['reply_to'] = match (stream_get_contents($stream, 4)) {
'	' => self::deserialize_messageReplyHeader($stream),
'9Z' => [
'_' => 'messageReplyStoryHeader',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_MessageReplyHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['media'] = match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1024) !== 0) $tmp['views'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1024) !== 0) $tmp['forwards'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8388608) !== 0) $tmp['replies'] = match (stream_get_contents($stream, 4)) {
'փ' => self::deserialize_messageReplies($stream),
'r0' => self::deserialize_type_MessageReplies(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32768) !== 0) $tmp['edit_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 65536) !== 0) $tmp['post_author'] = self::deserialize_string($stream);
if (($flags & 131072) !== 0) $tmp['grouped_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1048576) !== 0) $tmp['reactions'] = match (stream_get_contents($stream, 4)) {
'y+O' => self::deserialize_messageReactions($stream),
'r0' => self::deserialize_type_MessageReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4194304) !== 0) $tmp['restriction_reason'] = self::deserialize_type_array_of_RestrictionReason(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 33554432) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1073741824) !== 0) $tmp['quick_reply_shortcut_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$this->referenceDatabase?->addOrigin($tmp);
$this->minDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_messageActionChatCreate(mixed $stream): mixed {
$tmp = [
'_' => 'messageActionChatCreate',
'title' => self::deserialize_string($stream),
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_messageActionChatAddUser(mixed $stream): mixed {
$tmp = [
'_' => 'messageActionChatAddUser',
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_messageActionChatDeleteUser(mixed $stream): mixed {
$tmp = [
'_' => 'messageActionChatDeleteUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_messageActionChatJoinedByLink(mixed $stream): mixed {
$tmp = [
'_' => 'messageActionChatJoinedByLink',
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->minDatabase?->addPeer($tmp);
return $tmp;

    }
    private  function deserialize_type_PostAddress(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'몌' => [
'_' => 'postAddress',
'street_line1' => self::deserialize_string($stream),
'street_line2' => self::deserialize_string($stream),
'city' => self::deserialize_string($stream),
'state' => self::deserialize_string($stream),
'country_iso2' => self::deserialize_string($stream),
'post_code' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_PostAddress(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_paymentRequestedInfo(mixed $stream): mixed {
$tmp = ['_' => 'paymentRequestedInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['name'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['phone'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['email'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['shipping_address'] = match (stream_get_contents($stream, 4)) {
'몌' => [
'_' => 'postAddress',
'street_line1' => self::deserialize_string($stream),
'street_line2' => self::deserialize_string($stream),
'city' => self::deserialize_string($stream),
'state' => self::deserialize_string($stream),
'country_iso2' => self::deserialize_string($stream),
'post_code' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_PostAddress(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_PaymentRequestedInfo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => $this->deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_PaymentCharge(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'paymentCharge',
'id' => self::deserialize_string($stream),
'provider_charge_id' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_PaymentCharge(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageActionPaymentSentMe(mixed $stream): mixed {
$tmp = ['_' => 'messageActionPaymentSentMe'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['recurring_init'] = ($flags & 4) !== 0;
$tmp['recurring_used'] = ($flags & 8) !== 0;
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['payload'] = self::deserialize_bytes($stream);
if (($flags & 1) !== 0) $tmp['info'] = match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => self::deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['shipping_option_id'] = self::deserialize_string($stream);
$tmp['charge'] = match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'paymentCharge',
'id' => self::deserialize_string($stream),
'provider_charge_id' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_PaymentCharge(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageActionPaymentSent(mixed $stream): mixed {
$tmp = ['_' => 'messageActionPaymentSent'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['recurring_init'] = ($flags & 4) !== 0;
$tmp['recurring_used'] = ($flags & 8) !== 0;
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['invoice_slug'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_PhoneCallDiscardReason(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'phoneCallDiscardReasonMissed',
],
'' => [
'_' => 'phoneCallDiscardReasonDisconnect',
],
'ƭW' => [
'_' => 'phoneCallDiscardReasonHangup',
],
'' => [
'_' => 'phoneCallDiscardReasonBusy',
],
'r0' => $this->deserialize_type_PhoneCallDiscardReason(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageActionPhoneCall(mixed $stream): mixed {
$tmp = ['_' => 'messageActionPhoneCall'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['video'] = ($flags & 4) !== 0;
$tmp['call_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['reason'] = match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'phoneCallDiscardReasonMissed',
],
'' => [
'_' => 'phoneCallDiscardReasonDisconnect',
],
'ƭW' => [
'_' => 'phoneCallDiscardReasonHangup',
],
'' => [
'_' => 'phoneCallDiscardReasonBusy',
],
'r0' => self::deserialize_type_PhoneCallDiscardReason(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_botApp(mixed $stream): mixed {
$tmp = ['_' => 'botApp'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['short_name'] = self::deserialize_string($stream);
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
$tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['hash'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_BotApp(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
't]' => [
'_' => 'botAppNotModified',
],
'' => self::deserialize_botApp($stream),
'r0' => $this->deserialize_type_BotApp(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageActionBotAllowed(mixed $stream): mixed {
$tmp = ['_' => 'messageActionBotAllowed'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['attach_menu'] = ($flags & 2) !== 0;
$tmp['from_request'] = ($flags & 8) !== 0;
if (($flags & 1) !== 0) $tmp['domain'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['app'] = match (stream_get_contents($stream, 4)) {
't]' => [
'_' => 'botAppNotModified',
],
'' => self::deserialize_botApp($stream),
'r0' => self::deserialize_type_BotApp(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_SecureValueType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => $this->deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_SecureData(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'þ' => [
'_' => 'secureData',
'data' => self::deserialize_bytes($stream),
'data_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_SecureData(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_SecureFile(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Dd' => [
'_' => 'secureFileEmpty',
],
'~	}' => [
'_' => 'secureFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'file_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_SecureFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_SecureFile(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Dd' => [
'_' => 'secureFileEmpty',
],
'~	}' => [
'_' => 'secureFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'file_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_SecurePlainData(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ݙ`}' => [
'_' => 'securePlainPhone',
'phone' => self::deserialize_string($stream),
],
'_Z!' => [
'_' => 'securePlainEmail',
'email' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_SecurePlainData(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_secureValue(mixed $stream): mixed {
$tmp = ['_' => 'secureValue'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['type'] = match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['data'] = match (stream_get_contents($stream, 4)) {
'þ' => [
'_' => 'secureData',
'data' => self::deserialize_bytes($stream),
'data_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureData(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['front_side'] = match (stream_get_contents($stream, 4)) {
'Dd' => [
'_' => 'secureFileEmpty',
],
'~	}' => [
'_' => 'secureFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'file_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['reverse_side'] = match (stream_get_contents($stream, 4)) {
'Dd' => [
'_' => 'secureFileEmpty',
],
'~	}' => [
'_' => 'secureFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'file_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['selfie'] = match (stream_get_contents($stream, 4)) {
'Dd' => [
'_' => 'secureFileEmpty',
],
'~	}' => [
'_' => 'secureFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'file_hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['translation'] = self::deserialize_type_array_of_SecureFile(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['files'] = self::deserialize_type_array_of_SecureFile(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 32) !== 0) $tmp['plain_data'] = match (stream_get_contents($stream, 4)) {
'ݙ`}' => [
'_' => 'securePlainPhone',
'phone' => self::deserialize_string($stream),
],
'_Z!' => [
'_' => 'securePlainEmail',
'email' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SecurePlainData(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['hash'] = self::deserialize_bytes($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_SecureValue(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ʠ' => self::deserialize_secureValue($stream),
'r0' => $this->deserialize_type_SecureValue(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_SecureCredentialsEncrypted(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'G3' => [
'_' => 'secureCredentialsEncrypted',
'data' => self::deserialize_bytes($stream),
'hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_SecureCredentialsEncrypted(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_SecureValueType(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_InputGroupCall(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageActionGroupCall(mixed $stream): mixed {
$tmp = ['_' => 'messageActionGroupCall'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['call'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_messageActionSetMessagesTTL(mixed $stream): mixed {
$tmp = ['_' => 'messageActionSetMessagesTTL'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['auto_setting_from'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_messageActionGiftPremium(mixed $stream): mixed {
$tmp = ['_' => 'messageActionGiftPremium'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['currency'] = self::deserialize_string($stream);
$tmp['amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['crypto_currency'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['crypto_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_messageActionTopicCreate(mixed $stream): mixed {
$tmp = ['_' => 'messageActionTopicCreate'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['icon_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['icon_emoji_id'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_messageActionTopicEdit(mixed $stream): mixed {
$tmp = ['_' => 'messageActionTopicEdit'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['icon_emoji_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 4) !== 0) $tmp['closed'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 8) !== 0) $tmp['hidden'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
return $tmp;

    }
    private  function deserialize_messageActionSetChatWallPaper(mixed $stream): mixed {
$tmp = ['_' => 'messageActionSetChatWallPaper'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['same'] = ($flags & 1) !== 0;
$tmp['for_both'] = ($flags & 2) !== 0;
$tmp['wallpaper'] = match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messageActionGiftCode(mixed $stream): mixed {
$tmp = ['_' => 'messageActionGiftCode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_giveaway'] = ($flags & 1) !== 0;
$tmp['unclaimed'] = ($flags & 4) !== 0;
if (($flags & 2) !== 0) $tmp['boost_peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['slug'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['currency'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['amount'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['crypto_currency'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['crypto_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_MessageAction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'messageActionEmpty',
],
'G' => self::deserialize_messageActionChatCreate($stream),
'ZΡ' => [
'_' => 'messageActionChatEditTitle',
'title' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageActionChatEditPhoto',
'photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'messageActionChatDeletePhoto',
],
'' . "\0" . '' => self::deserialize_messageActionChatAddUser($stream),
'0?' => self::deserialize_messageActionChatDeleteUser($stream),
'$' => self::deserialize_messageActionChatJoinedByLink($stream),
'ҕ' => [
'_' => 'messageActionChannelCreate',
'title' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageActionChatMigrateTo',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H9' => [
'_' => 'messageActionChannelMigrateFrom',
'title' => self::deserialize_string($stream),
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'8' => [
'_' => 'messageActionPinMessage',
],
'' => [
'_' => 'messageActionHistoryClear',
],
'v(' => [
'_' => 'messageActionGameScore',
'game_id' => unpack('q', stream_get_contents($stream, 8))[1],
'score' => unpack('l', stream_get_contents($stream, 4))[1],
],
'\'1' => self::deserialize_messageActionPaymentSentMe($stream),
'V?' => self::deserialize_messageActionPaymentSent($stream),
'' => self::deserialize_messageActionPhoneCall($stream),
'G' => [
'_' => 'messageActionScreenshotTaken',
],
'V' => [
'_' => 'messageActionCustomAction',
'message' => self::deserialize_string($stream),
],
'y' => self::deserialize_messageActionBotAllowed($stream),
'Ss(' => [
'_' => 'messageActionSecureValuesSentMe',
'values' => self::deserialize_type_array_of_SecureValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'credentials' => match (stream_get_contents($stream, 4)) {
'G3' => [
'_' => 'secureCredentialsEncrypted',
'data' => self::deserialize_bytes($stream),
'hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureCredentialsEncrypted(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ta\\' => [
'_' => 'messageActionSecureValuesSent',
'types' => self::deserialize_type_array_of_SecureValueType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'v_' => [
'_' => 'messageActionContactSignUp',
],
'' => [
'_' => 'messageActionGeoProximityReached',
'from_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'to_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'distance' => unpack('l', stream_get_contents($stream, 4))[1],
],
'B
z' => self::deserialize_messageActionGroupCall($stream),
'/P' => [
'_' => 'messageActionInviteToGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'{M<' => self::deserialize_messageActionSetMessagesTTL($stream),
'av' => [
'_' => 'messageActionGroupCallScheduled',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'schedule_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ecx' => [
'_' => 'messageActionSetChatTheme',
'emoticon' => self::deserialize_string($stream),
],
'ˣ' => [
'_' => 'messageActionChatJoinedByRequest',
],
'yG' => [
'_' => 'messageActionWebViewDataSentMe',
'text' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'ô' => [
'_' => 'messageActionWebViewDataSent',
'text' => self::deserialize_string($stream),
],
'j=' => self::deserialize_messageActionGiftPremium($stream),
'V
' => self::deserialize_messageActionTopicCreate($stream),
' H' => self::deserialize_messageActionTopicEdit($stream),
'^cW' => [
'_' => 'messageActionSuggestProfilePhoto',
'photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q1' => [
'_' => 'messageActionRequestedPeer',
'button_id' => unpack('l', stream_get_contents($stream, 4))[1],
'peers' => self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'`P' => self::deserialize_messageActionSetChatWallPaper($stream),
'	.g' => self::deserialize_messageActionGiftCode($stream),
'+3' => [
'_' => 'messageActionGiveawayLaunch',
],
'ŭ*' => [
'_' => 'messageActionGiveawayResults',
'winners_count' => unpack('l', stream_get_contents($stream, 4))[1],
'unclaimed_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'm' => [
'_' => 'messageActionBoostApply',
'boosts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messageService(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('messageService');
$this->minDatabase?->addOriginContext('messageService');
$tmp = ['_' => 'messageService'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['out'] = ($flags & 2) !== 0;
$tmp['mentioned'] = ($flags & 16) !== 0;
$tmp['media_unread'] = ($flags & 32) !== 0;
$tmp['silent'] = ($flags & 8192) !== 0;
$tmp['post'] = ($flags & 16384) !== 0;
$tmp['legacy'] = ($flags & 524288) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['reply_to'] = match (stream_get_contents($stream, 4)) {
'	' => self::deserialize_messageReplyHeader($stream),
'9Z' => [
'_' => 'messageReplyStoryHeader',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_MessageReplyHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['action'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'messageActionEmpty',
],
'G' => self::deserialize_messageActionChatCreate($stream),
'ZΡ' => [
'_' => 'messageActionChatEditTitle',
'title' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageActionChatEditPhoto',
'photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'messageActionChatDeletePhoto',
],
'' . "\0" . '' => self::deserialize_messageActionChatAddUser($stream),
'0?' => self::deserialize_messageActionChatDeleteUser($stream),
'$' => self::deserialize_messageActionChatJoinedByLink($stream),
'ҕ' => [
'_' => 'messageActionChannelCreate',
'title' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageActionChatMigrateTo',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H9' => [
'_' => 'messageActionChannelMigrateFrom',
'title' => self::deserialize_string($stream),
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'8' => [
'_' => 'messageActionPinMessage',
],
'' => [
'_' => 'messageActionHistoryClear',
],
'v(' => [
'_' => 'messageActionGameScore',
'game_id' => unpack('q', stream_get_contents($stream, 8))[1],
'score' => unpack('l', stream_get_contents($stream, 4))[1],
],
'\'1' => self::deserialize_messageActionPaymentSentMe($stream),
'V?' => self::deserialize_messageActionPaymentSent($stream),
'' => self::deserialize_messageActionPhoneCall($stream),
'G' => [
'_' => 'messageActionScreenshotTaken',
],
'V' => [
'_' => 'messageActionCustomAction',
'message' => self::deserialize_string($stream),
],
'y' => self::deserialize_messageActionBotAllowed($stream),
'Ss(' => [
'_' => 'messageActionSecureValuesSentMe',
'values' => self::deserialize_type_array_of_SecureValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'credentials' => match (stream_get_contents($stream, 4)) {
'G3' => [
'_' => 'secureCredentialsEncrypted',
'data' => self::deserialize_bytes($stream),
'hash' => self::deserialize_bytes($stream),
'secret' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecureCredentialsEncrypted(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ta\\' => [
'_' => 'messageActionSecureValuesSent',
'types' => self::deserialize_type_array_of_SecureValueType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'v_' => [
'_' => 'messageActionContactSignUp',
],
'' => [
'_' => 'messageActionGeoProximityReached',
'from_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'to_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'distance' => unpack('l', stream_get_contents($stream, 4))[1],
],
'B
z' => self::deserialize_messageActionGroupCall($stream),
'/P' => [
'_' => 'messageActionInviteToGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'users' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'{M<' => self::deserialize_messageActionSetMessagesTTL($stream),
'av' => [
'_' => 'messageActionGroupCallScheduled',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'schedule_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ecx' => [
'_' => 'messageActionSetChatTheme',
'emoticon' => self::deserialize_string($stream),
],
'ˣ' => [
'_' => 'messageActionChatJoinedByRequest',
],
'yG' => [
'_' => 'messageActionWebViewDataSentMe',
'text' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'ô' => [
'_' => 'messageActionWebViewDataSent',
'text' => self::deserialize_string($stream),
],
'j=' => self::deserialize_messageActionGiftPremium($stream),
'V
' => self::deserialize_messageActionTopicCreate($stream),
' H' => self::deserialize_messageActionTopicEdit($stream),
'^cW' => [
'_' => 'messageActionSuggestProfilePhoto',
'photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Q1' => [
'_' => 'messageActionRequestedPeer',
'button_id' => unpack('l', stream_get_contents($stream, 4))[1],
'peers' => self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'`P' => self::deserialize_messageActionSetChatWallPaper($stream),
'	.g' => self::deserialize_messageActionGiftCode($stream),
'+3' => [
'_' => 'messageActionGiveawayLaunch',
],
'ŭ*' => [
'_' => 'messageActionGiveawayResults',
'winners_count' => unpack('l', stream_get_contents($stream, 4))[1],
'unclaimed_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'm' => [
'_' => 'messageActionBoostApply',
'boosts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_MessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 33554432) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
$this->referenceDatabase?->addOrigin($tmp);
$this->minDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_Message(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => $this->deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_DataJSON(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => $this->deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_SendMessageAction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_ChatParticipant(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'@-' => [
'_' => 'chatParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'k' => [
'_' => 'chatParticipantCreator',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'[?' => [
'_' => 'chatParticipantAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_ChatParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_chatParticipantsForbidden(mixed $stream): mixed {
$tmp = ['_' => 'chatParticipantsForbidden'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['self_participant'] = match (stream_get_contents($stream, 4)) {
'@-' => [
'_' => 'chatParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'k' => [
'_' => 'chatParticipantCreator',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'[?' => [
'_' => 'chatParticipantAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_ChatParticipant(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'@-' => [
'_' => 'chatParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'k' => [
'_' => 'chatParticipantCreator',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'[?' => [
'_' => 'chatParticipantAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_ChatParticipants(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'c' => self::deserialize_chatParticipantsForbidden($stream),
'<' => [
'_' => 'chatParticipants',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participants' => self::deserialize_type_array_of_ChatParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_ChatParticipants(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_userStatusRecently(mixed $stream): mixed {
$tmp = ['_' => 'userStatusRecently'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['by_me'] = ($flags & 1) !== 0;
return $tmp;

    }
    private  function deserialize_userStatusLastWeek(mixed $stream): mixed {
$tmp = ['_' => 'userStatusLastWeek'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['by_me'] = ($flags & 1) !== 0;
return $tmp;

    }
    private  function deserialize_userStatusLastMonth(mixed $stream): mixed {
$tmp = ['_' => 'userStatusLastMonth'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['by_me'] = ($flags & 1) !== 0;
return $tmp;

    }
    private  function deserialize_type_UserStatus(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'IP	' => [
'_' => 'userStatusEmpty',
],
'I9' => [
'_' => 'userStatusOnline',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?p' . "\0" . '' => [
'_' => 'userStatusOffline',
'was_online' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}{' => self::deserialize_userStatusRecently($stream),
'T' => self::deserialize_userStatusLastWeek($stream),
'we' => self::deserialize_userStatusLastMonth($stream),
'r0' => $this->deserialize_type_UserStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateNewAuthorization(mixed $stream): mixed {
$tmp = ['_' => 'updateNewAuthorization'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['unconfirmed'] = ($flags & 1) !== 0;
$tmp['hash'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['device'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['location'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_EncryptedFile(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_EncryptedMessage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'encryptedMessage',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
'file' => match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ks#' => [
'_' => 'encryptedMessageService',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_EncryptedMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_encryptedChatRequested(mixed $stream): mixed {
$tmp = ['_' => 'encryptedChatRequested'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participant_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['g_a'] = self::deserialize_bytes($stream);
return $tmp;

    }
    private  function deserialize_encryptedChatDiscarded(mixed $stream): mixed {
$tmp = ['_' => 'encryptedChatDiscarded'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['history_deleted'] = ($flags & 1) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_EncryptedChat(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'encryptedChatEmpty',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SYf' => [
'_' => 'encryptedChatWaiting',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'LH' => self::deserialize_encryptedChatRequested($stream),
'a' => [
'_' => 'encryptedChat',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a_or_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'E|' => self::deserialize_encryptedChatDiscarded($stream),
'r0' => $this->deserialize_type_EncryptedChat(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_dcOption(mixed $stream): mixed {
$tmp = ['_' => 'dcOption'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['ipv6'] = ($flags & 1) !== 0;
$tmp['media_only'] = ($flags & 2) !== 0;
$tmp['tcpo_only'] = ($flags & 4) !== 0;
$tmp['cdn'] = ($flags & 8) !== 0;
$tmp['static'] = ($flags & 16) !== 0;
$tmp['this_port_only'] = ($flags & 32) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['ip_address'] = self::deserialize_string($stream);
$tmp['port'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1024) !== 0) $tmp['secret'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_DcOption(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_dcOption($stream),
'r0' => $this->deserialize_type_DcOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_NotifyPeer(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ԟ' => [
'_' => 'notifyPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'L;ȴ' => [
'_' => 'notifyUsers',
],
'' => [
'_' => 'notifyChats',
],
'' => [
'_' => 'notifyBroadcasts',
],
'cn"' => [
'_' => 'notifyForumTopic',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_NotifyPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_NotificationSound(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_peerNotifySettings(mixed $stream): mixed {
$tmp = ['_' => 'peerNotifySettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['show_previews'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 2) !== 0) $tmp['silent'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 4) !== 0) $tmp['mute_until'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['ios_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['android_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['other_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['stories_muted'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 128) !== 0) $tmp['stories_hide_sender'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
if (($flags & 256) !== 0) $tmp['stories_ios_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 512) !== 0) $tmp['stories_android_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1024) !== 0) $tmp['stories_other_sound'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'notificationSoundDefault',
],
'4o' => [
'_' => 'notificationSoundNone',
],
'' => [
'_' => 'notificationSoundLocal',
'title' => self::deserialize_string($stream),
'data' => self::deserialize_string($stream),
],
'Il' => [
'_' => 'notificationSoundRingtone',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_NotificationSound(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_PeerNotifySettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => $this->deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateServiceNotification(mixed $stream): mixed {
$tmp = ['_' => 'updateServiceNotification'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['popup'] = ($flags & 1) !== 0;
$tmp['invert_media'] = ($flags & 4) !== 0;
if (($flags & 2) !== 0) $tmp['inbox_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['type'] = self::deserialize_string($stream);
$tmp['message'] = self::deserialize_string($stream);
$tmp['media'] = match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_PrivacyKey(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'0.' => [
'_' => 'privacyKeyStatusTimestamp',
],
'mP' => [
'_' => 'privacyKeyChatInvite',
],
'{+f=' => [
'_' => 'privacyKeyPhoneCall',
],
'I9' => [
'_' => 'privacyKeyPhoneP2P',
],
'Vi' => [
'_' => 'privacyKeyForwards',
],
'' => [
'_' => 'privacyKeyProfilePhoto',
],
'm' => [
'_' => 'privacyKeyPhoneNumber',
],
'+B' => [
'_' => 'privacyKeyAddedByPhone',
],
'' => [
'_' => 'privacyKeyVoiceMessages',
],
'a' => [
'_' => 'privacyKeyAbout',
],
'r0' => $this->deserialize_type_PrivacyKey(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateReadHistoryInbox(mixed $stream): mixed {
$tmp = ['_' => 'updateReadHistoryInbox'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['still_unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateReadMessagesContents(mixed $stream): mixed {
$tmp = ['_' => 'updateReadMessagesContents'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateChannelTooLong(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelTooLong'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateReadChannelInbox(mixed $stream): mixed {
$tmp = ['_' => 'updateReadChannelInbox'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['still_unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_stickerSet(mixed $stream): mixed {
$tmp = ['_' => 'stickerSet'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['archived'] = ($flags & 2) !== 0;
$tmp['official'] = ($flags & 4) !== 0;
$tmp['masks'] = ($flags & 8) !== 0;
$tmp['animated'] = ($flags & 32) !== 0;
$tmp['videos'] = ($flags & 64) !== 0;
$tmp['emojis'] = ($flags & 128) !== 0;
$tmp['text_color'] = ($flags & 512) !== 0;
$tmp['channel_emoji_status'] = ($flags & 1024) !== 0;
if (($flags & 1) !== 0) $tmp['installed_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['short_name'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['thumbs'] = self::deserialize_type_array_of_PhotoSize(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['thumb_dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['thumb_version'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['thumb_document_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['hash'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_StickerSet(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => $this->deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_StickerPack(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ԙ' => [
'_' => 'stickerPack',
'emoticon' => self::deserialize_string($stream),
'documents' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_StickerPack(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_StickerKeyword(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'stickerKeyword',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'keyword' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_StickerKeyword(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___stickerSet(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('messages.stickerSet');
$tmp = [
'_' => 'messages.stickerSet',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'keywords' => self::deserialize_type_array_of_StickerKeyword(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'documents' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_messages___StickerSet(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'?n' => self::deserialize_messages___stickerSet($stream),
'$' => [
'_' => 'messages.stickerSetNotModified',
],
'r0' => $this->deserialize_type_messages___StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateStickerSetsOrder(mixed $stream): mixed {
$tmp = ['_' => 'updateStickerSetsOrder'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['masks'] = ($flags & 1) !== 0;
$tmp['emojis'] = ($flags & 2) !== 0;
$tmp['order'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_updateStickerSets(mixed $stream): mixed {
$tmp = ['_' => 'updateStickerSets'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['masks'] = ($flags & 1) !== 0;
$tmp['emojis'] = ($flags & 2) !== 0;
return $tmp;

    }
    private  function deserialize_type_InlineQueryPeerType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'0' => [
'_' => 'inlineQueryPeerTypeSameBotPM',
],
'<' => [
'_' => 'inlineQueryPeerTypePM',
],
'
f' => [
'_' => 'inlineQueryPeerTypeChat',
],
'C^' => [
'_' => 'inlineQueryPeerTypeMegagroup',
],
'4c' => [
'_' => 'inlineQueryPeerTypeBroadcast',
],
'-;' => [
'_' => 'inlineQueryPeerTypeBotPM',
],
'r0' => $this->deserialize_type_InlineQueryPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateBotInlineQuery(mixed $stream): mixed {
$tmp = ['_' => 'updateBotInlineQuery'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['query_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['query'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['geo'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['peer_type'] = match (stream_get_contents($stream, 4)) {
'0' => [
'_' => 'inlineQueryPeerTypeSameBotPM',
],
'<' => [
'_' => 'inlineQueryPeerTypePM',
],
'
f' => [
'_' => 'inlineQueryPeerTypeChat',
],
'C^' => [
'_' => 'inlineQueryPeerTypeMegagroup',
],
'4c' => [
'_' => 'inlineQueryPeerTypeBroadcast',
],
'-;' => [
'_' => 'inlineQueryPeerTypeBotPM',
],
'r0' => self::deserialize_type_InlineQueryPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['offset'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_InputBotInlineMessageID(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'=' => [
'_' => 'inputBotInlineMessageID',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ٶ' => [
'_' => 'inputBotInlineMessageID64',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'owner_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_InputBotInlineMessageID(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateBotInlineSend(mixed $stream): mixed {
$tmp = ['_' => 'updateBotInlineSend'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['query'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['geo'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['id'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['msg_id'] = match (stream_get_contents($stream, 4)) {
'=' => [
'_' => 'inputBotInlineMessageID',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ٶ' => [
'_' => 'inputBotInlineMessageID64',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'owner_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputBotInlineMessageID(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updateBotCallbackQuery(mixed $stream): mixed {
$tmp = ['_' => 'updateBotCallbackQuery'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['query_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['chat_instance'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['data'] = self::deserialize_bytes($stream);
if (($flags & 2) !== 0) $tmp['game_short_name'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_updateInlineBotCallbackQuery(mixed $stream): mixed {
$tmp = ['_' => 'updateInlineBotCallbackQuery'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['query_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['msg_id'] = match (stream_get_contents($stream, 4)) {
'=' => [
'_' => 'inputBotInlineMessageID',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ٶ' => [
'_' => 'inputBotInlineMessageID64',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'owner_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputBotInlineMessageID(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['chat_instance'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['data'] = self::deserialize_bytes($stream);
if (($flags & 2) !== 0) $tmp['game_short_name'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_draftMessageEmpty(mixed $stream): mixed {
$tmp = ['_' => 'draftMessageEmpty'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_inputReplyToMessage(mixed $stream): mixed {
$tmp = ['_' => 'inputReplyToMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['reply_to_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['reply_to_peer_id'] = match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['quote_text'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['quote_entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['quote_offset'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_InputReplyTo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'"' => self::deserialize_inputReplyToMessage($stream),
':2X' => [
'_' => 'inputReplyToStory',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_InputReplyTo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputFile(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'/' => [
'_' => 'inputFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
'md5_checksum' => self::deserialize_string($stream),
],
'O' => [
'_' => 'inputFileBig',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_InputFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_InputDocument(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'inputDocumentEmpty',
],
'u' => [
'_' => 'inputDocument',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'file_reference' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_InputDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_inputMediaUploadedPhoto(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaUploadedPhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 4) !== 0;
$tmp['file'] = match (stream_get_contents($stream, 4)) {
'/' => [
'_' => 'inputFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
'md5_checksum' => self::deserialize_string($stream),
],
'O' => [
'_' => 'inputFileBig',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InputFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['stickers'] = self::deserialize_type_array_of_InputDocument(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_InputPhoto(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
' => [
'_' => 'inputPhotoEmpty',
],
'J;' => [
'_' => 'inputPhoto',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'file_reference' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_InputPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_inputMediaPhoto(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaPhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 2) !== 0;
$tmp['id'] = match (stream_get_contents($stream, 4)) {
'
' => [
'_' => 'inputPhotoEmpty',
],
'J;' => [
'_' => 'inputPhoto',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'file_reference' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_InputPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_inputGeoPoint(mixed $stream): mixed {
$tmp = ['_' => 'inputGeoPoint'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['lat'] = unpack('d', stream_get_contents($stream, 8))[1];
$tmp['long'] = unpack('d', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['accuracy_radius'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_InputGeoPoint(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => $this->deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_inputMediaUploadedDocument(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaUploadedDocument'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['nosound_video'] = ($flags & 8) !== 0;
$tmp['force_file'] = ($flags & 16) !== 0;
$tmp['spoiler'] = ($flags & 32) !== 0;
$tmp['file'] = match (stream_get_contents($stream, 4)) {
'/' => [
'_' => 'inputFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
'md5_checksum' => self::deserialize_string($stream),
],
'O' => [
'_' => 'inputFileBig',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InputFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['thumb'] = match (stream_get_contents($stream, 4)) {
'/' => [
'_' => 'inputFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
'md5_checksum' => self::deserialize_string($stream),
],
'O' => [
'_' => 'inputFileBig',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'parts' => unpack('l', stream_get_contents($stream, 4))[1],
'name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InputFile(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['mime_type'] = self::deserialize_string($stream);
$tmp['attributes'] = self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['stickers'] = self::deserialize_type_array_of_InputDocument(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_InputDocument(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'inputDocumentEmpty',
],
'u' => [
'_' => 'inputDocument',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'file_reference' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_InputDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_inputMediaDocument(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaDocument'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 4) !== 0;
$tmp['id'] = match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'inputDocumentEmpty',
],
'u' => [
'_' => 'inputDocument',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'file_reference' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_InputDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['query'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_inputMediaPhotoExternal(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaPhotoExternal'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 2) !== 0;
$tmp['url'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_inputMediaDocumentExternal(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaDocumentExternal'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['spoiler'] = ($flags & 2) !== 0;
$tmp['url'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['ttl_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_InputGame(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'w>,' => [
'_' => 'inputGameID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
1' => [
'_' => 'inputGameShortName',
'bot_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
'short_name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_InputGame(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InputWebDocument(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'MC' => [
'_' => 'inputWebDocument',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_InputWebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_LabeledPrice(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'k)' => [
'_' => 'labeledPrice',
'label' => self::deserialize_string($stream),
'amount' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_LabeledPrice(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_invoice(mixed $stream): mixed {
$tmp = ['_' => 'invoice'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['test'] = ($flags & 1) !== 0;
$tmp['name_requested'] = ($flags & 2) !== 0;
$tmp['phone_requested'] = ($flags & 4) !== 0;
$tmp['email_requested'] = ($flags & 8) !== 0;
$tmp['shipping_address_requested'] = ($flags & 16) !== 0;
$tmp['flexible'] = ($flags & 32) !== 0;
$tmp['phone_to_provider'] = ($flags & 64) !== 0;
$tmp['email_to_provider'] = ($flags & 128) !== 0;
$tmp['recurring'] = ($flags & 512) !== 0;
$tmp['currency'] = self::deserialize_string($stream);
$tmp['prices'] = self::deserialize_type_array_of_LabeledPrice(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 256) !== 0) $tmp['max_tip_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 256) !== 0) $tmp['suggested_tip_amounts'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1024) !== 0) $tmp['terms_url'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_Invoice(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Z]' => self::deserialize_invoice($stream),
'r0' => $this->deserialize_type_Invoice(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_inputMediaInvoice(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaInvoice'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'MC' => [
'_' => 'inputWebDocument',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_InputWebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['invoice'] = match (stream_get_contents($stream, 4)) {
'Z]' => self::deserialize_invoice($stream),
'r0' => self::deserialize_type_Invoice(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['payload'] = self::deserialize_bytes($stream);
$tmp['provider'] = self::deserialize_string($stream);
$tmp['provider_data'] = match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['start_param'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['extended_media'] = $this->deserialize_type_InputMedia($stream);
return $tmp;

    }
    private  function deserialize_inputMediaGeoLive(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaGeoLive'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['stopped'] = ($flags & 1) !== 0;
$tmp['geo_point'] = match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => self::deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['heading'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['proximity_notification_radius'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_inputMediaPoll(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaPoll'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['poll'] = match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['correct_answers'] = self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['solution'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['solution_entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_inputMediaWebPage(mixed $stream): mixed {
$tmp = ['_' => 'inputMediaWebPage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['force_large_media'] = ($flags & 1) !== 0;
$tmp['force_small_media'] = ($flags & 2) !== 0;
$tmp['optional'] = ($flags & 4) !== 0;
$tmp['url'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_InputMedia(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'd' => [
'_' => 'inputMediaEmpty',
],
'}(' => self::deserialize_inputMediaUploadedPhoto($stream),
'5' => self::deserialize_inputMediaPhoto($stream),
'DA' => [
'_' => 'inputMediaGeoPoint',
'geo_point' => match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => self::deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'}' => [
'_' => 'inputMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
],
'8[' => self::deserialize_inputMediaUploadedDocument($stream),
'X0G3' => self::deserialize_inputMediaDocument($stream),
'=' => [
'_' => 'inputMediaVenue',
'geo_point' => match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => self::deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => self::deserialize_inputMediaPhotoExternal($stream),
'R' => self::deserialize_inputMediaDocumentExternal($stream),
'C?' => [
'_' => 'inputMediaGame',
'id' => match (stream_get_contents($stream, 4)) {
'w>,' => [
'_' => 'inputGameID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
1' => [
'_' => 'inputGameShortName',
'bot_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
'short_name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InputGame(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'զ' => self::deserialize_inputMediaInvoice($stream),
'C' => self::deserialize_inputMediaGeoLive($stream),
'' => self::deserialize_inputMediaPoll($stream),
'{o' => [
'_' => 'inputMediaDice',
'emoticon' => self::deserialize_string($stream),
],
'x' => [
'_' => 'inputMediaStory',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'I' => self::deserialize_inputMediaWebPage($stream),
'r0' => $this->deserialize_type_InputMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_draftMessage(mixed $stream): mixed {
$tmp = ['_' => 'draftMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['no_webpage'] = ($flags & 2) !== 0;
$tmp['invert_media'] = ($flags & 64) !== 0;
if (($flags & 16) !== 0) $tmp['reply_to'] = match (stream_get_contents($stream, 4)) {
'"' => self::deserialize_inputReplyToMessage($stream),
':2X' => [
'_' => 'inputReplyToStory',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_InputReplyTo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 32) !== 0) $tmp['media'] = match (stream_get_contents($stream, 4)) {
'd' => [
'_' => 'inputMediaEmpty',
],
'}(' => self::deserialize_inputMediaUploadedPhoto($stream),
'5' => self::deserialize_inputMediaPhoto($stream),
'DA' => [
'_' => 'inputMediaGeoPoint',
'geo_point' => match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => self::deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'}' => [
'_' => 'inputMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
],
'8[' => self::deserialize_inputMediaUploadedDocument($stream),
'X0G3' => self::deserialize_inputMediaDocument($stream),
'=' => [
'_' => 'inputMediaVenue',
'geo_point' => match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'inputGeoPointEmpty',
],
'/"H' => self::deserialize_inputGeoPoint($stream),
'r0' => self::deserialize_type_InputGeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => self::deserialize_inputMediaPhotoExternal($stream),
'R' => self::deserialize_inputMediaDocumentExternal($stream),
'C?' => [
'_' => 'inputMediaGame',
'id' => match (stream_get_contents($stream, 4)) {
'w>,' => [
'_' => 'inputGameID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
1' => [
'_' => 'inputGameShortName',
'bot_id' => match (stream_get_contents($stream, 4)) {
'φ' => [
'_' => 'inputUserEmpty',
],
'?' => [
'_' => 'inputUserSelf',
],
'X' => [
'_' => 'inputUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'H' => [
'_' => 'inputUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputUser(self::gzdecode($stream)),
default => self::err($stream)
}
,
'short_name' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InputGame(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'զ' => self::deserialize_inputMediaInvoice($stream),
'C' => self::deserialize_inputMediaGeoLive($stream),
'' => self::deserialize_inputMediaPoll($stream),
'{o' => [
'_' => 'inputMediaDice',
'emoticon' => self::deserialize_string($stream),
],
'x' => [
'_' => 'inputMediaStory',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'I' => self::deserialize_inputMediaWebPage($stream),
'r0' => self::deserialize_type_InputMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_DraftMessage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => self::deserialize_draftMessageEmpty($stream),
'?' => self::deserialize_draftMessage($stream),
'r0' => $this->deserialize_type_DraftMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateDraftMessage(mixed $stream): mixed {
$tmp = ['_' => 'updateDraftMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['draft'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_draftMessageEmpty($stream),
'?' => self::deserialize_draftMessage($stream),
'r0' => self::deserialize_type_DraftMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_DialogPeer(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'm' => [
'_' => 'dialogPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'EQ' => [
'_' => 'dialogPeerFolder',
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_DialogPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateDialogPinned(mixed $stream): mixed {
$tmp = ['_' => 'updateDialogPinned'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 1) !== 0;
if (($flags & 2) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'm' => [
'_' => 'dialogPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'EQ' => [
'_' => 'dialogPeerFolder',
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_DialogPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_DialogPeer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'm' => [
'_' => 'dialogPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'EQ' => [
'_' => 'dialogPeerFolder',
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_DialogPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_updatePinnedDialogs(mixed $stream): mixed {
$tmp = ['_' => 'updatePinnedDialogs'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['order'] = self::deserialize_type_array_of_DialogPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_updateBotPrecheckoutQuery(mixed $stream): mixed {
$tmp = ['_' => 'updateBotPrecheckoutQuery'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['query_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['payload'] = self::deserialize_bytes($stream);
if (($flags & 1) !== 0) $tmp['info'] = match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => self::deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['shipping_option_id'] = self::deserialize_string($stream);
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_phoneCallProtocol(mixed $stream): mixed {
$tmp = ['_' => 'phoneCallProtocol'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['udp_p2p'] = ($flags & 1) !== 0;
$tmp['udp_reflector'] = ($flags & 2) !== 0;
$tmp['min_layer'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['max_layer'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['library_versions'] = self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_PhoneCallProtocol(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ȏ' => self::deserialize_phoneCallProtocol($stream),
'r0' => $this->deserialize_type_PhoneCallProtocol(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_phoneCallWaiting(mixed $stream): mixed {
$tmp = ['_' => 'phoneCallWaiting'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['video'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participant_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['protocol'] = match (stream_get_contents($stream, 4)) {
'ȏ' => self::deserialize_phoneCallProtocol($stream),
'r0' => self::deserialize_type_PhoneCallProtocol(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['receive_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_phoneCallRequested(mixed $stream): mixed {
$tmp = ['_' => 'phoneCallRequested'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['video'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participant_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['g_a_hash'] = self::deserialize_bytes($stream);
$tmp['protocol'] = match (stream_get_contents($stream, 4)) {
'ȏ' => self::deserialize_phoneCallProtocol($stream),
'r0' => self::deserialize_type_PhoneCallProtocol(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_phoneCallAccepted(mixed $stream): mixed {
$tmp = ['_' => 'phoneCallAccepted'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['video'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participant_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['g_b'] = self::deserialize_bytes($stream);
$tmp['protocol'] = match (stream_get_contents($stream, 4)) {
'ȏ' => self::deserialize_phoneCallProtocol($stream),
'r0' => self::deserialize_type_PhoneCallProtocol(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_phoneConnection(mixed $stream): mixed {
$tmp = ['_' => 'phoneConnection'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['tcp'] = ($flags & 1) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['ip'] = self::deserialize_string($stream);
$tmp['ipv6'] = self::deserialize_string($stream);
$tmp['port'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['peer_tag'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_phoneConnectionWebrtc(mixed $stream): mixed {
$tmp = ['_' => 'phoneConnectionWebrtc'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['turn'] = ($flags & 1) !== 0;
$tmp['stun'] = ($flags & 2) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['ip'] = self::deserialize_string($stream);
$tmp['ipv6'] = self::deserialize_string($stream);
$tmp['port'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['username'] = self::deserialize_string($stream);
$tmp['password'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_PhoneConnection(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'#' => self::deserialize_phoneConnection($stream),
'u_c' => self::deserialize_phoneConnectionWebrtc($stream),
'r0' => $this->deserialize_type_PhoneConnection(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_phoneCall(mixed $stream): mixed {
$tmp = ['_' => 'phoneCall'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['p2p_allowed'] = ($flags & 32) !== 0;
$tmp['video'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participant_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['g_a_or_b'] = self::deserialize_bytes($stream);
$tmp['key_fingerprint'] = stream_get_contents($stream, 8);
$tmp['protocol'] = match (stream_get_contents($stream, 4)) {
'ȏ' => self::deserialize_phoneCallProtocol($stream),
'r0' => self::deserialize_type_PhoneCallProtocol(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['connections'] = self::deserialize_type_array_of_PhoneConnection(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['start_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_phoneCallDiscarded(mixed $stream): mixed {
$tmp = ['_' => 'phoneCallDiscarded'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['need_rating'] = ($flags & 4) !== 0;
$tmp['need_debug'] = ($flags & 8) !== 0;
$tmp['video'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['reason'] = match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'phoneCallDiscardReasonMissed',
],
'' => [
'_' => 'phoneCallDiscardReasonDisconnect',
],
'ƭW' => [
'_' => 'phoneCallDiscardReasonHangup',
],
'' => [
'_' => 'phoneCallDiscardReasonBusy',
],
'r0' => self::deserialize_type_PhoneCallDiscardReason(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['duration'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_PhoneCall(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'fS' => [
'_' => 'phoneCallEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'o"' => self::deserialize_phoneCallWaiting($stream),
'' => self::deserialize_phoneCallRequested($stream),
'`6' => self::deserialize_phoneCallAccepted($stream),
'g|' => self::deserialize_phoneCall($stream),
'MP' => self::deserialize_phoneCallDiscarded($stream),
'r0' => $this->deserialize_type_PhoneCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_langPackStringPluralized(mixed $stream): mixed {
$tmp = ['_' => 'langPackStringPluralized'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['key'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['zero_value'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['one_value'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['two_value'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['few_value'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['many_value'] = self::deserialize_string($stream);
$tmp['other_value'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_LangPackString(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'langPackString',
'key' => self::deserialize_string($stream),
'value' => self::deserialize_string($stream),
],
'Gl' => self::deserialize_langPackStringPluralized($stream),
'y)' => [
'_' => 'langPackStringDeleted',
'key' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_LangPackString(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_LangPackDifference(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'langPackDifference',
'lang_code' => self::deserialize_string($stream),
'from_version' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
'strings' => self::deserialize_type_array_of_LangPackString(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_LangPackDifference(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateChannelReadMessagesContents(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelReadMessagesContents'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_updateDialogUnreadMark(mixed $stream): mixed {
$tmp = ['_' => 'updateDialogUnreadMark'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['unread'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'm' => [
'_' => 'dialogPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'EQ' => [
'_' => 'dialogPeerFolder',
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_DialogPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updateMessagePoll(mixed $stream): mixed {
$tmp = ['_' => 'updateMessagePoll'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['poll_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['poll'] = match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['results'] = match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_FolderPeer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'h' => [
'_' => 'folderPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_FolderPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_peerSettings(mixed $stream): mixed {
$tmp = ['_' => 'peerSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['report_spam'] = ($flags & 1) !== 0;
$tmp['add_contact'] = ($flags & 2) !== 0;
$tmp['block_contact'] = ($flags & 4) !== 0;
$tmp['share_contact'] = ($flags & 8) !== 0;
$tmp['need_contacts_exception'] = ($flags & 16) !== 0;
$tmp['report_geo'] = ($flags & 32) !== 0;
$tmp['autoarchived'] = ($flags & 128) !== 0;
$tmp['invite_members'] = ($flags & 256) !== 0;
$tmp['request_chat_broadcast'] = ($flags & 1024) !== 0;
if (($flags & 64) !== 0) $tmp['geo_distance'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 512) !== 0) $tmp['request_chat_title'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['request_chat_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_PeerSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_peerSettings($stream),
'r0' => $this->deserialize_type_PeerSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_PeerLocated(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
']F' => [
'_' => 'peerLocated',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
'distance' => unpack('l', stream_get_contents($stream, 4))[1],
],
'K(' => [
'_' => 'peerSelfLocated',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_PeerLocated(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_ThemeSettings(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ԶX' => self::deserialize_themeSettings($stream),
'r0' => self::deserialize_type_ThemeSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_theme(mixed $stream): mixed {
$tmp = ['_' => 'theme'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['creator'] = ($flags & 1) !== 0;
$tmp['default'] = ($flags & 2) !== 0;
$tmp['for_chat'] = ($flags & 32) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['slug'] = self::deserialize_string($stream);
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['settings'] = self::deserialize_type_array_of_ThemeSettings(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 64) !== 0) $tmp['emoticon'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['installs_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Theme(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'g' => self::deserialize_theme($stream),
'r0' => $this->deserialize_type_Theme(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_InputPeer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'inputPeerEmpty',
],
'~}' => [
'_' => 'inputPeerSelf',
],
'\\5' => [
'_' => 'inputPeerChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'L' => [
'_' => 'inputPeerUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'\'' => [
'_' => 'inputPeerChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
{' => [
'_' => 'inputPeerUserFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'@*' => [
'_' => 'inputPeerChannelFromMessage',
'peer' => self::deserialize_type_InputPeer($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_dialogFilter(mixed $stream): mixed {
$tmp = ['_' => 'dialogFilter'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['contacts'] = ($flags & 1) !== 0;
$tmp['non_contacts'] = ($flags & 2) !== 0;
$tmp['groups'] = ($flags & 4) !== 0;
$tmp['broadcasts'] = ($flags & 8) !== 0;
$tmp['bots'] = ($flags & 16) !== 0;
$tmp['exclude_muted'] = ($flags & 2048) !== 0;
$tmp['exclude_read'] = ($flags & 4096) !== 0;
$tmp['exclude_archived'] = ($flags & 8192) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 33554432) !== 0) $tmp['emoticon'] = self::deserialize_string($stream);
if (($flags & 134217728) !== 0) $tmp['color'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pinned_peers'] = self::deserialize_type_array_of_InputPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['include_peers'] = self::deserialize_type_array_of_InputPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['exclude_peers'] = self::deserialize_type_array_of_InputPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_dialogFilterChatlist(mixed $stream): mixed {
$tmp = ['_' => 'dialogFilterChatlist'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_my_invites'] = ($flags & 67108864) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 33554432) !== 0) $tmp['emoticon'] = self::deserialize_string($stream);
if (($flags & 134217728) !== 0) $tmp['color'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pinned_peers'] = self::deserialize_type_array_of_InputPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['include_peers'] = self::deserialize_type_array_of_InputPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_DialogFilter(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
';R_' => self::deserialize_dialogFilter($stream),
'26' => [
'_' => 'dialogFilterDefault',
],
'' => self::deserialize_dialogFilterChatlist($stream),
'r0' => $this->deserialize_type_DialogFilter(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateDialogFilter(mixed $stream): mixed {
$tmp = ['_' => 'updateDialogFilter'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['filter'] = match (stream_get_contents($stream, 4)) {
';R_' => self::deserialize_dialogFilter($stream),
'26' => [
'_' => 'dialogFilterDefault',
],
'' => self::deserialize_dialogFilterChatlist($stream),
'r0' => self::deserialize_type_DialogFilter(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updateReadChannelDiscussionInbox(mixed $stream): mixed {
$tmp = ['_' => 'updateReadChannelDiscussionInbox'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['broadcast_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['broadcast_post'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updatePeerBlocked(mixed $stream): mixed {
$tmp = ['_' => 'updatePeerBlocked'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blocked'] = ($flags & 1) !== 0;
$tmp['blocked_my_stories_from'] = ($flags & 2) !== 0;
$tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updateChannelUserTyping(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelUserTyping'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['action'] = match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updatePinnedMessages(mixed $stream): mixed {
$tmp = ['_' => 'updatePinnedMessages'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['messages'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updatePinnedChannelMessages(mixed $stream): mixed {
$tmp = ['_' => 'updatePinnedChannelMessages'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 1) !== 0;
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['messages'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_GroupCallParticipantVideoSourceGroup(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'groupCallParticipantVideoSourceGroup',
'semantics' => self::deserialize_string($stream),
'sources' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_GroupCallParticipantVideoSourceGroup(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_groupCallParticipantVideo(mixed $stream): mixed {
$tmp = ['_' => 'groupCallParticipantVideo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['paused'] = ($flags & 1) !== 0;
$tmp['endpoint'] = self::deserialize_string($stream);
$tmp['source_groups'] = self::deserialize_type_array_of_GroupCallParticipantVideoSourceGroup(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['audio_source'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_GroupCallParticipantVideo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
':ug' => self::deserialize_groupCallParticipantVideo($stream),
'r0' => $this->deserialize_type_GroupCallParticipantVideo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_groupCallParticipant(mixed $stream): mixed {
$tmp = ['_' => 'groupCallParticipant'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['muted'] = ($flags & 1) !== 0;
$tmp['left'] = ($flags & 2) !== 0;
$tmp['can_self_unmute'] = ($flags & 4) !== 0;
$tmp['just_joined'] = ($flags & 16) !== 0;
$tmp['versioned'] = ($flags & 32) !== 0;
$tmp['min'] = ($flags & 256) !== 0;
$tmp['muted_by_you'] = ($flags & 512) !== 0;
$tmp['volume_by_admin'] = ($flags & 1024) !== 0;
$tmp['self'] = ($flags & 4096) !== 0;
$tmp['video_joined'] = ($flags & 32768) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['active_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['source'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 128) !== 0) $tmp['volume'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2048) !== 0) $tmp['about'] = self::deserialize_string($stream);
if (($flags & 8192) !== 0) $tmp['raise_hand_rating'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 64) !== 0) $tmp['video'] = match (stream_get_contents($stream, 4)) {
':ug' => self::deserialize_groupCallParticipantVideo($stream),
'r0' => self::deserialize_type_GroupCallParticipantVideo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16384) !== 0) $tmp['presentation'] = match (stream_get_contents($stream, 4)) {
':ug' => self::deserialize_groupCallParticipantVideo($stream),
'r0' => self::deserialize_type_GroupCallParticipantVideo(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_GroupCallParticipant(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => $this->deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_groupCall(mixed $stream): mixed {
$tmp = ['_' => 'groupCall'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['join_muted'] = ($flags & 2) !== 0;
$tmp['can_change_join_muted'] = ($flags & 4) !== 0;
$tmp['join_date_asc'] = ($flags & 64) !== 0;
$tmp['schedule_start_subscribed'] = ($flags & 256) !== 0;
$tmp['can_start_video'] = ($flags & 512) !== 0;
$tmp['record_video_active'] = ($flags & 2048) !== 0;
$tmp['rtmp_stream'] = ($flags & 4096) !== 0;
$tmp['listeners_hidden'] = ($flags & 8192) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['participants_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['stream_dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['record_start_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 128) !== 0) $tmp['schedule_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1024) !== 0) $tmp['unmuted_video_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unmuted_video_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['version'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_GroupCall(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'w' => [
'_' => 'groupCallDiscarded',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
],
'e' => self::deserialize_groupCall($stream),
'r0' => $this->deserialize_type_GroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updatePeerHistoryTTL(mixed $stream): mixed {
$tmp = ['_' => 'updatePeerHistoryTTL'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_chatInviteExported(mixed $stream): mixed {
$tmp = ['_' => 'chatInviteExported'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['revoked'] = ($flags & 1) !== 0;
$tmp['permanent'] = ($flags & 32) !== 0;
$tmp['request_needed'] = ($flags & 64) !== 0;
$tmp['link'] = self::deserialize_string($stream);
$tmp['admin_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['start_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['expire_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['usage_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['usage'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 128) !== 0) $tmp['requested'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['title'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_ExportedChatInvite(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => $this->deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateChatParticipant(mixed $stream): mixed {
$tmp = ['_' => 'updateChatParticipant'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['actor_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['prev_participant'] = match (stream_get_contents($stream, 4)) {
'@-' => [
'_' => 'chatParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'k' => [
'_' => 'chatParticipantCreator',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'[?' => [
'_' => 'chatParticipantAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['new_participant'] = match (stream_get_contents($stream, 4)) {
'@-' => [
'_' => 'chatParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'k' => [
'_' => 'chatParticipantCreator',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'[?' => [
'_' => 'chatParticipantAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['invite'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['qts'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_channelParticipantSelf(mixed $stream): mixed {
$tmp = ['_' => 'channelParticipantSelf'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_request'] = ($flags & 1) !== 0;
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['inviter_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_channelParticipantCreator(mixed $stream): mixed {
$tmp = ['_' => 'channelParticipantCreator'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['rank'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_channelParticipantAdmin(mixed $stream): mixed {
$tmp = ['_' => 'channelParticipantAdmin'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_edit'] = ($flags & 1) !== 0;
$tmp['self'] = ($flags & 2) !== 0;
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['inviter_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['promoted_by'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['rank'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_channelParticipantBanned(mixed $stream): mixed {
$tmp = ['_' => 'channelParticipantBanned'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['left'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['kicked_by'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['banned_rights'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_ChannelParticipant(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateChannelParticipant(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelParticipant'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_chatlist'] = ($flags & 8) !== 0;
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['actor_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['prev_participant'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['new_participant'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['invite'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['qts'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateGroupCallConnection(mixed $stream): mixed {
$tmp = ['_' => 'updateGroupCallConnection'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['presentation'] = ($flags & 1) !== 0;
$tmp['params'] = match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_BotCommand(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'z' => [
'_' => 'botCommand',
'command' => self::deserialize_string($stream),
'description' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_BotCommand(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_updateMessageReactions(mixed $stream): mixed {
$tmp = ['_' => 'updateMessageReactions'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['top_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['reactions'] = match (stream_get_contents($stream, 4)) {
'y+O' => self::deserialize_messageReactions($stream),
'r0' => self::deserialize_type_MessageReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_BotMenuButton(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'3u' => [
'_' => 'botMenuButtonDefault',
],
'XB' => [
'_' => 'botMenuButtonCommands',
],
'|' => [
'_' => 'botMenuButton',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_BotMenuButton(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateTranscribedAudio(mixed $stream): mixed {
$tmp = ['_' => 'updateTranscribedAudio'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pending'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['transcription_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['text'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_updateMoveStickerSetToTop(mixed $stream): mixed {
$tmp = ['_' => 'updateMoveStickerSetToTop'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['masks'] = ($flags & 1) !== 0;
$tmp['emojis'] = ($flags & 2) !== 0;
$tmp['stickerset'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_updateChannelPinnedTopic(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelPinnedTopic'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 1) !== 0;
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['topic_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateChannelPinnedTopics(mixed $stream): mixed {
$tmp = ['_' => 'updateChannelPinnedTopics'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['order'] = self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_storiesStealthMode(mixed $stream): mixed {
$tmp = ['_' => 'storiesStealthMode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['active_until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['cooldown_until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_StoriesStealthMode(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'\'.q' => self::deserialize_storiesStealthMode($stream),
'r0' => $this->deserialize_type_StoriesStealthMode(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_boost(mixed $stream): mixed {
$tmp = ['_' => 'boost'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['gift'] = ($flags & 2) !== 0;
$tmp['giveaway'] = ($flags & 4) !== 0;
$tmp['unclaimed'] = ($flags & 8) !== 0;
$tmp['id'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 4) !== 0) $tmp['giveaway_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['expires'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['used_gift_slug'] = self::deserialize_string($stream);
if (($flags & 32) !== 0) $tmp['multiplier'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Boost(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'q*' => self::deserialize_boost($stream),
'r0' => $this->deserialize_type_Boost(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updatePeerWallpaper(mixed $stream): mixed {
$tmp = ['_' => 'updatePeerWallpaper'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['wallpaper_overridden'] = ($flags & 2) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['wallpaper'] = match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_Reaction(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_updateSavedDialogPinned(mixed $stream): mixed {
$tmp = ['_' => 'updateSavedDialogPinned'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'm' => [
'_' => 'dialogPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'EQ' => [
'_' => 'dialogPeerFolder',
'folder_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_DialogPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_updatePinnedSavedDialogs(mixed $stream): mixed {
$tmp = ['_' => 'updatePinnedSavedDialogs'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['order'] = self::deserialize_type_array_of_DialogPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_QuickReply(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'quickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'shortcut' => self::deserialize_string($stream),
'top_message' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_QuickReply(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_QuickReply(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'quickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'shortcut' => self::deserialize_string($stream),
'top_message' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_QuickReply(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_auth___sentCodeTypeEmailCode(mixed $stream): mixed {
$tmp = ['_' => 'auth.sentCodeTypeEmailCode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['apple_signin_allowed'] = ($flags & 1) !== 0;
$tmp['google_signin_allowed'] = ($flags & 2) !== 0;
$tmp['email_pattern'] = self::deserialize_string($stream);
$tmp['length'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['reset_available_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['reset_pending_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_auth___sentCodeTypeSetUpEmailRequired(mixed $stream): mixed {
$tmp = ['_' => 'auth.sentCodeTypeSetUpEmailRequired'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['apple_signin_allowed'] = ($flags & 1) !== 0;
$tmp['google_signin_allowed'] = ($flags & 2) !== 0;
return $tmp;

    }
    private  function deserialize_auth___sentCodeTypeFirebaseSms(mixed $stream): mixed {
$tmp = ['_' => 'auth.sentCodeTypeFirebaseSms'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['nonce'] = self::deserialize_bytes($stream);
if (($flags & 2) !== 0) $tmp['receipt'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['push_timeout'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['length'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_auth___SentCodeType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Y=' => [
'_' => 'auth.sentCodeTypeApp',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' . "\0" . '' => [
'_' => 'auth.sentCodeTypeSms',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SS' => [
'_' => 'auth.sentCodeTypeCall',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'auth.sentCodeTypeFlashCall',
'pattern' => self::deserialize_string($stream),
],
'd' . "\0" . '' => [
'_' => 'auth.sentCodeTypeMissedCall',
'prefix' => self::deserialize_string($stream),
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'P' => self::deserialize_auth___sentCodeTypeEmailCode($stream),
'I' => self::deserialize_auth___sentCodeTypeSetUpEmailRequired($stream),
'9\\V' => [
'_' => 'auth.sentCodeTypeFragmentSms',
'url' => self::deserialize_string($stream),
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'2{' => self::deserialize_auth___sentCodeTypeFirebaseSms($stream),
'r0' => $this->deserialize_type_auth___SentCodeType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_auth___CodeType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'auth.codeTypeSms',
],
't' => [
'_' => 'auth.codeTypeCall',
],
'l"' => [
'_' => 'auth.codeTypeFlashCall',
],
'' => [
'_' => 'auth.codeTypeMissedCall',
],
'' => [
'_' => 'auth.codeTypeFragmentSms',
],
'r0' => $this->deserialize_type_auth___CodeType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_auth___sentCode(mixed $stream): mixed {
$tmp = ['_' => 'auth.sentCode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['type'] = match (stream_get_contents($stream, 4)) {
'Y=' => [
'_' => 'auth.sentCodeTypeApp',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' . "\0" . '' => [
'_' => 'auth.sentCodeTypeSms',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SS' => [
'_' => 'auth.sentCodeTypeCall',
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'auth.sentCodeTypeFlashCall',
'pattern' => self::deserialize_string($stream),
],
'd' . "\0" . '' => [
'_' => 'auth.sentCodeTypeMissedCall',
'prefix' => self::deserialize_string($stream),
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'P' => self::deserialize_auth___sentCodeTypeEmailCode($stream),
'I' => self::deserialize_auth___sentCodeTypeSetUpEmailRequired($stream),
'9\\V' => [
'_' => 'auth.sentCodeTypeFragmentSms',
'url' => self::deserialize_string($stream),
'length' => unpack('l', stream_get_contents($stream, 4))[1],
],
'2{' => self::deserialize_auth___sentCodeTypeFirebaseSms($stream),
'r0' => self::deserialize_type_auth___SentCodeType(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['phone_code_hash'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['next_type'] = match (stream_get_contents($stream, 4)) {
'r' => [
'_' => 'auth.codeTypeSms',
],
't' => [
'_' => 'auth.codeTypeCall',
],
'l"' => [
'_' => 'auth.codeTypeFlashCall',
],
'' => [
'_' => 'auth.codeTypeMissedCall',
],
'' => [
'_' => 'auth.codeTypeFragmentSms',
],
'r0' => self::deserialize_type_auth___CodeType(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['timeout'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_userEmpty(mixed $stream): mixed {
$tmp = [
'_' => 'userEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
];
$this->peerDatabase->addUser($tmp);
return $tmp;

    }
    private  function deserialize_userProfilePhoto(mixed $stream): mixed {
$tmp = ['_' => 'userProfilePhoto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_video'] = ($flags & 1) !== 0;
$tmp['personal'] = ($flags & 4) !== 0;
$tmp['photo_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['stripped_thumb'] = self::deserialize_bytes($stream);
$tmp['dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_UserProfilePhoto(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'O' => [
'_' => 'userProfilePhotoEmpty',
],
'т' => self::deserialize_userProfilePhoto($stream),
'r0' => $this->deserialize_type_UserProfilePhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_user(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('user');
$tmp = ['_' => 'user'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['self'] = ($flags & 1024) !== 0;
$tmp['contact'] = ($flags & 2048) !== 0;
$tmp['mutual_contact'] = ($flags & 4096) !== 0;
$tmp['deleted'] = ($flags & 8192) !== 0;
$tmp['bot'] = ($flags & 16384) !== 0;
$tmp['bot_chat_history'] = ($flags & 32768) !== 0;
$tmp['bot_nochats'] = ($flags & 65536) !== 0;
$tmp['verified'] = ($flags & 131072) !== 0;
$tmp['restricted'] = ($flags & 262144) !== 0;
$tmp['min'] = ($flags & 1048576) !== 0;
$tmp['bot_inline_geo'] = ($flags & 2097152) !== 0;
$tmp['support'] = ($flags & 8388608) !== 0;
$tmp['scam'] = ($flags & 16777216) !== 0;
$tmp['apply_min_photo'] = ($flags & 33554432) !== 0;
$tmp['fake'] = ($flags & 67108864) !== 0;
$tmp['bot_attach_menu'] = ($flags & 134217728) !== 0;
$tmp['premium'] = ($flags & 268435456) !== 0;
$tmp['attach_menu_enabled'] = ($flags & 536870912) !== 0;
$flags2 = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['bot_can_edit'] = ($flags2 & 2) !== 0;
$tmp['close_friend'] = ($flags2 & 4) !== 0;
$tmp['stories_hidden'] = ($flags2 & 8) !== 0;
$tmp['stories_unavailable'] = ($flags2 & 16) !== 0;
$tmp['contact_require_premium'] = ($flags2 & 1024) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 1) !== 0) $tmp['access_hash'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['first_name'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['last_name'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['username'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['phone'] = self::deserialize_string($stream);
if (($flags & 32) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'O' => [
'_' => 'userProfilePhotoEmpty',
],
'т' => self::deserialize_userProfilePhoto($stream),
'r0' => self::deserialize_type_UserProfilePhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['status'] = match (stream_get_contents($stream, 4)) {
'IP	' => [
'_' => 'userStatusEmpty',
],
'I9' => [
'_' => 'userStatusOnline',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?p' . "\0" . '' => [
'_' => 'userStatusOffline',
'was_online' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}{' => self::deserialize_userStatusRecently($stream),
'T' => self::deserialize_userStatusLastWeek($stream),
'we' => self::deserialize_userStatusLastMonth($stream),
'r0' => self::deserialize_type_UserStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16384) !== 0) $tmp['bot_info_version'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 262144) !== 0) $tmp['restriction_reason'] = self::deserialize_type_array_of_RestrictionReason(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 524288) !== 0) $tmp['bot_inline_placeholder'] = self::deserialize_string($stream);
if (($flags & 4194304) !== 0) $tmp['lang_code'] = self::deserialize_string($stream);
if (($flags & 1073741824) !== 0) $tmp['emoji_status'] = match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 1) !== 0) $tmp['usernames'] = self::deserialize_type_array_of_Username(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags2 & 32) !== 0) $tmp['stories_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags2 & 256) !== 0) $tmp['color'] = match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 512) !== 0) $tmp['profile_color'] = match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addUser($tmp);
return $tmp;

    }
    private  function deserialize_type_User(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'zK' => self::deserialize_userEmpty($stream),
'8D\\!' => self::deserialize_user($stream),
'r0' => $this->deserialize_type_User(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_auth___authorization(mixed $stream): mixed {
$tmp = ['_' => 'auth.authorization'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['setup_password_required'] = ($flags & 2) !== 0;
if (($flags & 2) !== 0) $tmp['otherwise_relogin_days'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['tmp_sessions'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['future_auth_token'] = self::deserialize_bytes($stream);
$tmp['user'] = match (stream_get_contents($stream, 4)) {
'zK' => self::deserialize_userEmpty($stream),
'8D\\!' => self::deserialize_user($stream),
'r0' => self::deserialize_type_User(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_help___termsOfService(mixed $stream): mixed {
$tmp = ['_' => 'help.termsOfService'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['popup'] = ($flags & 1) !== 0;
$tmp['id'] = match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['text'] = self::deserialize_string($stream);
$tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['min_age_confirm'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_help___TermsOfService(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
x' => self::deserialize_help___termsOfService($stream),
'r0' => $this->deserialize_type_help___TermsOfService(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_auth___authorizationSignUpRequired(mixed $stream): mixed {
$tmp = ['_' => 'auth.authorizationSignUpRequired'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['terms_of_service'] = match (stream_get_contents($stream, 4)) {
'
x' => self::deserialize_help___termsOfService($stream),
'r0' => self::deserialize_type_help___TermsOfService(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_auth___Authorization(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'.' => self::deserialize_auth___authorization($stream),
'~tD' => self::deserialize_auth___authorizationSignUpRequired($stream),
'r0' => $this->deserialize_type_auth___Authorization(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_auth___loggedOut(mixed $stream): mixed {
$tmp = ['_' => 'auth.loggedOut'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['future_auth_token'] = self::deserialize_bytes($stream);
return $tmp;

    }
    private  function deserialize_authorization(mixed $stream): mixed {
$tmp = ['_' => 'authorization'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['current'] = ($flags & 1) !== 0;
$tmp['official_app'] = ($flags & 2) !== 0;
$tmp['password_pending'] = ($flags & 4) !== 0;
$tmp['encrypted_requests_disabled'] = ($flags & 8) !== 0;
$tmp['call_requests_disabled'] = ($flags & 16) !== 0;
$tmp['unconfirmed'] = ($flags & 32) !== 0;
$tmp['hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['device_model'] = self::deserialize_string($stream);
$tmp['platform'] = self::deserialize_string($stream);
$tmp['system_version'] = self::deserialize_string($stream);
$tmp['api_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['app_name'] = self::deserialize_string($stream);
$tmp['app_version'] = self::deserialize_string($stream);
$tmp['date_created'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date_active'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['ip'] = self::deserialize_string($stream);
$tmp['country'] = self::deserialize_string($stream);
$tmp['region'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_WallPaper(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Chat(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_User(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'zK' => self::deserialize_userEmpty($stream),
'8D\\!' => self::deserialize_user($stream),
'r0' => self::deserialize_type_User(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Authorization(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => self::deserialize_authorization($stream),
'r0' => $this->deserialize_type_Authorization(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_PasswordKdfAlgo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Z' => [
'_' => 'passwordKdfAlgoUnknown',
],
'J-:' => [
'_' => 'passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow',
'salt1' => self::deserialize_bytes($stream),
'salt2' => self::deserialize_bytes($stream),
'g' => unpack('l', stream_get_contents($stream, 4))[1],
'p' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_PasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_SecurePasswordKdfAlgo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'7J' . "\0" . '' => [
'_' => 'securePasswordKdfAlgoUnknown',
],
'' => [
'_' => 'securePasswordKdfAlgoPBKDF2HMACSHA512iter100000',
'salt' => self::deserialize_bytes($stream),
],
'G' => [
'_' => 'securePasswordKdfAlgoSHA512',
'salt' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_SecurePasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_account___password(mixed $stream): mixed {
$tmp = ['_' => 'account.password'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_recovery'] = ($flags & 1) !== 0;
$tmp['has_secure_values'] = ($flags & 2) !== 0;
$tmp['has_password'] = ($flags & 4) !== 0;
if (($flags & 4) !== 0) $tmp['current_algo'] = match (stream_get_contents($stream, 4)) {
'Z' => [
'_' => 'passwordKdfAlgoUnknown',
],
'J-:' => [
'_' => 'passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow',
'salt1' => self::deserialize_bytes($stream),
'salt2' => self::deserialize_bytes($stream),
'g' => unpack('l', stream_get_contents($stream, 4))[1],
'p' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['srp_B'] = self::deserialize_bytes($stream);
if (($flags & 4) !== 0) $tmp['srp_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['hint'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['email_unconfirmed_pattern'] = self::deserialize_string($stream);
$tmp['new_algo'] = match (stream_get_contents($stream, 4)) {
'Z' => [
'_' => 'passwordKdfAlgoUnknown',
],
'J-:' => [
'_' => 'passwordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow',
'salt1' => self::deserialize_bytes($stream),
'salt2' => self::deserialize_bytes($stream),
'g' => unpack('l', stream_get_contents($stream, 4))[1],
'p' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_PasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['new_secure_algo'] = match (stream_get_contents($stream, 4)) {
'7J' . "\0" . '' => [
'_' => 'securePasswordKdfAlgoUnknown',
],
'' => [
'_' => 'securePasswordKdfAlgoPBKDF2HMACSHA512iter100000',
'salt' => self::deserialize_bytes($stream),
],
'G' => [
'_' => 'securePasswordKdfAlgoSHA512',
'salt' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecurePasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['secure_random'] = self::deserialize_bytes($stream);
if (($flags & 32) !== 0) $tmp['pending_reset_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 64) !== 0) $tmp['login_email_pattern'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_SecureSecretSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'\'' => [
'_' => 'secureSecretSettings',
'secure_algo' => match (stream_get_contents($stream, 4)) {
'7J' . "\0" . '' => [
'_' => 'securePasswordKdfAlgoUnknown',
],
'' => [
'_' => 'securePasswordKdfAlgoPBKDF2HMACSHA512iter100000',
'salt' => self::deserialize_bytes($stream),
],
'G' => [
'_' => 'securePasswordKdfAlgoSHA512',
'salt' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecurePasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
,
'secure_secret' => self::deserialize_bytes($stream),
'secure_secret_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_SecureSecretSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_account___passwordSettings(mixed $stream): mixed {
$tmp = ['_' => 'account.passwordSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['email'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['secure_settings'] = match (stream_get_contents($stream, 4)) {
'\'' => [
'_' => 'secureSecretSettings',
'secure_algo' => match (stream_get_contents($stream, 4)) {
'7J' . "\0" . '' => [
'_' => 'securePasswordKdfAlgoUnknown',
],
'' => [
'_' => 'securePasswordKdfAlgoPBKDF2HMACSHA512iter100000',
'salt' => self::deserialize_bytes($stream),
],
'G' => [
'_' => 'securePasswordKdfAlgoSHA512',
'salt' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_SecurePasswordKdfAlgo(self::gzdecode($stream)),
default => self::err($stream)
}
,
'secure_secret' => self::deserialize_bytes($stream),
'secure_secret_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_SecureSecretSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_WebAuthorization(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'R' => [
'_' => 'webAuthorization',
'hash' => unpack('q', stream_get_contents($stream, 8))[1],
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'domain' => self::deserialize_string($stream),
'browser' => self::deserialize_string($stream),
'platform' => self::deserialize_string($stream),
'date_created' => unpack('l', stream_get_contents($stream, 4))[1],
'date_active' => unpack('l', stream_get_contents($stream, 4))[1],
'ip' => self::deserialize_string($stream),
'region' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_WebAuthorization(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_secureRequiredType(mixed $stream): mixed {
$tmp = ['_' => 'secureRequiredType'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['native_names'] = ($flags & 1) !== 0;
$tmp['selfie_required'] = ($flags & 2) !== 0;
$tmp['translation_required'] = ($flags & 4) !== 0;
$tmp['type'] = match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_SecureRequiredType(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ڙ' => self::deserialize_secureRequiredType($stream),
'wt' => [
'_' => 'secureRequiredTypeOneOf',
'types' => $this->deserialize_type_array_of_SecureRequiredType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_SecureRequiredType(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_SecureValueError(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'secureValueErrorData',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'data_hash' => self::deserialize_bytes($stream),
'field' => self::deserialize_string($stream),
'text' => self::deserialize_string($stream),
],
'=' . "\0" . '' => [
'_' => 'secureValueErrorFrontSide',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
'*' => [
'_' => 'secureValueErrorReverseSide',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
'7' => [
'_' => 'secureValueErrorSelfie',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
'spz' => [
'_' => 'secureValueErrorFile',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
' bf' => [
'_' => 'secureValueErrorFiles',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'text' => self::deserialize_string($stream),
],
'u' => [
'_' => 'secureValueError',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
'pG' => [
'_' => 'secureValueErrorTranslationFile',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_bytes($stream),
'text' => self::deserialize_string($stream),
],
'mc4' => [
'_' => 'secureValueErrorTranslationFiles',
'type' => match (stream_get_contents($stream, 4)) {
'*' => [
'_' => 'secureValueTypePersonalDetails',
],
'' . "\0" . 'j=' => [
'_' => 'secureValueTypePassport',
],
'%' => [
'_' => 'secureValueTypeDriverLicense',
],
'KtР' => [
'_' => 'secureValueTypeIdentityCard',
],
'#' => [
'_' => 'secureValueTypeInternalPassport',
],
'&' => [
'_' => 'secureValueTypeAddress',
],
'N6' => [
'_' => 'secureValueTypeUtilityBill',
],
'
|' => [
'_' => 'secureValueTypeBankStatement',
],
'4' => [
'_' => 'secureValueTypeRentalAgreement',
],
'j' => [
'_' => 'secureValueTypePassportRegistration',
],
'3' => [
'_' => 'secureValueTypeTemporaryRegistration',
],
'۪ ' => [
'_' => 'secureValueTypePhone',
],
'<' => [
'_' => 'secureValueTypeEmail',
],
'r0' => self::deserialize_type_SecureValueType(self::gzdecode($stream)),
default => self::err($stream)
}
,
'file_hash' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'text' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_SecureValueError(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_account___authorizationForm(mixed $stream): mixed {
$tmp = ['_' => 'account.authorizationForm'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['required_types'] = self::deserialize_type_array_of_SecureRequiredType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['values'] = self::deserialize_type_array_of_SecureValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['errors'] = self::deserialize_type_array_of_SecureValueError(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['privacy_policy_url'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_auth___SentCode(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'%' . "\0" . '^' => self::deserialize_auth___sentCode($stream),
'D#' => [
'_' => 'auth.sentCodeSuccess',
'authorization' => match (stream_get_contents($stream, 4)) {
'.' => self::deserialize_auth___authorization($stream),
'~tD' => self::deserialize_auth___authorizationSignUpRequired($stream),
'r0' => self::deserialize_type_auth___Authorization(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_auth___SentCode(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updateShortMessage(mixed $stream): mixed {
$tmp = ['_' => 'updateShortMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['out'] = ($flags & 2) !== 0;
$tmp['mentioned'] = ($flags & 16) !== 0;
$tmp['media_unread'] = ($flags & 32) !== 0;
$tmp['silent'] = ($flags & 8192) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['message'] = self::deserialize_string($stream);
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['fwd_from'] = match (stream_get_contents($stream, 4)) {
'MN' => self::deserialize_messageFwdHeader($stream),
'r0' => self::deserialize_type_MessageFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2048) !== 0) $tmp['via_bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['reply_to'] = match (stream_get_contents($stream, 4)) {
'	' => self::deserialize_messageReplyHeader($stream),
'9Z' => [
'_' => 'messageReplyStoryHeader',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_MessageReplyHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 33554432) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_updateShortChatMessage(mixed $stream): mixed {
$tmp = ['_' => 'updateShortChatMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['out'] = ($flags & 2) !== 0;
$tmp['mentioned'] = ($flags & 16) !== 0;
$tmp['media_unread'] = ($flags & 32) !== 0;
$tmp['silent'] = ($flags & 8192) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['from_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['message'] = self::deserialize_string($stream);
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['fwd_from'] = match (stream_get_contents($stream, 4)) {
'MN' => self::deserialize_messageFwdHeader($stream),
'r0' => self::deserialize_type_MessageFwdHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2048) !== 0) $tmp['via_bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 8) !== 0) $tmp['reply_to'] = match (stream_get_contents($stream, 4)) {
'	' => self::deserialize_messageReplyHeader($stream),
'9Z' => [
'_' => 'messageReplyStoryHeader',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_MessageReplyHeader(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 33554432) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Update(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
+' => [
'_' => 'updateNewMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ֿN' => [
'_' => 'updateMessageID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
' => [
'_' => 'updateDeleteMessages',
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateUserTyping',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'zH' => [
'_' => 'updateChatUserTyping',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'from_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'v' => [
'_' => 'updateChatParticipants',
'participants' => match (stream_get_contents($stream, 4)) {
'c' => self::deserialize_chatParticipantsForbidden($stream),
'<' => [
'_' => 'chatParticipants',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participants' => self::deserialize_type_array_of_ChatParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipants(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'updateUserStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'status' => match (stream_get_contents($stream, 4)) {
'IP	' => [
'_' => 'userStatusEmpty',
],
'I9' => [
'_' => 'userStatusOnline',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?p' . "\0" . '' => [
'_' => 'userStatusOffline',
'was_online' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}{' => self::deserialize_userStatusRecently($stream),
'T' => self::deserialize_userStatusLastWeek($stream),
'we' => self::deserialize_userStatusLastMonth($stream),
'r0' => self::deserialize_type_UserStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$' => [
'_' => 'updateUserName',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'usernames' => self::deserialize_type_array_of_Username(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Q' => self::deserialize_updateNewAuthorization($stream),
'' => [
'_' => 'updateNewEncryptedMessage',
'message' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'encryptedMessage',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
'file' => match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ks#' => [
'_' => 'encryptedMessageService',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_EncryptedMessage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'V' => [
'_' => 'updateEncryptedChatTyping',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'袴' => [
'_' => 'updateEncryption',
'chat' => match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'encryptedChatEmpty',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SYf' => [
'_' => 'encryptedChatWaiting',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'LH' => self::deserialize_encryptedChatRequested($stream),
'a' => [
'_' => 'encryptedChat',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a_or_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'E|' => self::deserialize_encryptedChatDiscarded($stream),
'r0' => self::deserialize_type_EncryptedChat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'%8' => [
'_' => 'updateEncryptedMessagesRead',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'max_date' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'QT=' => [
'_' => 'updateChatParticipantAdd',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'w=/' => [
'_' => 'updateChatParticipantDelete',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
's^' => [
'_' => 'updateDcOptions',
'dc_options' => self::deserialize_type_array_of_DcOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'h¾' => [
'_' => 'updateNotifySettings',
'peer' => match (stream_get_contents($stream, 4)) {
'ԟ' => [
'_' => 'notifyPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'L;ȴ' => [
'_' => 'notifyUsers',
],
'' => [
'_' => 'notifyChats',
],
'' => [
'_' => 'notifyBroadcasts',
],
'cn"' => [
'_' => 'notifyForumTopic',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_NotifyPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'notify_settings' => match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'h' => self::deserialize_updateServiceNotification($stream),
'*\';' => [
'_' => 'updatePrivacy',
'key' => match (stream_get_contents($stream, 4)) {
'0.' => [
'_' => 'privacyKeyStatusTimestamp',
],
'mP' => [
'_' => 'privacyKeyChatInvite',
],
'{+f=' => [
'_' => 'privacyKeyPhoneCall',
],
'I9' => [
'_' => 'privacyKeyPhoneP2P',
],
'Vi' => [
'_' => 'privacyKeyForwards',
],
'' => [
'_' => 'privacyKeyProfilePhoto',
],
'm' => [
'_' => 'privacyKeyPhoneNumber',
],
'+B' => [
'_' => 'privacyKeyAddedByPhone',
],
'' => [
'_' => 'privacyKeyVoiceMessages',
],
'a' => [
'_' => 'privacyKeyAbout',
],
'r0' => self::deserialize_type_PrivacyKey(self::gzdecode($stream)),
default => self::err($stream)
}
,
'rules' => self::deserialize_type_array_of_PrivacyRule(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'*I' => [
'_' => 'updateUserPhone',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'phone' => self::deserialize_string($stream),
],
'O' => self::deserialize_updateReadHistoryInbox($stream),
'!//' => [
'_' => 'updateReadHistoryOutbox',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateWebPage',
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q"' => self::deserialize_updateReadMessagesContents($stream),
'' => self::deserialize_updateChannelTooLong($stream),
'	L[c' => [
'_' => 'updateChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'b' => [
'_' => 'updateNewChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'n.' => self::deserialize_updateReadChannelInbox($stream),
'[-' => [
'_' => 'updateDeleteChannelMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&' => [
'_' => 'updateChannelMessageViews',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'views' => unpack('l', stream_get_contents($stream, 4))[1],
],
'a' => [
'_' => 'updateChatParticipantAdmin',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'is_admin' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'0h' => [
'_' => 'updateNewStickerSet',
'stickerset' => match (stream_get_contents($stream, 4)) {
'?n' => self::deserialize_messages___stickerSet($stream),
'$' => [
'_' => 'messages.stickerSetNotModified',
],
'r0' => self::deserialize_type_messages___StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ҳ' => self::deserialize_updateStickerSetsOrder($stream),
'H1' => self::deserialize_updateStickerSets($stream),
'4u' => [
'_' => 'updateSavedGifs',
],
'7oI' => self::deserialize_updateBotInlineQuery($stream),
'*' => self::deserialize_updateBotInlineSend($stream),
'M?' => [
'_' => 'updateEditChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ϲ' => self::deserialize_updateBotCallbackQuery($stream),
'p' => [
'_' => 'updateEditMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ri' => self::deserialize_updateInlineBotCallbackQuery($stream),
'_' => [
'_' => 'updateReadChannelOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'mI' => self::deserialize_updateDraftMessage($stream),
'B\'W' => [
'_' => 'updateReadFeaturedStickers',
],
' ,B' => [
'_' => 'updateRecentStickers',
],
')' => [
'_' => 'updateConfig',
],
'gT3' => [
'_' => 'updatePtsChanged',
],
'+/' => [
'_' => 'updateChannelWebPage',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'on' => self::deserialize_updateDialogPinned($stream),
'<' => self::deserialize_updatePinnedDialogs($stream),
'' => [
'_' => 'updateBotWebhookJSON',
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => [
'_' => 'updateBotWebhookJSONQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
'timeout' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}' => [
'_' => 'updateBotShippingQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'payload' => self::deserialize_bytes($stream),
'shipping_address' => match (stream_get_contents($stream, 4)) {
'몌' => [
'_' => 'postAddress',
'street_line1' => self::deserialize_string($stream),
'street_line2' => self::deserialize_string($stream),
'city' => self::deserialize_string($stream),
'state' => self::deserialize_string($stream),
'country_iso2' => self::deserialize_string($stream),
'post_code' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_PostAddress(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updateBotPrecheckoutQuery($stream),
'k' => [
'_' => 'updatePhoneCall',
'phone_call' => match (stream_get_contents($stream, 4)) {
'fS' => [
'_' => 'phoneCallEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'o"' => self::deserialize_phoneCallWaiting($stream),
'' => self::deserialize_phoneCallRequested($stream),
'`6' => self::deserialize_phoneCallAccepted($stream),
'g|' => self::deserialize_phoneCall($stream),
'MP' => self::deserialize_phoneCallDiscarded($stream),
'r0' => self::deserialize_type_PhoneCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'dVF' => [
'_' => 'updateLangPackTooLong',
'lang_code' => self::deserialize_string($stream),
],
'M/V' => [
'_' => 'updateLangPack',
'difference' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'langPackDifference',
'lang_code' => self::deserialize_string($stream),
'from_version' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
'strings' => self::deserialize_type_array_of_LangPackString(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_LangPackDifference(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'm' => [
'_' => 'updateFavedStickers',
],
'])' => self::deserialize_updateChannelReadMessagesContents($stream),
'p' => [
'_' => 'updateContactsReset',
],
'?' => [
'_' => 'updateChannelAvailableMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'available_min_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yd' => self::deserialize_updateDialogUnreadMark($stream),
'{e' => self::deserialize_updateMessagePoll($stream),
'PT' => [
'_' => 'updateChatDefaultBannedRights',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'default_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
6' => [
'_' => 'updateFolderPeers',
'folder_peers' => self::deserialize_type_array_of_FolderPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'fs~j' => [
'_' => 'updatePeerSettings',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'settings' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_peerSettings($stream),
'r0' => self::deserialize_type_PeerSettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ϯ' => [
'_' => 'updatePeerLocated',
'peers' => self::deserialize_type_array_of_PeerLocated(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'9' => [
'_' => 'updateNewScheduledMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'l' => [
'_' => 'updateDeleteScheduledMessages',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateTheme',
'theme' => match (stream_get_contents($stream, 4)) {
'g' => self::deserialize_theme($stream),
'r0' => self::deserialize_type_Theme(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'9' => [
'_' => 'updateGeoLiveViewed',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'OV' => [
'_' => 'updateLoginToken',
],
'w$' => [
'_' => 'updateMessagePollVote',
'poll_id' => unpack('q', stream_get_contents($stream, 8))[1],
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'options' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}&' => self::deserialize_updateDialogFilter($stream),
'!ץ' => [
'_' => 'updateDialogFilterOrder',
'order' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'O5' => [
'_' => 'updateDialogFilters',
],
'	a&' => [
'_' => 'updatePhoneCallSignalingData',
'phone_call_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => self::deserialize_bytes($stream),
],
'\'' => [
'_' => 'updateChannelMessageForwards',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'forwards' => unpack('l', stream_get_contents($stream, 4))[1],
],
'F' => self::deserialize_updateReadChannelDiscussionInbox($stream),
'|\\i' => [
'_' => 'updateReadChannelDiscussionOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'read_max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Rw' => self::deserialize_updatePeerBlocked($stream),
'#Ɉ' => self::deserialize_updateChannelUserTyping($stream),
'' => self::deserialize_updatePinnedMessages($stream),
'[' => self::deserialize_updatePinnedChannelMessages($stream),
'Nj' => [
'_' => 'updateChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'N' => [
'_' => 'updateGroupCallParticipants',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'participants' => self::deserialize_type_array_of_GroupCallParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' . "\0" . 'E' => [
'_' => 'updateGroupCall',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'call' => match (stream_get_contents($stream, 4)) {
'w' => [
'_' => 'groupCallDiscarded',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
],
'e' => self::deserialize_groupCall($stream),
'r0' => self::deserialize_type_GroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updatePeerHistoryTTL($stream),
':f' => self::deserialize_updateChatParticipant($stream),
':]' => self::deserialize_updateChannelParticipant($stream),
'I
' => [
'_' => 'updateBotStopped',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'stopped' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'9x' => self::deserialize_updateGroupCallConnection($stream),
'./qM' => [
'_' => 'updateBotCommands',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'commands' => self::deserialize_type_array_of_BotCommand(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'cp' => [
'_' => 'updatePendingJoinRequests',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'requests_pending' => unpack('l', stream_get_contents($stream, 4))[1],
'recent_requesters' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateBotChatInviteRequester',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'about' => self::deserialize_string($stream),
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'<^' => self::deserialize_updateMessageReactions($stream),
'' => [
'_' => 'updateAttachMenuBots',
],
'' => [
'_' => 'updateWebViewResultSent',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'X' => [
'_' => 'updateBotMenuButton',
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'button' => match (stream_get_contents($stream, 4)) {
'3u' => [
'_' => 'botMenuButtonDefault',
],
'XB' => [
'_' => 'botMenuButtonCommands',
],
'|' => [
'_' => 'botMenuButton',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_BotMenuButton(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
't' => [
'_' => 'updateSavedRingtones',
],
'Z̈́' . "\0" . '' => self::deserialize_updateTranscribedAudio($stream),
'lIL' => [
'_' => 'updateReadFeaturedEmojiStickers',
],
'57(' => [
'_' => 'updateUserEmojiStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'emoji_status' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'C0' => [
'_' => 'updateRecentEmojiStatuses',
],
'cxo' => [
'_' => 'updateRecentReactions',
],
'' => self::deserialize_updateMoveStickerSetToTop($stream),
'sZ' => [
'_' => 'updateMessageExtendedMedia',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'extended_media' => match (stream_get_contents($stream, 4)) {
'Ȍb' => self::deserialize_messageExtendedMediaPreview($stream),
'dG' => [
'_' => 'messageExtendedMedia',
'media' => match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_MessageExtendedMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.' => self::deserialize_updateChannelPinnedTopic($stream),
'' => self::deserialize_updateChannelPinnedTopics($stream),
'8R ' => [
'_' => 'updateUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'updateAutoSaveSettings',
],
'֊' => [
'_' => 'updateGroupInvitePrivacyForbidden',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'u' => [
'_' => 'updateStory',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story' => match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+N' => [
'_' => 'updateReadStories',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => [
'_' => 'updateStoryID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'M,' => [
'_' => 'updateStoriesStealthMode',
'stealth_mode' => match (stream_get_contents($stream, 4)) {
'\'.q' => self::deserialize_storiesStealthMode($stream),
'r0' => self::deserialize_type_StoriesStealthMode(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'vb}' => [
'_' => 'updateSentStoryReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
'reaction' => match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => [
'_' => 'updateBotChatBoost',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'boost' => match (stream_get_contents($stream, 4)) {
'q*' => self::deserialize_boost($stream),
'r0' => self::deserialize_type_Boost(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
' ' => [
'_' => 'updateChannelViewForumAsMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'enabled' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'?' => self::deserialize_updatePeerWallpaper($stream),
'!' => [
'_' => 'updateBotMessageReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'actor' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'old_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'new_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yw	' => [
'_' => 'updateBotMessageReactions',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'reactions' => self::deserialize_type_array_of_ReactionCount(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
't' => self::deserialize_updateSavedDialogPinned($stream),
'lh' => self::deserialize_updatePinnedSavedDialogs($stream),
'2t9' => [
'_' => 'updateSavedReactionTags',
],
'ib' => [
'_' => 'updateSmsJob',
'job_id' => self::deserialize_string($stream),
],
'
G' => [
'_' => 'updateQuickReplies',
'quick_replies' => self::deserialize_type_array_of_QuickReply(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'=' => [
'_' => 'updateNewQuickReply',
'quick_reply' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'quickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'shortcut' => self::deserialize_string($stream),
'top_message' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_QuickReply(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'S' => [
'_' => 'updateDeleteQuickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
>' => [
'_' => 'updateQuickReplyMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'oV' => [
'_' => 'updateDeleteQuickReplyMessages',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_Update(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_Update(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'
+' => [
'_' => 'updateNewMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ֿN' => [
'_' => 'updateMessageID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
' => [
'_' => 'updateDeleteMessages',
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateUserTyping',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'zH' => [
'_' => 'updateChatUserTyping',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'from_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'v' => [
'_' => 'updateChatParticipants',
'participants' => match (stream_get_contents($stream, 4)) {
'c' => self::deserialize_chatParticipantsForbidden($stream),
'<' => [
'_' => 'chatParticipants',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participants' => self::deserialize_type_array_of_ChatParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipants(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'updateUserStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'status' => match (stream_get_contents($stream, 4)) {
'IP	' => [
'_' => 'userStatusEmpty',
],
'I9' => [
'_' => 'userStatusOnline',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?p' . "\0" . '' => [
'_' => 'userStatusOffline',
'was_online' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}{' => self::deserialize_userStatusRecently($stream),
'T' => self::deserialize_userStatusLastWeek($stream),
'we' => self::deserialize_userStatusLastMonth($stream),
'r0' => self::deserialize_type_UserStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$' => [
'_' => 'updateUserName',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'usernames' => self::deserialize_type_array_of_Username(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Q' => self::deserialize_updateNewAuthorization($stream),
'' => [
'_' => 'updateNewEncryptedMessage',
'message' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'encryptedMessage',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
'file' => match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ks#' => [
'_' => 'encryptedMessageService',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_EncryptedMessage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'V' => [
'_' => 'updateEncryptedChatTyping',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'袴' => [
'_' => 'updateEncryption',
'chat' => match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'encryptedChatEmpty',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SYf' => [
'_' => 'encryptedChatWaiting',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'LH' => self::deserialize_encryptedChatRequested($stream),
'a' => [
'_' => 'encryptedChat',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a_or_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'E|' => self::deserialize_encryptedChatDiscarded($stream),
'r0' => self::deserialize_type_EncryptedChat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'%8' => [
'_' => 'updateEncryptedMessagesRead',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'max_date' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'QT=' => [
'_' => 'updateChatParticipantAdd',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'w=/' => [
'_' => 'updateChatParticipantDelete',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
's^' => [
'_' => 'updateDcOptions',
'dc_options' => self::deserialize_type_array_of_DcOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'h¾' => [
'_' => 'updateNotifySettings',
'peer' => match (stream_get_contents($stream, 4)) {
'ԟ' => [
'_' => 'notifyPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'L;ȴ' => [
'_' => 'notifyUsers',
],
'' => [
'_' => 'notifyChats',
],
'' => [
'_' => 'notifyBroadcasts',
],
'cn"' => [
'_' => 'notifyForumTopic',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_NotifyPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'notify_settings' => match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'h' => self::deserialize_updateServiceNotification($stream),
'*\';' => [
'_' => 'updatePrivacy',
'key' => match (stream_get_contents($stream, 4)) {
'0.' => [
'_' => 'privacyKeyStatusTimestamp',
],
'mP' => [
'_' => 'privacyKeyChatInvite',
],
'{+f=' => [
'_' => 'privacyKeyPhoneCall',
],
'I9' => [
'_' => 'privacyKeyPhoneP2P',
],
'Vi' => [
'_' => 'privacyKeyForwards',
],
'' => [
'_' => 'privacyKeyProfilePhoto',
],
'm' => [
'_' => 'privacyKeyPhoneNumber',
],
'+B' => [
'_' => 'privacyKeyAddedByPhone',
],
'' => [
'_' => 'privacyKeyVoiceMessages',
],
'a' => [
'_' => 'privacyKeyAbout',
],
'r0' => self::deserialize_type_PrivacyKey(self::gzdecode($stream)),
default => self::err($stream)
}
,
'rules' => self::deserialize_type_array_of_PrivacyRule(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'*I' => [
'_' => 'updateUserPhone',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'phone' => self::deserialize_string($stream),
],
'O' => self::deserialize_updateReadHistoryInbox($stream),
'!//' => [
'_' => 'updateReadHistoryOutbox',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateWebPage',
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q"' => self::deserialize_updateReadMessagesContents($stream),
'' => self::deserialize_updateChannelTooLong($stream),
'	L[c' => [
'_' => 'updateChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'b' => [
'_' => 'updateNewChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'n.' => self::deserialize_updateReadChannelInbox($stream),
'[-' => [
'_' => 'updateDeleteChannelMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&' => [
'_' => 'updateChannelMessageViews',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'views' => unpack('l', stream_get_contents($stream, 4))[1],
],
'a' => [
'_' => 'updateChatParticipantAdmin',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'is_admin' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'0h' => [
'_' => 'updateNewStickerSet',
'stickerset' => match (stream_get_contents($stream, 4)) {
'?n' => self::deserialize_messages___stickerSet($stream),
'$' => [
'_' => 'messages.stickerSetNotModified',
],
'r0' => self::deserialize_type_messages___StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ҳ' => self::deserialize_updateStickerSetsOrder($stream),
'H1' => self::deserialize_updateStickerSets($stream),
'4u' => [
'_' => 'updateSavedGifs',
],
'7oI' => self::deserialize_updateBotInlineQuery($stream),
'*' => self::deserialize_updateBotInlineSend($stream),
'M?' => [
'_' => 'updateEditChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ϲ' => self::deserialize_updateBotCallbackQuery($stream),
'p' => [
'_' => 'updateEditMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ri' => self::deserialize_updateInlineBotCallbackQuery($stream),
'_' => [
'_' => 'updateReadChannelOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'mI' => self::deserialize_updateDraftMessage($stream),
'B\'W' => [
'_' => 'updateReadFeaturedStickers',
],
' ,B' => [
'_' => 'updateRecentStickers',
],
')' => [
'_' => 'updateConfig',
],
'gT3' => [
'_' => 'updatePtsChanged',
],
'+/' => [
'_' => 'updateChannelWebPage',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'on' => self::deserialize_updateDialogPinned($stream),
'<' => self::deserialize_updatePinnedDialogs($stream),
'' => [
'_' => 'updateBotWebhookJSON',
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => [
'_' => 'updateBotWebhookJSONQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
'timeout' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}' => [
'_' => 'updateBotShippingQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'payload' => self::deserialize_bytes($stream),
'shipping_address' => match (stream_get_contents($stream, 4)) {
'몌' => [
'_' => 'postAddress',
'street_line1' => self::deserialize_string($stream),
'street_line2' => self::deserialize_string($stream),
'city' => self::deserialize_string($stream),
'state' => self::deserialize_string($stream),
'country_iso2' => self::deserialize_string($stream),
'post_code' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_PostAddress(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updateBotPrecheckoutQuery($stream),
'k' => [
'_' => 'updatePhoneCall',
'phone_call' => match (stream_get_contents($stream, 4)) {
'fS' => [
'_' => 'phoneCallEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'o"' => self::deserialize_phoneCallWaiting($stream),
'' => self::deserialize_phoneCallRequested($stream),
'`6' => self::deserialize_phoneCallAccepted($stream),
'g|' => self::deserialize_phoneCall($stream),
'MP' => self::deserialize_phoneCallDiscarded($stream),
'r0' => self::deserialize_type_PhoneCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'dVF' => [
'_' => 'updateLangPackTooLong',
'lang_code' => self::deserialize_string($stream),
],
'M/V' => [
'_' => 'updateLangPack',
'difference' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'langPackDifference',
'lang_code' => self::deserialize_string($stream),
'from_version' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
'strings' => self::deserialize_type_array_of_LangPackString(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_LangPackDifference(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'm' => [
'_' => 'updateFavedStickers',
],
'])' => self::deserialize_updateChannelReadMessagesContents($stream),
'p' => [
'_' => 'updateContactsReset',
],
'?' => [
'_' => 'updateChannelAvailableMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'available_min_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yd' => self::deserialize_updateDialogUnreadMark($stream),
'{e' => self::deserialize_updateMessagePoll($stream),
'PT' => [
'_' => 'updateChatDefaultBannedRights',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'default_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
6' => [
'_' => 'updateFolderPeers',
'folder_peers' => self::deserialize_type_array_of_FolderPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'fs~j' => [
'_' => 'updatePeerSettings',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'settings' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_peerSettings($stream),
'r0' => self::deserialize_type_PeerSettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ϯ' => [
'_' => 'updatePeerLocated',
'peers' => self::deserialize_type_array_of_PeerLocated(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'9' => [
'_' => 'updateNewScheduledMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'l' => [
'_' => 'updateDeleteScheduledMessages',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateTheme',
'theme' => match (stream_get_contents($stream, 4)) {
'g' => self::deserialize_theme($stream),
'r0' => self::deserialize_type_Theme(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'9' => [
'_' => 'updateGeoLiveViewed',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'OV' => [
'_' => 'updateLoginToken',
],
'w$' => [
'_' => 'updateMessagePollVote',
'poll_id' => unpack('q', stream_get_contents($stream, 8))[1],
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'options' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}&' => self::deserialize_updateDialogFilter($stream),
'!ץ' => [
'_' => 'updateDialogFilterOrder',
'order' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'O5' => [
'_' => 'updateDialogFilters',
],
'	a&' => [
'_' => 'updatePhoneCallSignalingData',
'phone_call_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => self::deserialize_bytes($stream),
],
'\'' => [
'_' => 'updateChannelMessageForwards',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'forwards' => unpack('l', stream_get_contents($stream, 4))[1],
],
'F' => self::deserialize_updateReadChannelDiscussionInbox($stream),
'|\\i' => [
'_' => 'updateReadChannelDiscussionOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'read_max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Rw' => self::deserialize_updatePeerBlocked($stream),
'#Ɉ' => self::deserialize_updateChannelUserTyping($stream),
'' => self::deserialize_updatePinnedMessages($stream),
'[' => self::deserialize_updatePinnedChannelMessages($stream),
'Nj' => [
'_' => 'updateChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'N' => [
'_' => 'updateGroupCallParticipants',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'participants' => self::deserialize_type_array_of_GroupCallParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' . "\0" . 'E' => [
'_' => 'updateGroupCall',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'call' => match (stream_get_contents($stream, 4)) {
'w' => [
'_' => 'groupCallDiscarded',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
],
'e' => self::deserialize_groupCall($stream),
'r0' => self::deserialize_type_GroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updatePeerHistoryTTL($stream),
':f' => self::deserialize_updateChatParticipant($stream),
':]' => self::deserialize_updateChannelParticipant($stream),
'I
' => [
'_' => 'updateBotStopped',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'stopped' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'9x' => self::deserialize_updateGroupCallConnection($stream),
'./qM' => [
'_' => 'updateBotCommands',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'commands' => self::deserialize_type_array_of_BotCommand(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'cp' => [
'_' => 'updatePendingJoinRequests',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'requests_pending' => unpack('l', stream_get_contents($stream, 4))[1],
'recent_requesters' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateBotChatInviteRequester',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'about' => self::deserialize_string($stream),
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'<^' => self::deserialize_updateMessageReactions($stream),
'' => [
'_' => 'updateAttachMenuBots',
],
'' => [
'_' => 'updateWebViewResultSent',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'X' => [
'_' => 'updateBotMenuButton',
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'button' => match (stream_get_contents($stream, 4)) {
'3u' => [
'_' => 'botMenuButtonDefault',
],
'XB' => [
'_' => 'botMenuButtonCommands',
],
'|' => [
'_' => 'botMenuButton',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_BotMenuButton(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
't' => [
'_' => 'updateSavedRingtones',
],
'Z̈́' . "\0" . '' => self::deserialize_updateTranscribedAudio($stream),
'lIL' => [
'_' => 'updateReadFeaturedEmojiStickers',
],
'57(' => [
'_' => 'updateUserEmojiStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'emoji_status' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'C0' => [
'_' => 'updateRecentEmojiStatuses',
],
'cxo' => [
'_' => 'updateRecentReactions',
],
'' => self::deserialize_updateMoveStickerSetToTop($stream),
'sZ' => [
'_' => 'updateMessageExtendedMedia',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'extended_media' => match (stream_get_contents($stream, 4)) {
'Ȍb' => self::deserialize_messageExtendedMediaPreview($stream),
'dG' => [
'_' => 'messageExtendedMedia',
'media' => match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_MessageExtendedMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.' => self::deserialize_updateChannelPinnedTopic($stream),
'' => self::deserialize_updateChannelPinnedTopics($stream),
'8R ' => [
'_' => 'updateUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'updateAutoSaveSettings',
],
'֊' => [
'_' => 'updateGroupInvitePrivacyForbidden',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'u' => [
'_' => 'updateStory',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story' => match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+N' => [
'_' => 'updateReadStories',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => [
'_' => 'updateStoryID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'M,' => [
'_' => 'updateStoriesStealthMode',
'stealth_mode' => match (stream_get_contents($stream, 4)) {
'\'.q' => self::deserialize_storiesStealthMode($stream),
'r0' => self::deserialize_type_StoriesStealthMode(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'vb}' => [
'_' => 'updateSentStoryReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
'reaction' => match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => [
'_' => 'updateBotChatBoost',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'boost' => match (stream_get_contents($stream, 4)) {
'q*' => self::deserialize_boost($stream),
'r0' => self::deserialize_type_Boost(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
' ' => [
'_' => 'updateChannelViewForumAsMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'enabled' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'?' => self::deserialize_updatePeerWallpaper($stream),
'!' => [
'_' => 'updateBotMessageReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'actor' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'old_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'new_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yw	' => [
'_' => 'updateBotMessageReactions',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'reactions' => self::deserialize_type_array_of_ReactionCount(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
't' => self::deserialize_updateSavedDialogPinned($stream),
'lh' => self::deserialize_updatePinnedSavedDialogs($stream),
'2t9' => [
'_' => 'updateSavedReactionTags',
],
'ib' => [
'_' => 'updateSmsJob',
'job_id' => self::deserialize_string($stream),
],
'
G' => [
'_' => 'updateQuickReplies',
'quick_replies' => self::deserialize_type_array_of_QuickReply(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'=' => [
'_' => 'updateNewQuickReply',
'quick_reply' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'quickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'shortcut' => self::deserialize_string($stream),
'top_message' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_QuickReply(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'S' => [
'_' => 'updateDeleteQuickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
>' => [
'_' => 'updateQuickReplyMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'oV' => [
'_' => 'updateDeleteQuickReplyMessages',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_Update(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_updateShortSentMessage(mixed $stream): mixed {
$tmp = ['_' => 'updateShortSentMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['out'] = ($flags & 2) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 512) !== 0) $tmp['media'] = match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 128) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 33554432) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_autoDownloadSettings(mixed $stream): mixed {
$tmp = ['_' => 'autoDownloadSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['disabled'] = ($flags & 1) !== 0;
$tmp['video_preload_large'] = ($flags & 2) !== 0;
$tmp['audio_preload_next'] = ($flags & 4) !== 0;
$tmp['phonecalls_less_data'] = ($flags & 8) !== 0;
$tmp['stories_preload'] = ($flags & 16) !== 0;
$tmp['photo_size_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['video_size_max'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['file_size_max'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['video_upload_maxbitrate'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['small_queue_active_operations_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['large_queue_active_operations_max'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_AutoDownloadSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'(v' => self::deserialize_autoDownloadSettings($stream),
'r0' => $this->deserialize_type_AutoDownloadSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_Theme(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'g' => self::deserialize_theme($stream),
'r0' => self::deserialize_type_Theme(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_account___contentSettings(mixed $stream): mixed {
$tmp = ['_' => 'account.contentSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['sensitive_enabled'] = ($flags & 1) !== 0;
$tmp['sensitive_can_change'] = ($flags & 2) !== 0;
return $tmp;

    }
    private  function deserialize_globalPrivacySettings(mixed $stream): mixed {
$tmp = ['_' => 'globalPrivacySettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['archive_and_mute_new_noncontact_peers'] = ($flags & 1) !== 0;
$tmp['keep_archived_unmuted'] = ($flags & 2) !== 0;
$tmp['keep_archived_folders'] = ($flags & 4) !== 0;
$tmp['hide_read_marks'] = ($flags & 8) !== 0;
$tmp['new_noncontact_peers_require_premium'] = ($flags & 16) !== 0;
return $tmp;

    }
    private  function deserialize_type_array_of_EmojiStatus(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_autoSaveSettings(mixed $stream): mixed {
$tmp = ['_' => 'autoSaveSettings'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['photos'] = ($flags & 1) !== 0;
$tmp['videos'] = ($flags & 2) !== 0;
if (($flags & 4) !== 0) $tmp['video_max_size'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_AutoSaveSettings(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'4H' => self::deserialize_autoSaveSettings($stream),
'r0' => $this->deserialize_type_AutoSaveSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_AutoSaveException(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'G-`' => [
'_' => 'autoSaveException',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'settings' => match (stream_get_contents($stream, 4)) {
'4H' => self::deserialize_autoSaveSettings($stream),
'r0' => self::deserialize_type_AutoSaveSettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_AutoSaveException(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_businessRecipients(mixed $stream): mixed {
$tmp = ['_' => 'businessRecipients'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['existing_chats'] = ($flags & 1) !== 0;
$tmp['new_chats'] = ($flags & 2) !== 0;
$tmp['contacts'] = ($flags & 4) !== 0;
$tmp['non_contacts'] = ($flags & 8) !== 0;
$tmp['exclude_selected'] = ($flags & 32) !== 0;
if (($flags & 16) !== 0) $tmp['users'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_BusinessRecipients(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_businessRecipients($stream),
'r0' => $this->deserialize_type_BusinessRecipients(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_connectedBot(mixed $stream): mixed {
$tmp = ['_' => 'connectedBot'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_reply'] = ($flags & 1) !== 0;
$tmp['bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['recipients'] = match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_businessRecipients($stream),
'r0' => self::deserialize_type_BusinessRecipients(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_ConnectedBot(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => self::deserialize_connectedBot($stream),
'r0' => $this->deserialize_type_ConnectedBot(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_botInfo(mixed $stream): mixed {
$tmp = ['_' => 'botInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['description'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['description_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['description_document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['commands'] = self::deserialize_type_array_of_BotCommand(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 8) !== 0) $tmp['menu_button'] = match (stream_get_contents($stream, 4)) {
'3u' => [
'_' => 'botMenuButtonDefault',
],
'XB' => [
'_' => 'botMenuButtonCommands',
],
'|' => [
'_' => 'botMenuButton',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_BotMenuButton(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_BotInfo(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'W0' => self::deserialize_botInfo($stream),
'r0' => $this->deserialize_type_BotInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_premiumGiftOption(mixed $stream): mixed {
$tmp = ['_' => 'premiumGiftOption'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['currency'] = self::deserialize_string($stream);
$tmp['amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['bot_url'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['store_product'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_PremiumGiftOption(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Ct' => self::deserialize_premiumGiftOption($stream),
'r0' => $this->deserialize_type_PremiumGiftOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_StoryItem(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_peerStories(mixed $stream): mixed {
$tmp = ['_' => 'peerStories'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['max_read_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['stories'] = self::deserialize_type_array_of_StoryItem(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_PeerStories(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'5' => self::deserialize_peerStories($stream),
'r0' => $this->deserialize_type_PeerStories(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_BusinessWeeklyOpen(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'businessWeeklyOpen',
'start_minute' => unpack('l', stream_get_contents($stream, 4))[1],
'end_minute' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_BusinessWeeklyOpen(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_businessWorkHours(mixed $stream): mixed {
$tmp = ['_' => 'businessWorkHours'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['open_now'] = ($flags & 1) !== 0;
$tmp['timezone_id'] = self::deserialize_string($stream);
$tmp['weekly_open'] = self::deserialize_type_array_of_BusinessWeeklyOpen(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_BusinessWorkHours(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => self::deserialize_businessWorkHours($stream),
'r0' => $this->deserialize_type_BusinessWorkHours(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_businessLocation(mixed $stream): mixed {
$tmp = ['_' => 'businessLocation'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['geo_point'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['address'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_BusinessLocation(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'\\' => self::deserialize_businessLocation($stream),
'r0' => $this->deserialize_type_BusinessLocation(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_BusinessGreetingMessage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'businessGreetingMessage',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'recipients' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_businessRecipients($stream),
'r0' => self::deserialize_type_BusinessRecipients(self::gzdecode($stream)),
default => self::err($stream)
}
,
'no_activity_days' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_BusinessGreetingMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_BusinessAwayMessageSchedule(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'businessAwayMessageScheduleAlways',
],
'' => [
'_' => 'businessAwayMessageScheduleOutsideWorkHours',
],
'̞M' => [
'_' => 'businessAwayMessageScheduleCustom',
'start_date' => unpack('l', stream_get_contents($stream, 4))[1],
'end_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_BusinessAwayMessageSchedule(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_businessAwayMessage(mixed $stream): mixed {
$tmp = ['_' => 'businessAwayMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['offline_only'] = ($flags & 1) !== 0;
$tmp['shortcut_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['schedule'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'businessAwayMessageScheduleAlways',
],
'' => [
'_' => 'businessAwayMessageScheduleOutsideWorkHours',
],
'̞M' => [
'_' => 'businessAwayMessageScheduleCustom',
'start_date' => unpack('l', stream_get_contents($stream, 4))[1],
'end_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_BusinessAwayMessageSchedule(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['recipients'] = match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_businessRecipients($stream),
'r0' => self::deserialize_type_BusinessRecipients(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_BusinessAwayMessage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'\\j' => self::deserialize_businessAwayMessage($stream),
'r0' => $this->deserialize_type_BusinessAwayMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_userFull(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('userFull');
$tmp = ['_' => 'userFull'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blocked'] = ($flags & 1) !== 0;
$tmp['phone_calls_available'] = ($flags & 16) !== 0;
$tmp['phone_calls_private'] = ($flags & 32) !== 0;
$tmp['can_pin_message'] = ($flags & 128) !== 0;
$tmp['has_scheduled'] = ($flags & 4096) !== 0;
$tmp['video_calls_available'] = ($flags & 8192) !== 0;
$tmp['voice_messages_forbidden'] = ($flags & 1048576) !== 0;
$tmp['translations_disabled'] = ($flags & 8388608) !== 0;
$tmp['stories_pinned_available'] = ($flags & 67108864) !== 0;
$tmp['blocked_my_stories_from'] = ($flags & 134217728) !== 0;
$tmp['wallpaper_overridden'] = ($flags & 268435456) !== 0;
$tmp['contact_require_premium'] = ($flags & 536870912) !== 0;
$tmp['read_dates_private'] = ($flags & 1073741824) !== 0;
$flags2 = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['about'] = self::deserialize_string($stream);
$tmp['settings'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_peerSettings($stream),
'r0' => self::deserialize_type_PeerSettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2097152) !== 0) $tmp['personal_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['profile_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4194304) !== 0) $tmp['fallback_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['notify_settings'] = match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['bot_info'] = match (stream_get_contents($stream, 4)) {
'W0' => self::deserialize_botInfo($stream),
'r0' => self::deserialize_type_BotInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['pinned_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['common_chats_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2048) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16384) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32768) !== 0) $tmp['theme_emoticon'] = self::deserialize_string($stream);
if (($flags & 65536) !== 0) $tmp['private_forward_name'] = self::deserialize_string($stream);
if (($flags & 131072) !== 0) $tmp['bot_group_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 262144) !== 0) $tmp['bot_broadcast_admin_rights'] = match (stream_get_contents($stream, 4)) {
'$_' => self::deserialize_chatAdminRights($stream),
'r0' => self::deserialize_type_ChatAdminRights(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 524288) !== 0) $tmp['premium_gifts'] = self::deserialize_type_array_of_PremiumGiftOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16777216) !== 0) $tmp['wallpaper'] = match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 33554432) !== 0) $tmp['stories'] = match (stream_get_contents($stream, 4)) {
'5' => self::deserialize_peerStories($stream),
'r0' => self::deserialize_type_PeerStories(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 1) !== 0) $tmp['business_work_hours'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_businessWorkHours($stream),
'r0' => self::deserialize_type_BusinessWorkHours(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 2) !== 0) $tmp['business_location'] = match (stream_get_contents($stream, 4)) {
'\\' => self::deserialize_businessLocation($stream),
'r0' => self::deserialize_type_BusinessLocation(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 4) !== 0) $tmp['business_greeting_message'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'businessGreetingMessage',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'recipients' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_businessRecipients($stream),
'r0' => self::deserialize_type_BusinessRecipients(self::gzdecode($stream)),
default => self::err($stream)
}
,
'no_activity_days' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_BusinessGreetingMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 8) !== 0) $tmp['business_away_message'] = match (stream_get_contents($stream, 4)) {
'\\j' => self::deserialize_businessAwayMessage($stream),
'r0' => self::deserialize_type_BusinessAwayMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addFullChat($tmp);
return $tmp;

    }
    private  function deserialize_type_UserFull(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'>"' => self::deserialize_userFull($stream),
'r0' => $this->deserialize_type_UserFull(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_Contact(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Z' => [
'_' => 'contact',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'mutual' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'r0' => $this->deserialize_type_Contact(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_ImportedContact(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'P<>' => [
'_' => 'importedContact',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'client_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_ImportedContact(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PopularContact(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'uA\\' => [
'_' => 'popularContact',
'client_id' => unpack('q', stream_get_contents($stream, 8))[1],
'importers' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_PopularContact(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PeerBlocked(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'peerBlocked',
'peer_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_PeerBlocked(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_TopPeerCategory(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'[f' => [
'_' => 'topPeerCategoryBotsPM',
],
'w' => [
'_' => 'topPeerCategoryBotsInline',
],
'7' => [
'_' => 'topPeerCategoryCorrespondents',
],
'J' => [
'_' => 'topPeerCategoryGroups',
],
'(' => [
'_' => 'topPeerCategoryChannels',
],
'v' => [
'_' => 'topPeerCategoryPhoneCalls',
],
'l@' => [
'_' => 'topPeerCategoryForwardUsers',
],
'' => [
'_' => 'topPeerCategoryForwardChats',
],
'r0' => $this->deserialize_type_TopPeerCategory(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_TopPeer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'[' => [
'_' => 'topPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'rating' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_TopPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_TopPeerCategoryPeers(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'B' => [
'_' => 'topPeerCategoryPeers',
'category' => match (stream_get_contents($stream, 4)) {
'[f' => [
'_' => 'topPeerCategoryBotsPM',
],
'w' => [
'_' => 'topPeerCategoryBotsInline',
],
'7' => [
'_' => 'topPeerCategoryCorrespondents',
],
'J' => [
'_' => 'topPeerCategoryGroups',
],
'(' => [
'_' => 'topPeerCategoryChannels',
],
'v' => [
'_' => 'topPeerCategoryPhoneCalls',
],
'l@' => [
'_' => 'topPeerCategoryForwardUsers',
],
'' => [
'_' => 'topPeerCategoryForwardChats',
],
'r0' => self::deserialize_type_TopPeerCategory(self::gzdecode($stream)),
default => self::err($stream)
}
,
'count' => unpack('l', stream_get_contents($stream, 4))[1],
'peers' => self::deserialize_type_array_of_TopPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_TopPeerCategoryPeers(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Message(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___messagesSlice(mixed $stream): mixed {
$tmp = ['_' => 'messages.messagesSlice'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inexact'] = ($flags & 2) !== 0;
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['next_rate'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['offset_id_offset'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_forumTopic(mixed $stream): mixed {
$tmp = ['_' => 'forumTopic'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['my'] = ($flags & 2) !== 0;
$tmp['closed'] = ($flags & 4) !== 0;
$tmp['pinned'] = ($flags & 8) !== 0;
$tmp['short'] = ($flags & 32) !== 0;
$tmp['hidden'] = ($flags & 64) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['icon_color'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['icon_emoji_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['top_message'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_inbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_outbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_mentions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_reactions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['notify_settings'] = match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['draft'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_draftMessageEmpty($stream),
'?' => self::deserialize_draftMessage($stream),
'r0' => self::deserialize_type_DraftMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_ForumTopic(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => $this->deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___channelMessages(mixed $stream): mixed {
$tmp = ['_' => 'messages.channelMessages'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inexact'] = ($flags & 2) !== 0;
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['offset_id_offset'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['topics'] = self::deserialize_type_array_of_ForumTopic(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_dialog(mixed $stream): mixed {
$tmp = ['_' => 'dialog'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 4) !== 0;
$tmp['unread_mark'] = ($flags & 8) !== 0;
$tmp['view_forum_as_messages'] = ($flags & 64) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['top_message'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_inbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_outbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_mentions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_reactions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['notify_settings'] = match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['draft'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_draftMessageEmpty($stream),
'?' => self::deserialize_draftMessage($stream),
'r0' => self::deserialize_type_DraftMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_folder(mixed $stream): mixed {
$tmp = ['_' => 'folder'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['autofill_new_broadcasts'] = ($flags & 1) !== 0;
$tmp['autofill_public_groups'] = ($flags & 2) !== 0;
$tmp['autofill_new_correspondents'] = ($flags & 4) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'7' => [
'_' => 'chatPhotoEmpty',
],
'n' => self::deserialize_chatPhoto($stream),
'r0' => self::deserialize_type_ChatPhoto(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_Folder(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'eNT' => self::deserialize_folder($stream),
'r0' => $this->deserialize_type_Folder(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_dialogFolder(mixed $stream): mixed {
$tmp = ['_' => 'dialogFolder'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 4) !== 0;
$tmp['folder'] = match (stream_get_contents($stream, 4)) {
'eNT' => self::deserialize_folder($stream),
'r0' => self::deserialize_type_Folder(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['top_message'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_muted_peers_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_unmuted_peers_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_muted_messages_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_unmuted_messages_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_Dialog(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => self::deserialize_dialog($stream),
'Lq' => self::deserialize_dialogFolder($stream),
'r0' => $this->deserialize_type_Dialog(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_BotInfo(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'W0' => self::deserialize_botInfo($stream),
'r0' => self::deserialize_type_BotInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_chatReactionsAll(mixed $stream): mixed {
$tmp = ['_' => 'chatReactionsAll'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['allow_custom'] = ($flags & 1) !== 0;
return $tmp;

    }
    private  function deserialize_type_ChatReactions(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_chatFull(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('chatFull');
$tmp = ['_' => 'chatFull'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_set_username'] = ($flags & 128) !== 0;
$tmp['has_scheduled'] = ($flags & 256) !== 0;
$tmp['translations_disabled'] = ($flags & 524288) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['about'] = self::deserialize_string($stream);
$tmp['participants'] = match (stream_get_contents($stream, 4)) {
'c' => self::deserialize_chatParticipantsForbidden($stream),
'<' => [
'_' => 'chatParticipants',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participants' => self::deserialize_type_array_of_ChatParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipants(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['chat_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['notify_settings'] = match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8192) !== 0) $tmp['exported_invite'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['bot_info'] = self::deserialize_type_array_of_BotInfo(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 64) !== 0) $tmp['pinned_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2048) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4096) !== 0) $tmp['call'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16384) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32768) !== 0) $tmp['groupcall_default_join_as'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 65536) !== 0) $tmp['theme_emoticon'] = self::deserialize_string($stream);
if (($flags & 131072) !== 0) $tmp['requests_pending'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 131072) !== 0) $tmp['recent_requesters'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 262144) !== 0) $tmp['available_reactions'] = match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addFullChat($tmp);
return $tmp;

    }
    private  function deserialize_type_ChannelLocation(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_channelFull(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('channelFull');
$tmp = ['_' => 'channelFull'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_view_participants'] = ($flags & 8) !== 0;
$tmp['can_set_username'] = ($flags & 64) !== 0;
$tmp['can_set_stickers'] = ($flags & 128) !== 0;
$tmp['hidden_prehistory'] = ($flags & 1024) !== 0;
$tmp['can_set_location'] = ($flags & 65536) !== 0;
$tmp['has_scheduled'] = ($flags & 524288) !== 0;
$tmp['can_view_stats'] = ($flags & 1048576) !== 0;
$tmp['blocked'] = ($flags & 4194304) !== 0;
$flags2 = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_delete_channel'] = ($flags2 & 1) !== 0;
$tmp['antispam'] = ($flags2 & 2) !== 0;
$tmp['participants_hidden'] = ($flags2 & 4) !== 0;
$tmp['translations_disabled'] = ($flags2 & 8) !== 0;
$tmp['stories_pinned_available'] = ($flags2 & 32) !== 0;
$tmp['view_forum_as_messages'] = ($flags2 & 64) !== 0;
$tmp['id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['about'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['participants_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['admins_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['kicked_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['banned_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8192) !== 0) $tmp['online_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_inbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['read_outbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['chat_photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['notify_settings'] = match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8388608) !== 0) $tmp['exported_invite'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['bot_info'] = self::deserialize_type_array_of_BotInfo(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 16) !== 0) $tmp['migrated_from_chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 16) !== 0) $tmp['migrated_from_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32) !== 0) $tmp['pinned_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 256) !== 0) $tmp['stickerset'] = match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 512) !== 0) $tmp['available_min_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2048) !== 0) $tmp['folder_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16384) !== 0) $tmp['linked_chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 32768) !== 0) $tmp['location'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 131072) !== 0) $tmp['slowmode_seconds'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 262144) !== 0) $tmp['slowmode_next_send_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4096) !== 0) $tmp['stats_dc'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2097152) !== 0) $tmp['call'] = match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16777216) !== 0) $tmp['ttl_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 33554432) !== 0) $tmp['pending_suggestions'] = self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 67108864) !== 0) $tmp['groupcall_default_join_as'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 134217728) !== 0) $tmp['theme_emoticon'] = self::deserialize_string($stream);
if (($flags & 268435456) !== 0) $tmp['requests_pending'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 268435456) !== 0) $tmp['recent_requesters'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 536870912) !== 0) $tmp['default_send_as'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1073741824) !== 0) $tmp['available_reactions'] = match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 16) !== 0) $tmp['stories'] = match (stream_get_contents($stream, 4)) {
'5' => self::deserialize_peerStories($stream),
'r0' => self::deserialize_type_PeerStories(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 128) !== 0) $tmp['wallpaper'] = match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags2 & 256) !== 0) $tmp['boosts_applied'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags2 & 512) !== 0) $tmp['boosts_unrestrict'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags2 & 1024) !== 0) $tmp['emojiset'] = match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
$this->referenceDatabase?->addOrigin($tmp);
$this->peerDatabase->addFullChat($tmp);
return $tmp;

    }
    private  function deserialize_type_ChatFull(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'8' => self::deserialize_chatFull($stream),
'TD' => self::deserialize_channelFull($stream),
'r0' => $this->deserialize_type_ChatFull(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_StickerSet(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_chatInvite(mixed $stream): mixed {
$tmp = ['_' => 'chatInvite'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['channel'] = ($flags & 1) !== 0;
$tmp['broadcast'] = ($flags & 2) !== 0;
$tmp['public'] = ($flags & 4) !== 0;
$tmp['megagroup'] = ($flags & 8) !== 0;
$tmp['request_needed'] = ($flags & 64) !== 0;
$tmp['verified'] = ($flags & 128) !== 0;
$tmp['scam'] = ($flags & 256) !== 0;
$tmp['fake'] = ($flags & 512) !== 0;
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 32) !== 0) $tmp['about'] = self::deserialize_string($stream);
$tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['participants_count'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['participants'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['color'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_StickerSetCovered(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ҥd' => [
'_' => 'stickerSetCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'cover' => match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'4' => [
'_' => 'stickerSetMultiCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'covers' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'<@' => [
'_' => 'stickerSetFullCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'keywords' => self::deserialize_type_array_of_StickerKeyword(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'documents' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
']w' => [
'_' => 'stickerSetNoCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_StickerSetCovered(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messageViews(mixed $stream): mixed {
$tmp = ['_' => 'messageViews'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['views'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['forwards'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['replies'] = match (stream_get_contents($stream, 4)) {
'փ' => self::deserialize_messageReplies($stream),
'r0' => self::deserialize_type_MessageReplies(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_MessageViews(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'=[E' => self::deserialize_messageViews($stream),
'r0' => $this->deserialize_type_MessageViews(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___savedGifs(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('messages.savedGifs');
$tmp = [
'_' => 'messages.savedGifs',
'hash' => unpack('q', stream_get_contents($stream, 8))[1],
'gifs' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_InlineBotSwitchPM(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'b <' => [
'_' => 'inlineBotSwitchPM',
'text' => self::deserialize_string($stream),
'start_param' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_InlineBotSwitchPM(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_InlineBotWebView(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Օr' => [
'_' => 'inlineBotWebView',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_InlineBotWebView(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_botInlineMessageMediaAuto(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaAuto'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['invert_media'] = ($flags & 8) !== 0;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageText(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageText'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['no_webpage'] = ($flags & 1) !== 0;
$tmp['invert_media'] = ($flags & 8) !== 0;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageMediaGeo(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaGeo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['geo'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['heading'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 8) !== 0) $tmp['proximity_notification_radius'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageMediaVenue(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaVenue'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['geo'] = match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['title'] = self::deserialize_string($stream);
$tmp['address'] = self::deserialize_string($stream);
$tmp['provider'] = self::deserialize_string($stream);
$tmp['venue_id'] = self::deserialize_string($stream);
$tmp['venue_type'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageMediaContact(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaContact'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['phone_number'] = self::deserialize_string($stream);
$tmp['first_name'] = self::deserialize_string($stream);
$tmp['last_name'] = self::deserialize_string($stream);
$tmp['vcard'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageMediaInvoice(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaInvoice'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['shipping_address_requested'] = ($flags & 2) !== 0;
$tmp['test'] = ($flags & 8) !== 0;
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMessageMediaWebPage(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMessageMediaWebPage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['invert_media'] = ($flags & 8) !== 0;
$tmp['force_large_media'] = ($flags & 16) !== 0;
$tmp['force_small_media'] = ($flags & 32) !== 0;
$tmp['manual'] = ($flags & 128) !== 0;
$tmp['safe'] = ($flags & 256) !== 0;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['url'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['reply_markup'] = match (stream_get_contents($stream, 4)) {
'[>' => self::deserialize_replyKeyboardHide($stream),
'' => self::deserialize_replyKeyboardForceReply($stream),
'љ݅' => self::deserialize_replyKeyboardMarkup($stream),
'TH' => [
'_' => 'replyInlineMarkup',
'rows' => self::deserialize_type_array_of_KeyboardButtonRow(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ReplyMarkup(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_BotInlineMessage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Lv' => self::deserialize_botInlineMessageMediaAuto($stream),
'e' => self::deserialize_botInlineMessageText($stream),
'F' => self::deserialize_botInlineMessageMediaGeo($stream),
'e' => self::deserialize_botInlineMessageMediaVenue($stream),
'' => self::deserialize_botInlineMessageMediaContact($stream),
'	J5' => self::deserialize_botInlineMessageMediaInvoice($stream),
'ٚ' => self::deserialize_botInlineMessageMediaWebPage($stream),
'r0' => $this->deserialize_type_BotInlineMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_botInlineResult(mixed $stream): mixed {
$tmp = ['_' => 'botInlineResult'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = self::deserialize_string($stream);
$tmp['type'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['description'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['url'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['thumb'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 32) !== 0) $tmp['content'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['send_message'] = match (stream_get_contents($stream, 4)) {
'Lv' => self::deserialize_botInlineMessageMediaAuto($stream),
'e' => self::deserialize_botInlineMessageText($stream),
'F' => self::deserialize_botInlineMessageMediaGeo($stream),
'e' => self::deserialize_botInlineMessageMediaVenue($stream),
'' => self::deserialize_botInlineMessageMediaContact($stream),
'	J5' => self::deserialize_botInlineMessageMediaInvoice($stream),
'ٚ' => self::deserialize_botInlineMessageMediaWebPage($stream),
'r0' => self::deserialize_type_BotInlineMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_botInlineMediaResult(mixed $stream): mixed {
$tmp = ['_' => 'botInlineMediaResult'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['id'] = self::deserialize_string($stream);
$tmp['type'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['title'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['description'] = self::deserialize_string($stream);
$tmp['send_message'] = match (stream_get_contents($stream, 4)) {
'Lv' => self::deserialize_botInlineMessageMediaAuto($stream),
'e' => self::deserialize_botInlineMessageText($stream),
'F' => self::deserialize_botInlineMessageMediaGeo($stream),
'e' => self::deserialize_botInlineMessageMediaVenue($stream),
'' => self::deserialize_botInlineMessageMediaContact($stream),
'	J5' => self::deserialize_botInlineMessageMediaInvoice($stream),
'ٚ' => self::deserialize_botInlineMessageMediaWebPage($stream),
'r0' => self::deserialize_type_BotInlineMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_BotInlineResult(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
':_' => self::deserialize_botInlineResult($stream),
'' => self::deserialize_botInlineMediaResult($stream),
'r0' => $this->deserialize_type_BotInlineResult(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___botResults(mixed $stream): mixed {
$tmp = ['_' => 'messages.botResults'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['gallery'] = ($flags & 1) !== 0;
$tmp['query_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 2) !== 0) $tmp['next_offset'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['switch_pm'] = match (stream_get_contents($stream, 4)) {
'b <' => [
'_' => 'inlineBotSwitchPM',
'text' => self::deserialize_string($stream),
'start_param' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InlineBotSwitchPM(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['switch_webview'] = match (stream_get_contents($stream, 4)) {
'Օr' => [
'_' => 'inlineBotWebView',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_InlineBotWebView(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['results'] = self::deserialize_type_array_of_BotInlineResult(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['cache_time'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_messages___messageEditData(mixed $stream): mixed {
$tmp = ['_' => 'messages.messageEditData'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['caption'] = ($flags & 1) !== 0;
return $tmp;

    }
    private  function deserialize_messages___botCallbackAnswer(mixed $stream): mixed {
$tmp = ['_' => 'messages.botCallbackAnswer'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['alert'] = ($flags & 2) !== 0;
$tmp['has_url'] = ($flags & 8) !== 0;
$tmp['native_ui'] = ($flags & 16) !== 0;
if (($flags & 1) !== 0) $tmp['message'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['url'] = self::deserialize_string($stream);
$tmp['cache_time'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_updates___State(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'>*l' => [
'_' => 'updates.state',
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'seq' => unpack('l', stream_get_contents($stream, 4))[1],
'unread_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_updates___State(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_messages___featuredStickers(mixed $stream): mixed {
$tmp = ['_' => 'messages.featuredStickers'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['premium'] = ($flags & 1) !== 0;
$tmp['hash'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['sets'] = self::deserialize_type_array_of_StickerSetCovered(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['unread'] = self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_messages___recentStickers(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('messages.recentStickers');
$tmp = [
'_' => 'messages.recentStickers',
'hash' => unpack('q', stream_get_contents($stream, 8))[1],
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'stickers' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'dates' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_array_of_HighScore(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'ys' => [
'_' => 'highScore',
'pos' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'score' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_HighScore(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___favedStickers(mixed $stream): mixed {
$this->referenceDatabase?->addOriginContext('messages.favedStickers');
$tmp = [
'_' => 'messages.favedStickers',
'hash' => unpack('q', stream_get_contents($stream, 8))[1],
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'stickers' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
];
$this->referenceDatabase?->addOrigin($tmp);
return $tmp;

    }
    private  function deserialize_type_array_of_EmojiKeyword(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'emojiKeyword',
'keyword' => self::deserialize_string($stream),
'emoticons' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'"m#' => [
'_' => 'emojiKeywordDeleted',
'keyword' => self::deserialize_string($stream),
'emoticons' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_EmojiKeyword(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_urlAuthResultRequest(mixed $stream): mixed {
$tmp = ['_' => 'urlAuthResultRequest'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['request_write_access'] = ($flags & 1) !== 0;
$tmp['bot'] = match (stream_get_contents($stream, 4)) {
'zK' => self::deserialize_userEmpty($stream),
'8D\\!' => self::deserialize_user($stream),
'r0' => self::deserialize_type_User(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['domain'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_MessagePeerVote(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'\\-̶' => [
'_' => 'messagePeerVote',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'option' => self::deserialize_bytes($stream),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
't' => [
'_' => 'messagePeerVoteInputOption',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'(F' => [
'_' => 'messagePeerVoteMultiple',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'options' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_MessagePeerVote(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___votesList(mixed $stream): mixed {
$tmp = ['_' => 'messages.votesList'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['votes'] = self::deserialize_type_array_of_MessagePeerVote(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['next_offset'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_DialogFilter(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
';R_' => self::deserialize_dialogFilter($stream),
'26' => [
'_' => 'dialogFilterDefault',
],
'' => self::deserialize_dialogFilterChatlist($stream),
'r0' => self::deserialize_type_DialogFilter(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___dialogFilters(mixed $stream): mixed {
$tmp = ['_' => 'messages.dialogFilters'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['tags_enabled'] = ($flags & 1) !== 0;
$tmp['filters'] = self::deserialize_type_array_of_DialogFilter(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_messages___discussionMessage(mixed $stream): mixed {
$tmp = ['_' => 'messages.discussionMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['read_inbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['read_outbox_max_id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['unread_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_messages___historyImportParsed(mixed $stream): mixed {
$tmp = ['_' => 'messages.historyImportParsed'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pm'] = ($flags & 1) !== 0;
$tmp['group'] = ($flags & 2) !== 0;
if (($flags & 4) !== 0) $tmp['title'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_ExportedChatInvite(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_ChatAdminWithInvites(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'#' => [
'_' => 'chatAdminWithInvites',
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'invites_count' => unpack('l', stream_get_contents($stream, 4))[1],
'revoked_invites_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_ChatAdminWithInvites(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_chatInviteImporter(mixed $stream): mixed {
$tmp = ['_' => 'chatInviteImporter'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['requested'] = ($flags & 1) !== 0;
$tmp['via_chatlist'] = ($flags & 8) !== 0;
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['about'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['approved_by'] = unpack('q', stream_get_contents($stream, 8))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_ChatInviteImporter(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Z' => self::deserialize_chatInviteImporter($stream),
'r0' => $this->deserialize_type_ChatInviteImporter(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_SearchResultsCalendarPeriod(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'S' => [
'_' => 'searchResultsCalendarPeriod',
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'min_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'max_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_SearchResultsCalendarPeriod(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___searchResultsCalendar(mixed $stream): mixed {
$tmp = ['_' => 'messages.searchResultsCalendar'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inexact'] = ($flags & 1) !== 0;
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['min_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['min_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['offset_id_offset'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['periods'] = self::deserialize_type_array_of_SearchResultsCalendarPeriod(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_SearchResultsPosition(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'gd' => [
'_' => 'searchResultPosition',
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'offset' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_SearchResultsPosition(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___messageReactionsList(mixed $stream): mixed {
$tmp = ['_' => 'messages.messageReactionsList'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['reactions'] = self::deserialize_type_array_of_MessagePeerReaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['next_offset'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_availableReaction(mixed $stream): mixed {
$tmp = ['_' => 'availableReaction'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inactive'] = ($flags & 1) !== 0;
$tmp['premium'] = ($flags & 4) !== 0;
$tmp['reaction'] = self::deserialize_string($stream);
$tmp['title'] = self::deserialize_string($stream);
$tmp['static_icon'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['appear_animation'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['select_animation'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['activate_animation'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['effect_animation'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['around_animation'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['center_icon'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_AvailableReaction(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'w' => self::deserialize_availableReaction($stream),
'r0' => $this->deserialize_type_AvailableReaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_TextWithEntities(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'F1u' => [
'_' => 'textWithEntities',
'text' => self::deserialize_string($stream),
'entities' => self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_TextWithEntities(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_AttachMenuPeerType(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'k}' => [
'_' => 'attachMenuPeerTypeSameBotPM',
],
'+' => [
'_' => 'attachMenuPeerTypeBotPM',
],
'F' => [
'_' => 'attachMenuPeerTypePM',
],
'?	' => [
'_' => 'attachMenuPeerTypeChat',
],
'{' => [
'_' => 'attachMenuPeerTypeBroadcast',
],
'r0' => $this->deserialize_type_AttachMenuPeerType(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_AttachMenuBotIconColor(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'vE' => [
'_' => 'attachMenuBotIconColor',
'name' => self::deserialize_string($stream),
'color' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_AttachMenuBotIconColor(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_attachMenuBotIcon(mixed $stream): mixed {
$tmp = ['_' => 'attachMenuBotIcon'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['name'] = self::deserialize_string($stream);
$tmp['icon'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['colors'] = self::deserialize_type_array_of_AttachMenuBotIconColor(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_AttachMenuBotIcon(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'k8' => self::deserialize_attachMenuBotIcon($stream),
'r0' => $this->deserialize_type_AttachMenuBotIcon(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_attachMenuBot(mixed $stream): mixed {
$tmp = ['_' => 'attachMenuBot'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inactive'] = ($flags & 1) !== 0;
$tmp['has_settings'] = ($flags & 2) !== 0;
$tmp['request_write_access'] = ($flags & 4) !== 0;
$tmp['show_in_attach_menu'] = ($flags & 8) !== 0;
$tmp['show_in_side_menu'] = ($flags & 16) !== 0;
$tmp['side_menu_disclaimer_needed'] = ($flags & 32) !== 0;
$tmp['bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['short_name'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['peer_types'] = self::deserialize_type_array_of_AttachMenuPeerType(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['icons'] = self::deserialize_type_array_of_AttachMenuBotIcon(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_AttachMenuBot(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_attachMenuBot($stream),
'r0' => $this->deserialize_type_AttachMenuBot(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_AttachMenuBot(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_attachMenuBot($stream),
'r0' => $this->deserialize_type_AttachMenuBot(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_webViewMessageSent(mixed $stream): mixed {
$tmp = ['_' => 'webViewMessageSent'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['msg_id'] = match (stream_get_contents($stream, 4)) {
'=' => [
'_' => 'inputBotInlineMessageID',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ٶ' => [
'_' => 'inputBotInlineMessageID64',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'owner_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputBotInlineMessageID(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_messages___transcribedAudio(mixed $stream): mixed {
$tmp = ['_' => 'messages.transcribedAudio'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pending'] = ($flags & 1) !== 0;
$tmp['transcription_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['text'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['trial_remains_num'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['trial_remains_until_date'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_EmojiGroup(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'z' => [
'_' => 'emojiGroup',
'title' => self::deserialize_string($stream),
'icon_emoji_id' => unpack('q', stream_get_contents($stream, 8))[1],
'emoticons' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_EmojiGroup(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___botApp(mixed $stream): mixed {
$tmp = ['_' => 'messages.botApp'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['inactive'] = ($flags & 1) !== 0;
$tmp['request_write_access'] = ($flags & 2) !== 0;
$tmp['has_settings'] = ($flags & 4) !== 0;
$tmp['app'] = match (stream_get_contents($stream, 4)) {
't]' => [
'_' => 'botAppNotModified',
],
'' => self::deserialize_botApp($stream),
'r0' => self::deserialize_type_BotApp(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_savedDialog(mixed $stream): mixed {
$tmp = ['_' => 'savedDialog'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['pinned'] = ($flags & 4) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['top_message'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_SavedDialog(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'lˇ' => self::deserialize_savedDialog($stream),
'r0' => $this->deserialize_type_SavedDialog(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_savedReactionTag(mixed $stream): mixed {
$tmp = ['_' => 'savedReactionTag'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['title'] = self::deserialize_string($stream);
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_SavedReactionTag(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'(o' => self::deserialize_savedReactionTag($stream),
'r0' => $this->deserialize_type_SavedReactionTag(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_EncryptedMessage(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'encryptedMessage',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
'file' => match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ks#' => [
'_' => 'encryptedMessageService',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_EncryptedMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_updates___channelDifferenceEmpty(mixed $stream): mixed {
$tmp = ['_' => 'updates.channelDifferenceEmpty'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['final'] = ($flags & 1) !== 0;
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['timeout'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_Dialog(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'' => self::deserialize_dialog($stream),
'Lq' => self::deserialize_dialogFolder($stream),
'r0' => $this->deserialize_type_Dialog(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_updates___channelDifferenceTooLong(mixed $stream): mixed {
$tmp = ['_' => 'updates.channelDifferenceTooLong'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['final'] = ($flags & 1) !== 0;
if (($flags & 2) !== 0) $tmp['timeout'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['dialog'] = match (stream_get_contents($stream, 4)) {
'' => self::deserialize_dialog($stream),
'Lq' => self::deserialize_dialogFolder($stream),
'r0' => self::deserialize_type_Dialog(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_updates___channelDifference(mixed $stream): mixed {
$tmp = ['_' => 'updates.channelDifference'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['final'] = ($flags & 1) !== 0;
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['timeout'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['new_messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['other_updates'] = self::deserialize_type_array_of_Update(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_storage___FileType(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
';' => [
'_' => 'storage.fileUnknown',
],
'Ro@' => [
'_' => 'storage.filePartial',
],
'~' . "\0" . '' => [
'_' => 'storage.fileJpeg',
],
'ߪ' => [
'_' => 'storage.fileGif',
],
'cO
' => [
'_' => 'storage.filePng',
],
'P' => [
'_' => 'storage.filePdf',
],
'wR' => [
'_' => 'storage.fileMp3',
],
'	K' => [
'_' => 'storage.fileMov',
],
'γ' => [
'_' => 'storage.fileMp4',
],
'LF' => [
'_' => 'storage.fileWebp',
],
'r0' => $this->deserialize_type_storage___FileType(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_FileHash(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'\\' => [
'_' => 'fileHash',
'offset' => unpack('q', stream_get_contents($stream, 8))[1],
'limit' => unpack('l', stream_get_contents($stream, 4))[1],
'hash' => self::deserialize_bytes($stream),
],
'r0' => $this->deserialize_type_FileHash(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_config(mixed $stream): mixed {
$tmp = ['_' => 'config'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['default_p2p_contacts'] = ($flags & 8) !== 0;
$tmp['preload_featured_stickers'] = ($flags & 16) !== 0;
$tmp['revoke_pm_inbox'] = ($flags & 64) !== 0;
$tmp['blocked_mode'] = ($flags & 256) !== 0;
$tmp['force_try_ipv6'] = ($flags & 16384) !== 0;
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['expires'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['test_mode'] = match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) };
$tmp['this_dc'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['dc_options'] = self::deserialize_type_array_of_DcOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['dc_txt_domain_name'] = self::deserialize_string($stream);
$tmp['chat_size_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['megagroup_size_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['forwarded_count_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['online_update_period_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['offline_blur_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['offline_idle_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['online_cloud_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['notify_cloud_delay_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['notify_default_delay_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['push_chat_period_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['push_chat_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['edit_time_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['revoke_time_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['revoke_pm_time_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['rating_e_decay'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['stickers_recent_limit'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['channels_read_media_period'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['tmp_sessions'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['call_receive_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['call_ring_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['call_connect_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['call_packet_timeout_ms'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['me_url_prefix'] = self::deserialize_string($stream);
if (($flags & 128) !== 0) $tmp['autoupdate_url_prefix'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['gif_search_username'] = self::deserialize_string($stream);
if (($flags & 1024) !== 0) $tmp['venue_search_username'] = self::deserialize_string($stream);
if (($flags & 2048) !== 0) $tmp['img_search_username'] = self::deserialize_string($stream);
if (($flags & 4096) !== 0) $tmp['static_maps_provider'] = self::deserialize_string($stream);
$tmp['caption_length_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['message_length_max'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['webfile_dc_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['suggested_lang_code'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['lang_pack_version'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['base_lang_pack_version'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 32768) !== 0) $tmp['reactions_default'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 65536) !== 0) $tmp['autologin_token'] = self::deserialize_string($stream);
$this->API->populateConfig($tmp);
return $tmp;

    }
    private  function deserialize_help___appUpdate(mixed $stream): mixed {
$tmp = ['_' => 'help.appUpdate'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_not_skip'] = ($flags & 1) !== 0;
$tmp['id'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['version'] = self::deserialize_string($stream);
$tmp['text'] = self::deserialize_string($stream);
$tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['document'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['url'] = self::deserialize_string($stream);
if (($flags & 8) !== 0) $tmp['sticker'] = match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_help___support(mixed $stream): mixed {
$tmp = [
'_' => 'help.support',
'phone_number' => self::deserialize_string($stream),
'user' => match (stream_get_contents($stream, 4)) {
'zK' => self::deserialize_userEmpty($stream),
'8D\\!' => self::deserialize_user($stream),
'r0' => self::deserialize_type_User(self::gzdecode($stream)),
default => self::err($stream)
}
,
];
$this->API->populateSupportUser($tmp);
return $tmp;

    }
    private  function deserialize_type_array_of_CdnPublicKey(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'cdnPublicKey',
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'public_key' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_CdnPublicKey(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_ChatInvite(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'|mhZ' => [
'_' => 'chatInviteAlready',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => self::deserialize_chatInvite($stream),
'\\ia' => [
'_' => 'chatInvitePeek',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_ChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_StickerSetCovered(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ҥd' => [
'_' => 'stickerSetCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'cover' => match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'4' => [
'_' => 'stickerSetMultiCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'covers' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'<@' => [
'_' => 'stickerSetFullCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'keywords' => self::deserialize_type_array_of_StickerKeyword(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'documents' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
']w' => [
'_' => 'stickerSetNoCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_StickerSetCovered(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_RecentMeUrl(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'=F' => [
'_' => 'recentMeUrlUnknown',
'url' => self::deserialize_string($stream),
],
'	,' => [
'_' => 'recentMeUrlUser',
'url' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'qڲ' => [
'_' => 'recentMeUrlChat',
'url' => self::deserialize_string($stream),
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'I' => [
'_' => 'recentMeUrlChatInvite',
'url' => self::deserialize_string($stream),
'chat_invite' => match (stream_get_contents($stream, 4)) {
'|mhZ' => [
'_' => 'chatInviteAlready',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => self::deserialize_chatInvite($stream),
'\\ia' => [
'_' => 'chatInvitePeek',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'W
' => [
'_' => 'recentMeUrlStickerSet',
'url' => self::deserialize_string($stream),
'set' => match (stream_get_contents($stream, 4)) {
'ҥd' => [
'_' => 'stickerSetCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'cover' => match (stream_get_contents($stream, 4)) {
'q6' => [
'_' => 'documentEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ԏ' => self::deserialize_document($stream),
'r0' => self::deserialize_type_Document(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'4' => [
'_' => 'stickerSetMultiCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'covers' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'<@' => [
'_' => 'stickerSetFullCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'packs' => self::deserialize_type_array_of_StickerPack(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'keywords' => self::deserialize_type_array_of_StickerKeyword(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'documents' => self::deserialize_type_array_of_Document(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
']w' => [
'_' => 'stickerSetNoCovered',
'set' => match (stream_get_contents($stream, 4)) {
'N-' => self::deserialize_stickerSet($stream),
'r0' => self::deserialize_type_StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_StickerSetCovered(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_RecentMeUrl(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_help___deepLinkInfo(mixed $stream): mixed {
$tmp = ['_' => 'help.deepLinkInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['update_app'] = ($flags & 1) !== 0;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_JSONObjectValue(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result[self::deserialize_string($stream)] = match (stream_get_contents($stream, 4)) {
'h{m?' => null,
'j^4' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'+' => unpack('d', stream_get_contents($stream, 8))[1],
'zv' => self::deserialize_string($stream),
'cGD' => $this->deserialize_type_array_of_JSONValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'' => $this->deserialize_type_array_of_JSONObjectValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'r0' => $this->deserialize_type_JSONValue(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private static function deserialize_type_array_of_JSONValue(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'h{m?' => null,
'j^4' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'+' => unpack('d', stream_get_contents($stream, 8))[1],
'zv' => self::deserialize_string($stream),
'cGD' => $this->deserialize_type_array_of_JSONValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'' => self::deserialize_type_array_of_JSONObjectValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'r0' => $this->deserialize_type_JSONValue(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private static function deserialize_type_JSONValue(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'h{m?' => null,
'j^4' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'+' => unpack('d', stream_get_contents($stream, 8))[1],
'zv' => self::deserialize_string($stream),
'cGD' => $this->deserialize_type_array_of_JSONValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'' => self::deserialize_type_array_of_JSONObjectValue(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'r0' => $this->deserialize_type_JSONValue(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_help___promoData(mixed $stream): mixed {
$tmp = ['_' => 'help.promoData'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['proxy'] = ($flags & 1) !== 0;
$tmp['expires'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['psa_type'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['psa_message'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_help___countryCode(mixed $stream): mixed {
$tmp = ['_' => 'help.countryCode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['country_code'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['prefixes'] = self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2) !== 0) $tmp['patterns'] = self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_help___CountryCode(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'B' => self::deserialize_help___countryCode($stream),
'r0' => $this->deserialize_type_help___CountryCode(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_help___country(mixed $stream): mixed {
$tmp = ['_' => 'help.country'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['hidden'] = ($flags & 1) !== 0;
$tmp['iso2'] = self::deserialize_string($stream);
$tmp['default_name'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['name'] = self::deserialize_string($stream);
$tmp['country_codes'] = self::deserialize_type_array_of_help___CountryCode(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_help___Country(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'#' => self::deserialize_help___country($stream),
'r0' => $this->deserialize_type_help___Country(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_premiumSubscriptionOption(mixed $stream): mixed {
$tmp = ['_' => 'premiumSubscriptionOption'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['current'] = ($flags & 2) !== 0;
$tmp['can_purchase_upgrade'] = ($flags & 4) !== 0;
if (($flags & 8) !== 0) $tmp['transaction'] = self::deserialize_string($stream);
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['currency'] = self::deserialize_string($stream);
$tmp['amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['bot_url'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['store_product'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_PremiumSubscriptionOption(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'-_' => self::deserialize_premiumSubscriptionOption($stream),
'r0' => $this->deserialize_type_PremiumSubscriptionOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_help___PeerColorSet(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'X!&' => [
'_' => 'help.peerColorSet',
'colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'a}v' => [
'_' => 'help.peerColorProfileSet',
'palette_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'bg_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'story_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_help___PeerColorSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_help___peerColorOption(mixed $stream): mixed {
$tmp = ['_' => 'help.peerColorOption'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['hidden'] = ($flags & 1) !== 0;
$tmp['color_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['colors'] = match (stream_get_contents($stream, 4)) {
'X!&' => [
'_' => 'help.peerColorSet',
'colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'a}v' => [
'_' => 'help.peerColorProfileSet',
'palette_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'bg_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'story_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_help___PeerColorSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 4) !== 0) $tmp['dark_colors'] = match (stream_get_contents($stream, 4)) {
'X!&' => [
'_' => 'help.peerColorSet',
'colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'a}v' => [
'_' => 'help.peerColorProfileSet',
'palette_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'bg_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'story_colors' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_help___PeerColorSet(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['channel_min_level'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 16) !== 0) $tmp['group_min_level'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_help___PeerColorOption(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'n' => self::deserialize_help___peerColorOption($stream),
'r0' => $this->deserialize_type_help___PeerColorOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_Timezone(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'timezone',
'id' => self::deserialize_string($stream),
'name' => self::deserialize_string($stream),
'utc_offset' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_Timezone(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_ChannelParticipant(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_GroupCallParticipant(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => $this->deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_channelAdminLogEventActionParticipantJoinByInvite(mixed $stream): mixed {
$tmp = ['_' => 'channelAdminLogEventActionParticipantJoinByInvite'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_chatlist'] = ($flags & 1) !== 0;
$tmp['invite'] = match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_ForumTopic(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => $this->deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_channelAdminLogEventActionPinTopic(mixed $stream): mixed {
$tmp = ['_' => 'channelAdminLogEventActionPinTopic'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['prev_topic'] = match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['new_topic'] = match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_ChannelAdminLogEventAction(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'%' => [
'_' => 'channelAdminLogEventActionChangeTitle',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'.U' => [
'_' => 'channelAdminLogEventActionChangeAbout',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'8Jj' => [
'_' => 'channelAdminLogEventActionChangeUsername',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'KC' => [
'_' => 'channelAdminLogEventActionChangePhoto',
'prev_photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'y' => [
'_' => 'channelAdminLogEventActionToggleInvites',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'q	&' => [
'_' => 'channelAdminLogEventActionToggleSignatures',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
',' => [
'_' => 'channelAdminLogEventActionUpdatePinned',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$p' => [
'_' => 'channelAdminLogEventActionEditMessage',
'prev_message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'GB' => [
'_' => 'channelAdminLogEventActionDeleteMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@0' => [
'_' => 'channelAdminLogEventActionParticipantJoin',
],
'w' => [
'_' => 'channelAdminLogEventActionParticipantLeave',
],
'4' => [
'_' => 'channelAdminLogEventActionParticipantInvite',
'participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~=' => [
'_' => 'channelAdminLogEventActionParticipantToggleBan',
'prev_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'gg' => [
'_' => 'channelAdminLogEventActionParticipantToggleAdmin',
'prev_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ñ' => [
'_' => 'channelAdminLogEventActionChangeStickerSet',
'prev_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'\\_' => [
'_' => 'channelAdminLogEventActionTogglePreHistoryHidden',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'
-' => [
'_' => 'channelAdminLogEventActionDefaultBannedRights',
'prev_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'C' => [
'_' => 'channelAdminLogEventActionStopPoll',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'z' => [
'_' => 'channelAdminLogEventActionChangeLinkedChat',
'prev_value' => unpack('q', stream_get_contents($stream, 8))[1],
'new_value' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vk' => [
'_' => 'channelAdminLogEventActionChangeLocation',
'prev_value' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'yS' => [
'_' => 'channelAdminLogEventActionToggleSlowMode',
'prev_value' => unpack('l', stream_get_contents($stream, 4))[1],
'new_value' => unpack('l', stream_get_contents($stream, 4))[1],
],
'E #' => [
'_' => 'channelAdminLogEventActionStartGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => [
'_' => 'channelAdminLogEventActionDiscardGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$$' => [
'_' => 'channelAdminLogEventActionParticipantMute',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
')D' => [
'_' => 'channelAdminLogEventActionParticipantUnmute',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'GV' => [
'_' => 'channelAdminLogEventActionToggleGroupCallSetting',
'join_muted' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'X' => self::deserialize_channelAdminLogEventActionParticipantJoinByInvite($stream),
'PZ' => [
'_' => 'channelAdminLogEventActionExportedInviteDelete',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'N
A' => [
'_' => 'channelAdminLogEventActionExportedInviteRevoke',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Y' => [
'_' => 'channelAdminLogEventActionExportedInviteEdit',
'prev_invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Gh>' => [
'_' => 'channelAdminLogEventActionParticipantVolume',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'8n' => [
'_' => 'channelAdminLogEventActionChangeHistoryTTL',
'prev_value' => unpack('l', stream_get_contents($stream, 4))[1],
'new_value' => unpack('l', stream_get_contents($stream, 4))[1],
],
'J' => [
'_' => 'channelAdminLogEventActionParticipantJoinByRequest',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'approved_by' => unpack('q', stream_get_contents($stream, 8))[1],
],
'f*' => [
'_' => 'channelAdminLogEventActionToggleNoForwards',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'h(\'' => [
'_' => 'channelAdminLogEventActionSendMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'N' => [
'_' => 'channelAdminLogEventActionChangeAvailableReactions',
'prev_value' => match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'O' => [
'_' => 'channelAdminLogEventActionChangeUsernames',
'prev_value' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'new_value' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'c' => [
'_' => 'channelAdminLogEventActionToggleForum',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'(}pX' => [
'_' => 'channelAdminLogEventActionCreateTopic',
'topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'o' => [
'_' => 'channelAdminLogEventActionEditTopic',
'prev_topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'	' => [
'_' => 'channelAdminLogEventActionDeleteTopic',
'topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
';5]' => self::deserialize_channelAdminLogEventActionPinTopic($stream),
'md' => [
'_' => 'channelAdminLogEventActionToggleAntiSpam',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'W' => [
'_' => 'channelAdminLogEventActionChangePeerColor',
'prev_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'%{G^' => [
'_' => 'channelAdminLogEventActionChangeProfilePeerColor',
'prev_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'R]1' => [
'_' => 'channelAdminLogEventActionChangeWallpaper',
'prev_value' => match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>' => [
'_' => 'channelAdminLogEventActionChangeEmojiStatus',
'prev_value' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@F' => [
'_' => 'channelAdminLogEventActionChangeEmojiStickerSet',
'prev_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_ChannelAdminLogEventAction(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_ChannelAdminLogEvent(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'h' => [
'_' => 'channelAdminLogEvent',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'action' => match (stream_get_contents($stream, 4)) {
'%' => [
'_' => 'channelAdminLogEventActionChangeTitle',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'.U' => [
'_' => 'channelAdminLogEventActionChangeAbout',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'8Jj' => [
'_' => 'channelAdminLogEventActionChangeUsername',
'prev_value' => self::deserialize_string($stream),
'new_value' => self::deserialize_string($stream),
],
'KC' => [
'_' => 'channelAdminLogEventActionChangePhoto',
'prev_photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_photo' => match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'y' => [
'_' => 'channelAdminLogEventActionToggleInvites',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'q	&' => [
'_' => 'channelAdminLogEventActionToggleSignatures',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
',' => [
'_' => 'channelAdminLogEventActionUpdatePinned',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$p' => [
'_' => 'channelAdminLogEventActionEditMessage',
'prev_message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'GB' => [
'_' => 'channelAdminLogEventActionDeleteMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@0' => [
'_' => 'channelAdminLogEventActionParticipantJoin',
],
'w' => [
'_' => 'channelAdminLogEventActionParticipantLeave',
],
'4' => [
'_' => 'channelAdminLogEventActionParticipantInvite',
'participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~=' => [
'_' => 'channelAdminLogEventActionParticipantToggleBan',
'prev_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'gg' => [
'_' => 'channelAdminLogEventActionParticipantToggleAdmin',
'prev_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_participant' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelParticipant',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => self::deserialize_channelParticipantSelf($stream),
'/' => self::deserialize_channelParticipantCreator($stream),
'S4' => self::deserialize_channelParticipantAdmin($stream),
'Nm' => self::deserialize_channelParticipantBanned($stream),
'' => [
'_' => 'channelParticipantLeft',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ñ' => [
'_' => 'channelAdminLogEventActionChangeStickerSet',
'prev_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'\\_' => [
'_' => 'channelAdminLogEventActionTogglePreHistoryHidden',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'
-' => [
'_' => 'channelAdminLogEventActionDefaultBannedRights',
'prev_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'C' => [
'_' => 'channelAdminLogEventActionStopPoll',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'z' => [
'_' => 'channelAdminLogEventActionChangeLinkedChat',
'prev_value' => unpack('q', stream_get_contents($stream, 8))[1],
'new_value' => unpack('q', stream_get_contents($stream, 8))[1],
],
'vk' => [
'_' => 'channelAdminLogEventActionChangeLocation',
'prev_value' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'channelLocationEmpty',
],
'ۂ ' => [
'_' => 'channelLocation',
'geo_point' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'address' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_ChannelLocation(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'yS' => [
'_' => 'channelAdminLogEventActionToggleSlowMode',
'prev_value' => unpack('l', stream_get_contents($stream, 4))[1],
'new_value' => unpack('l', stream_get_contents($stream, 4))[1],
],
'E #' => [
'_' => 'channelAdminLogEventActionStartGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => [
'_' => 'channelAdminLogEventActionDiscardGroupCall',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$$' => [
'_' => 'channelAdminLogEventActionParticipantMute',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
')D' => [
'_' => 'channelAdminLogEventActionParticipantUnmute',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'GV' => [
'_' => 'channelAdminLogEventActionToggleGroupCallSetting',
'join_muted' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'X' => self::deserialize_channelAdminLogEventActionParticipantJoinByInvite($stream),
'PZ' => [
'_' => 'channelAdminLogEventActionExportedInviteDelete',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'N
A' => [
'_' => 'channelAdminLogEventActionExportedInviteRevoke',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Y' => [
'_' => 'channelAdminLogEventActionExportedInviteEdit',
'prev_invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Gh>' => [
'_' => 'channelAdminLogEventActionParticipantVolume',
'participant' => match (stream_get_contents($stream, 4)) {
'6' => self::deserialize_groupCallParticipant($stream),
'r0' => self::deserialize_type_GroupCallParticipant(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'8n' => [
'_' => 'channelAdminLogEventActionChangeHistoryTTL',
'prev_value' => unpack('l', stream_get_contents($stream, 4))[1],
'new_value' => unpack('l', stream_get_contents($stream, 4))[1],
],
'J' => [
'_' => 'channelAdminLogEventActionParticipantJoinByRequest',
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'approved_by' => unpack('q', stream_get_contents($stream, 8))[1],
],
'f*' => [
'_' => 'channelAdminLogEventActionToggleNoForwards',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'h(\'' => [
'_' => 'channelAdminLogEventActionSendMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'N' => [
'_' => 'channelAdminLogEventActionChangeAvailableReactions',
'prev_value' => match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'2' => [
'_' => 'chatReactionsNone',
],
'ʋR' => self::deserialize_chatReactionsAll($stream),
'7@f' => [
'_' => 'chatReactionsSome',
'reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ChatReactions(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'O' => [
'_' => 'channelAdminLogEventActionChangeUsernames',
'prev_value' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'new_value' => self::deserialize_type_array_of_string(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'c' => [
'_' => 'channelAdminLogEventActionToggleForum',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'(}pX' => [
'_' => 'channelAdminLogEventActionCreateTopic',
'topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'o' => [
'_' => 'channelAdminLogEventActionEditTopic',
'prev_topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'	' => [
'_' => 'channelAdminLogEventActionDeleteTopic',
'topic' => match (stream_get_contents($stream, 4)) {
'?' => [
'_' => 'forumTopicDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'pq' => self::deserialize_forumTopic($stream),
'r0' => self::deserialize_type_ForumTopic(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
';5]' => self::deserialize_channelAdminLogEventActionPinTopic($stream),
'md' => [
'_' => 'channelAdminLogEventActionToggleAntiSpam',
'new_value' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'W' => [
'_' => 'channelAdminLogEventActionChangePeerColor',
'prev_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'%{G^' => [
'_' => 'channelAdminLogEventActionChangeProfilePeerColor',
'prev_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'ZK' => self::deserialize_peerColor($stream),
'r0' => self::deserialize_type_PeerColor(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'R]1' => [
'_' => 'channelAdminLogEventActionChangeWallpaper',
'prev_value' => match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'7' => self::deserialize_wallPaper($stream),
'A' => self::deserialize_wallPaperNoFile($stream),
'r0' => self::deserialize_type_WallPaper(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'>' => [
'_' => 'channelAdminLogEventActionChangeEmojiStatus',
'prev_value' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_value' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@F' => [
'_' => 'channelAdminLogEventActionChangeEmojiStickerSet',
'prev_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
'new_stickerset' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'inputStickerSetEmpty',
],
'i' => [
'_' => 'inputStickerSetID',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'inputStickerSetShortName',
'short_name' => self::deserialize_string($stream),
],
'' => [
'_' => 'inputStickerSetAnimatedEmoji',
],
'R' => [
'_' => 'inputStickerSetDice',
'emoticon' => self::deserialize_string($stream),
],
'97' => [
'_' => 'inputStickerSetAnimatedEmojiAnimations',
],
';' => [
'_' => 'inputStickerSetPremiumGifts',
],
'' => [
'_' => 'inputStickerSetEmojiGenericAnimations',
],
')' => [
'_' => 'inputStickerSetEmojiDefaultStatuses',
],
'D' => [
'_' => 'inputStickerSetEmojiDefaultTopicIcons',
],
'StI' => [
'_' => 'inputStickerSetEmojiChannelDefaultStatuses',
],
'r0' => self::deserialize_type_InputStickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_ChannelAdminLogEventAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_ChannelAdminLogEvent(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_sponsoredWebPage(mixed $stream): mixed {
$tmp = ['_' => 'sponsoredWebPage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['url'] = self::deserialize_string($stream);
$tmp['site_name'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'-1#' => [
'_' => 'photoEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'ez' => self::deserialize_photo($stream),
'r0' => self::deserialize_type_Photo(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_SponsoredWebPage(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'c=' => self::deserialize_sponsoredWebPage($stream),
'r0' => $this->deserialize_type_SponsoredWebPage(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_sponsoredMessage(mixed $stream): mixed {
$tmp = ['_' => 'sponsoredMessage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['recommended'] = ($flags & 32) !== 0;
$tmp['show_peer_photo'] = ($flags & 64) !== 0;
$tmp['random_id'] = self::deserialize_bytes($stream);
if (($flags & 8) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['chat_invite'] = match (stream_get_contents($stream, 4)) {
'|mhZ' => [
'_' => 'chatInviteAlready',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => self::deserialize_chatInvite($stream),
'\\ia' => [
'_' => 'chatInvitePeek',
'chat' => match (stream_get_contents($stream, 4)) {
'e(V)' => self::deserialize_chatEmpty($stream),
'VA' => self::deserialize_chat($stream),
'e' => self::deserialize_chatForbidden($stream),
'
' => self::deserialize_channel($stream),
'Փ' => self::deserialize_channelForbidden($stream),
'r0' => self::deserialize_type_Chat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 16) !== 0) $tmp['chat_invite_hash'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['channel_post'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['start_param'] = self::deserialize_string($stream);
if (($flags & 512) !== 0) $tmp['webpage'] = match (stream_get_contents($stream, 4)) {
'c=' => self::deserialize_sponsoredWebPage($stream),
'r0' => self::deserialize_type_SponsoredWebPage(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1024) !== 0) $tmp['app'] = match (stream_get_contents($stream, 4)) {
't]' => [
'_' => 'botAppNotModified',
],
'' => self::deserialize_botApp($stream),
'r0' => self::deserialize_type_BotApp(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['message'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['entities'] = self::deserialize_type_array_of_MessageEntity(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 2048) !== 0) $tmp['button_text'] = self::deserialize_string($stream);
if (($flags & 128) !== 0) $tmp['sponsor_info'] = self::deserialize_string($stream);
if (($flags & 256) !== 0) $tmp['additional_info'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_array_of_SponsoredMessage(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'S' => self::deserialize_sponsoredMessage($stream),
'r0' => $this->deserialize_type_SponsoredMessage(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___sponsoredMessages(mixed $stream): mixed {
$tmp = ['_' => 'messages.sponsoredMessages'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['posts_between'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['messages'] = self::deserialize_type_array_of_SponsoredMessage(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_sendAsPeer(mixed $stream): mixed {
$tmp = ['_' => 'sendAsPeer'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['premium_required'] = ($flags & 1) !== 0;
$tmp['peer'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_SendAsPeer(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'4p' => self::deserialize_sendAsPeer($stream),
'r0' => $this->deserialize_type_SendAsPeer(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_messages___forumTopics(mixed $stream): mixed {
$tmp = ['_' => 'messages.forumTopics'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['order_by_create_date'] = ($flags & 1) !== 0;
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['topics'] = self::deserialize_type_array_of_ForumTopic(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['messages'] = self::deserialize_type_array_of_Message(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['pts'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_PaymentFormMethod(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'paymentFormMethod',
'url' => self::deserialize_string($stream),
'title' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_PaymentFormMethod(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PaymentSavedCredentials(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'z' => [
'_' => 'paymentSavedCredentialsCard',
'id' => self::deserialize_string($stream),
'title' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_PaymentSavedCredentials(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_payments___paymentForm(mixed $stream): mixed {
$tmp = ['_' => 'payments.paymentForm'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['can_save_credentials'] = ($flags & 4) !== 0;
$tmp['password_missing'] = ($flags & 8) !== 0;
$tmp['form_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
if (($flags & 32) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['invoice'] = match (stream_get_contents($stream, 4)) {
'Z]' => self::deserialize_invoice($stream),
'r0' => self::deserialize_type_Invoice(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['provider_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['url'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['native_provider'] = self::deserialize_string($stream);
if (($flags & 16) !== 0) $tmp['native_params'] = match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 64) !== 0) $tmp['additional_methods'] = self::deserialize_type_array_of_PaymentFormMethod(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['saved_info'] = match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => self::deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['saved_credentials'] = self::deserialize_type_array_of_PaymentSavedCredentials(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_ShippingOption(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'<!' => [
'_' => 'shippingOption',
'id' => self::deserialize_string($stream),
'title' => self::deserialize_string($stream),
'prices' => self::deserialize_type_array_of_LabeledPrice(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_ShippingOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_payments___paymentReceipt(mixed $stream): mixed {
$tmp = ['_' => 'payments.paymentReceipt'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['bot_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['provider_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['title'] = self::deserialize_string($stream);
$tmp['description'] = self::deserialize_string($stream);
if (($flags & 4) !== 0) $tmp['photo'] = match (stream_get_contents($stream, 4)) {
'W' => [
'_' => 'webDocument',
'url' => self::deserialize_string($stream),
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Ƽ' => [
'_' => 'webDocumentNoProxy',
'url' => self::deserialize_string($stream),
'size' => unpack('l', stream_get_contents($stream, 4))[1],
'mime_type' => self::deserialize_string($stream),
'attributes' => self::deserialize_type_array_of_DocumentAttribute(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_WebDocument(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['invoice'] = match (stream_get_contents($stream, 4)) {
'Z]' => self::deserialize_invoice($stream),
'r0' => self::deserialize_type_Invoice(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['info'] = match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => self::deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 2) !== 0) $tmp['shipping'] = match (stream_get_contents($stream, 4)) {
'<!' => [
'_' => 'shippingOption',
'id' => self::deserialize_string($stream),
'title' => self::deserialize_string($stream),
'prices' => self::deserialize_type_array_of_LabeledPrice(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ShippingOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['tip_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['currency'] = self::deserialize_string($stream);
$tmp['total_amount'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['credentials_title'] = self::deserialize_string($stream);
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_ShippingOption(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'<!' => [
'_' => 'shippingOption',
'id' => self::deserialize_string($stream),
'title' => self::deserialize_string($stream),
'prices' => self::deserialize_type_array_of_LabeledPrice(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ShippingOption(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_payments___validatedRequestedInfo(mixed $stream): mixed {
$tmp = ['_' => 'payments.validatedRequestedInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['id'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['shipping_options'] = self::deserialize_type_array_of_ShippingOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_Updates(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'updatesTooLong',
],
';1' => self::deserialize_updateShortMessage($stream),
'mM' => self::deserialize_updateShortChatMessage($stream),
'x' => [
'_' => 'updateShort',
'update' => match (stream_get_contents($stream, 4)) {
'
+' => [
'_' => 'updateNewMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ֿN' => [
'_' => 'updateMessageID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'
' => [
'_' => 'updateDeleteMessages',
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateUserTyping',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'zH' => [
'_' => 'updateChatUserTyping',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'from_id' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'action' => match (stream_get_contents($stream, 4)) {
'Nt' => [
'_' => 'sendMessageTypingAction',
],
'^' => [
'_' => 'sendMessageCancelAction',
],
'oև' => [
'_' => 'sendMessageRecordVideoAction',
],
':v' => [
'_' => 'sendMessageUploadVideoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
's/' => [
'_' => 'sendMessageRecordAudioAction',
],
'Q' => [
'_' => 'sendMessageUploadAudioAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&J' => [
'_' => 'sendMessageUploadPhotoAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'sendMessageUploadDocumentAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'o' => [
'_' => 'sendMessageGeoLocationAction',
],
'ob' => [
'_' => 'sendMessageChooseContactAction',
],
'Hj' => [
'_' => 'sendMessageGamePlayAction',
],
'' => [
'_' => 'sendMessageRecordRoundAction',
],
'f>$' => [
'_' => 'sendMessageUploadRoundAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'",' => [
'_' => 'speakingInGroupCallAction',
],
'F' => [
'_' => 'sendMessageHistoryImportAction',
'progress' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Z' => [
'_' => 'sendMessageChooseStickerAction',
],
'+%' => [
'_' => 'sendMessageEmojiInteraction',
'emoticon' => self::deserialize_string($stream),
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'interaction' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.e' => [
'_' => 'sendMessageEmojiInteractionSeen',
'emoticon' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_SendMessageAction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'v' => [
'_' => 'updateChatParticipants',
'participants' => match (stream_get_contents($stream, 4)) {
'c' => self::deserialize_chatParticipantsForbidden($stream),
'<' => [
'_' => 'chatParticipants',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participants' => self::deserialize_type_array_of_ChatParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_ChatParticipants(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => [
'_' => 'updateUserStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'status' => match (stream_get_contents($stream, 4)) {
'IP	' => [
'_' => 'userStatusEmpty',
],
'I9' => [
'_' => 'userStatusOnline',
'expires' => unpack('l', stream_get_contents($stream, 4))[1],
],
'?p' . "\0" . '' => [
'_' => 'userStatusOffline',
'was_online' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}{' => self::deserialize_userStatusRecently($stream),
'T' => self::deserialize_userStatusLastWeek($stream),
'we' => self::deserialize_userStatusLastMonth($stream),
'r0' => self::deserialize_type_UserStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'$' => [
'_' => 'updateUserName',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'usernames' => self::deserialize_type_array_of_Username(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'Q' => self::deserialize_updateNewAuthorization($stream),
'' => [
'_' => 'updateNewEncryptedMessage',
'message' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'encryptedMessage',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
'file' => match (stream_get_contents($stream, 4)) {
'~I' => [
'_' => 'encryptedFileEmpty',
],
'،' . "\0" . '' => [
'_' => 'encryptedFile',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'size' => unpack('q', stream_get_contents($stream, 8))[1],
'dc_id' => unpack('l', stream_get_contents($stream, 4))[1],
'key_fingerprint' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EncryptedFile(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ks#' => [
'_' => 'encryptedMessageService',
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'bytes' => self::deserialize_bytes($stream),
],
'r0' => self::deserialize_type_EncryptedMessage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'V' => [
'_' => 'updateEncryptedChatTyping',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'袴' => [
'_' => 'updateEncryption',
'chat' => match (stream_get_contents($stream, 4)) {
'~' => [
'_' => 'encryptedChatEmpty',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'SYf' => [
'_' => 'encryptedChatWaiting',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'LH' => self::deserialize_encryptedChatRequested($stream),
'a' => [
'_' => 'encryptedChat',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'admin_id' => unpack('q', stream_get_contents($stream, 8))[1],
'participant_id' => unpack('q', stream_get_contents($stream, 8))[1],
'g_a_or_b' => self::deserialize_bytes($stream),
'key_fingerprint' => stream_get_contents($stream, 8),
],
'E|' => self::deserialize_encryptedChatDiscarded($stream),
'r0' => self::deserialize_type_EncryptedChat(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'%8' => [
'_' => 'updateEncryptedMessagesRead',
'chat_id' => unpack('l', stream_get_contents($stream, 4))[1],
'max_date' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'QT=' => [
'_' => 'updateChatParticipantAdd',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'inviter_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'w=/' => [
'_' => 'updateChatParticipantDelete',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
's^' => [
'_' => 'updateDcOptions',
'dc_options' => self::deserialize_type_array_of_DcOption(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'h¾' => [
'_' => 'updateNotifySettings',
'peer' => match (stream_get_contents($stream, 4)) {
'ԟ' => [
'_' => 'notifyPeer',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'L;ȴ' => [
'_' => 'notifyUsers',
],
'' => [
'_' => 'notifyChats',
],
'' => [
'_' => 'notifyBroadcasts',
],
'cn"' => [
'_' => 'notifyForumTopic',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_NotifyPeer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'notify_settings' => match (stream_get_contents($stream, 4)) {
',b' => self::deserialize_peerNotifySettings($stream),
'r0' => self::deserialize_type_PeerNotifySettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'h' => self::deserialize_updateServiceNotification($stream),
'*\';' => [
'_' => 'updatePrivacy',
'key' => match (stream_get_contents($stream, 4)) {
'0.' => [
'_' => 'privacyKeyStatusTimestamp',
],
'mP' => [
'_' => 'privacyKeyChatInvite',
],
'{+f=' => [
'_' => 'privacyKeyPhoneCall',
],
'I9' => [
'_' => 'privacyKeyPhoneP2P',
],
'Vi' => [
'_' => 'privacyKeyForwards',
],
'' => [
'_' => 'privacyKeyProfilePhoto',
],
'm' => [
'_' => 'privacyKeyPhoneNumber',
],
'+B' => [
'_' => 'privacyKeyAddedByPhone',
],
'' => [
'_' => 'privacyKeyVoiceMessages',
],
'a' => [
'_' => 'privacyKeyAbout',
],
'r0' => self::deserialize_type_PrivacyKey(self::gzdecode($stream)),
default => self::err($stream)
}
,
'rules' => self::deserialize_type_array_of_PrivacyRule(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'*I' => [
'_' => 'updateUserPhone',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'phone' => self::deserialize_string($stream),
],
'O' => self::deserialize_updateReadHistoryInbox($stream),
'!//' => [
'_' => 'updateReadHistoryOutbox',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => [
'_' => 'updateWebPage',
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'q"' => self::deserialize_updateReadMessagesContents($stream),
'' => self::deserialize_updateChannelTooLong($stream),
'	L[c' => [
'_' => 'updateChannel',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'b' => [
'_' => 'updateNewChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'n.' => self::deserialize_updateReadChannelInbox($stream),
'[-' => [
'_' => 'updateDeleteChannelMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'&' => [
'_' => 'updateChannelMessageViews',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'views' => unpack('l', stream_get_contents($stream, 4))[1],
],
'a' => [
'_' => 'updateChatParticipantAdmin',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'is_admin' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'0h' => [
'_' => 'updateNewStickerSet',
'stickerset' => match (stream_get_contents($stream, 4)) {
'?n' => self::deserialize_messages___stickerSet($stream),
'$' => [
'_' => 'messages.stickerSetNotModified',
],
'r0' => self::deserialize_type_messages___StickerSet(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Ҳ' => self::deserialize_updateStickerSetsOrder($stream),
'H1' => self::deserialize_updateStickerSets($stream),
'4u' => [
'_' => 'updateSavedGifs',
],
'7oI' => self::deserialize_updateBotInlineQuery($stream),
'*' => self::deserialize_updateBotInlineSend($stream),
'M?' => [
'_' => 'updateEditChannelMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ϲ' => self::deserialize_updateBotCallbackQuery($stream),
'p' => [
'_' => 'updateEditMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Ri' => self::deserialize_updateInlineBotCallbackQuery($stream),
'_' => [
'_' => 'updateReadChannelOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'mI' => self::deserialize_updateDraftMessage($stream),
'B\'W' => [
'_' => 'updateReadFeaturedStickers',
],
' ,B' => [
'_' => 'updateRecentStickers',
],
')' => [
'_' => 'updateConfig',
],
'gT3' => [
'_' => 'updatePtsChanged',
],
'+/' => [
'_' => 'updateChannelWebPage',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'webpage' => match (stream_get_contents($stream, 4)) {
'!' => self::deserialize_webPageEmpty($stream),
'G>Ѱ' => self::deserialize_webPagePending($stream),
'E' => self::deserialize_webPage($stream),
's' => self::deserialize_webPageNotModified($stream),
'r0' => self::deserialize_type_WebPage(self::gzdecode($stream)),
default => self::err($stream)
}
,
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'on' => self::deserialize_updateDialogPinned($stream),
'<' => self::deserialize_updatePinnedDialogs($stream),
'' => [
'_' => 'updateBotWebhookJSON',
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'@' => [
'_' => 'updateBotWebhookJSONQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
,
'timeout' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}' => [
'_' => 'updateBotShippingQuery',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'payload' => self::deserialize_bytes($stream),
'shipping_address' => match (stream_get_contents($stream, 4)) {
'몌' => [
'_' => 'postAddress',
'street_line1' => self::deserialize_string($stream),
'street_line2' => self::deserialize_string($stream),
'city' => self::deserialize_string($stream),
'state' => self::deserialize_string($stream),
'country_iso2' => self::deserialize_string($stream),
'post_code' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_PostAddress(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updateBotPrecheckoutQuery($stream),
'k' => [
'_' => 'updatePhoneCall',
'phone_call' => match (stream_get_contents($stream, 4)) {
'fS' => [
'_' => 'phoneCallEmpty',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'o"' => self::deserialize_phoneCallWaiting($stream),
'' => self::deserialize_phoneCallRequested($stream),
'`6' => self::deserialize_phoneCallAccepted($stream),
'g|' => self::deserialize_phoneCall($stream),
'MP' => self::deserialize_phoneCallDiscarded($stream),
'r0' => self::deserialize_type_PhoneCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'dVF' => [
'_' => 'updateLangPackTooLong',
'lang_code' => self::deserialize_string($stream),
],
'M/V' => [
'_' => 'updateLangPack',
'difference' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'langPackDifference',
'lang_code' => self::deserialize_string($stream),
'from_version' => unpack('l', stream_get_contents($stream, 4))[1],
'version' => unpack('l', stream_get_contents($stream, 4))[1],
'strings' => self::deserialize_type_array_of_LangPackString(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_LangPackDifference(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'm' => [
'_' => 'updateFavedStickers',
],
'])' => self::deserialize_updateChannelReadMessagesContents($stream),
'p' => [
'_' => 'updateContactsReset',
],
'?' => [
'_' => 'updateChannelAvailableMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'available_min_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yd' => self::deserialize_updateDialogUnreadMark($stream),
'{e' => self::deserialize_updateMessagePoll($stream),
'PT' => [
'_' => 'updateChatDefaultBannedRights',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'default_banned_rights' => match (stream_get_contents($stream, 4)) {
'' => self::deserialize_chatBannedRights($stream),
'r0' => self::deserialize_type_ChatBannedRights(self::gzdecode($stream)),
default => self::err($stream)
}
,
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
6' => [
'_' => 'updateFolderPeers',
'folder_peers' => self::deserialize_type_array_of_FolderPeer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'pts' => unpack('l', stream_get_contents($stream, 4))[1],
'pts_count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'fs~j' => [
'_' => 'updatePeerSettings',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'settings' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_peerSettings($stream),
'r0' => self::deserialize_type_PeerSettings(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'ϯ' => [
'_' => 'updatePeerLocated',
'peers' => self::deserialize_type_array_of_PeerLocated(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'9' => [
'_' => 'updateNewScheduledMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'l' => [
'_' => 'updateDeleteScheduledMessages',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateTheme',
'theme' => match (stream_get_contents($stream, 4)) {
'g' => self::deserialize_theme($stream),
'r0' => self::deserialize_type_Theme(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'9' => [
'_' => 'updateGeoLiveViewed',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'OV' => [
'_' => 'updateLoginToken',
],
'w$' => [
'_' => 'updateMessagePollVote',
'poll_id' => unpack('q', stream_get_contents($stream, 8))[1],
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'options' => self::deserialize_type_array_of_bytes(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'}&' => self::deserialize_updateDialogFilter($stream),
'!ץ' => [
'_' => 'updateDialogFilterOrder',
'order' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'O5' => [
'_' => 'updateDialogFilters',
],
'	a&' => [
'_' => 'updatePhoneCallSignalingData',
'phone_call_id' => unpack('q', stream_get_contents($stream, 8))[1],
'data' => self::deserialize_bytes($stream),
],
'\'' => [
'_' => 'updateChannelMessageForwards',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'forwards' => unpack('l', stream_get_contents($stream, 4))[1],
],
'F' => self::deserialize_updateReadChannelDiscussionInbox($stream),
'|\\i' => [
'_' => 'updateReadChannelDiscussionOutbox',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'top_msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'read_max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Rw' => self::deserialize_updatePeerBlocked($stream),
'#Ɉ' => self::deserialize_updateChannelUserTyping($stream),
'' => self::deserialize_updatePinnedMessages($stream),
'[' => self::deserialize_updatePinnedChannelMessages($stream),
'Nj' => [
'_' => 'updateChat',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'N' => [
'_' => 'updateGroupCallParticipants',
'call' => match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'inputGroupCall',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_InputGroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
'participants' => self::deserialize_type_array_of_GroupCallParticipant(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'version' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' . "\0" . 'E' => [
'_' => 'updateGroupCall',
'chat_id' => unpack('q', stream_get_contents($stream, 8))[1],
'call' => match (stream_get_contents($stream, 4)) {
'w' => [
'_' => 'groupCallDiscarded',
'id' => unpack('q', stream_get_contents($stream, 8))[1],
'access_hash' => unpack('q', stream_get_contents($stream, 8))[1],
'duration' => unpack('l', stream_get_contents($stream, 4))[1],
],
'e' => self::deserialize_groupCall($stream),
'r0' => self::deserialize_type_GroupCall(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'' => self::deserialize_updatePeerHistoryTTL($stream),
':f' => self::deserialize_updateChatParticipant($stream),
':]' => self::deserialize_updateChannelParticipant($stream),
'I
' => [
'_' => 'updateBotStopped',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'stopped' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'9x' => self::deserialize_updateGroupCallConnection($stream),
'./qM' => [
'_' => 'updateBotCommands',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'commands' => self::deserialize_type_array_of_BotCommand(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'cp' => [
'_' => 'updatePendingJoinRequests',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'requests_pending' => unpack('l', stream_get_contents($stream, 4))[1],
'recent_requesters' => self::deserialize_type_array_of_long(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'' => [
'_' => 'updateBotChatInviteRequester',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'about' => self::deserialize_string($stream),
'invite' => match (stream_get_contents($stream, 4)) {
'
' => self::deserialize_chatInviteExported($stream),
'z' => [
'_' => 'chatInvitePublicJoinRequests',
],
'r0' => self::deserialize_type_ExportedChatInvite(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'<^' => self::deserialize_updateMessageReactions($stream),
'' => [
'_' => 'updateAttachMenuBots',
],
'' => [
'_' => 'updateWebViewResultSent',
'query_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'X' => [
'_' => 'updateBotMenuButton',
'bot_id' => unpack('q', stream_get_contents($stream, 8))[1],
'button' => match (stream_get_contents($stream, 4)) {
'3u' => [
'_' => 'botMenuButtonDefault',
],
'XB' => [
'_' => 'botMenuButtonCommands',
],
'|' => [
'_' => 'botMenuButton',
'text' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
],
'r0' => self::deserialize_type_BotMenuButton(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
't' => [
'_' => 'updateSavedRingtones',
],
'Z̈́' . "\0" . '' => self::deserialize_updateTranscribedAudio($stream),
'lIL' => [
'_' => 'updateReadFeaturedEmojiStickers',
],
'57(' => [
'_' => 'updateUserEmojiStatus',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'emoji_status' => match (stream_get_contents($stream, 4)) {
'-' => [
'_' => 'emojiStatusEmpty',
],
'a' => [
'_' => 'emojiStatus',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'Ǩ0' => [
'_' => 'emojiStatusUntil',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
'until' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_EmojiStatus(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'C0' => [
'_' => 'updateRecentEmojiStatuses',
],
'cxo' => [
'_' => 'updateRecentReactions',
],
'' => self::deserialize_updateMoveStickerSetToTop($stream),
'sZ' => [
'_' => 'updateMessageExtendedMedia',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'extended_media' => match (stream_get_contents($stream, 4)) {
'Ȍb' => self::deserialize_messageExtendedMediaPreview($stream),
'dG' => [
'_' => 'messageExtendedMedia',
'media' => match (stream_get_contents($stream, 4)) {
' c=' => [
'_' => 'messageMediaEmpty',
],
'PQi' => self::deserialize_messageMediaPhoto($stream),
'tV' => [
'_' => 'messageMediaGeo',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'I)2p' => [
'_' => 'messageMediaContact',
'phone_number' => self::deserialize_string($stream),
'first_name' => self::deserialize_string($stream),
'last_name' => self::deserialize_string($stream),
'vcard' => self::deserialize_string($stream),
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'messageMediaUnsupported',
],
'-L' => self::deserialize_messageMediaDocument($stream),
';' => self::deserialize_messageMediaWebPage($stream),
'?S.' => [
'_' => 'messageMediaVenue',
'geo' => match (stream_get_contents($stream, 4)) {
'_' => [
'_' => 'geoPointEmpty',
],
'c' => self::deserialize_geoPoint($stream),
'r0' => self::deserialize_type_GeoPoint(self::gzdecode($stream)),
default => self::err($stream)
}
,
'title' => self::deserialize_string($stream),
'address' => self::deserialize_string($stream),
'provider' => self::deserialize_string($stream),
'venue_id' => self::deserialize_string($stream),
'venue_type' => self::deserialize_string($stream),
],
'' => [
'_' => 'messageMediaGame',
'game' => match (stream_get_contents($stream, 4)) {
';e' => self::deserialize_game($stream),
'r0' => self::deserialize_type_Game(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'H' => self::deserialize_messageMediaInvoice($stream),
'f@' => self::deserialize_messageMediaGeoLive($stream),
'K' => [
'_' => 'messageMediaPoll',
'poll' => match (stream_get_contents($stream, 4)) {
'a' => self::deserialize_poll($stream),
'r0' => self::deserialize_type_Poll(self::gzdecode($stream)),
default => self::err($stream)
}
,
'results' => match (stream_get_contents($stream, 4)) {
' $z' => self::deserialize_pollResults($stream),
'r0' => self::deserialize_type_PollResults(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'~?' => [
'_' => 'messageMediaDice',
'value' => unpack('l', stream_get_contents($stream, 4))[1],
'emoticon' => self::deserialize_string($stream),
],
'bh' => self::deserialize_messageMediaStory($stream),
'' => self::deserialize_messageMediaGiveaway($stream),
'h' => self::deserialize_messageMediaGiveawayResults($stream),
'r0' => self::deserialize_type_MessageMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => self::deserialize_type_MessageExtendedMedia(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'.' => self::deserialize_updateChannelPinnedTopic($stream),
'' => self::deserialize_updateChannelPinnedTopics($stream),
'8R ' => [
'_' => 'updateUser',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'' => [
'_' => 'updateAutoSaveSettings',
],
'֊' => [
'_' => 'updateGroupInvitePrivacyForbidden',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'u' => [
'_' => 'updateStory',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story' => match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'+N' => [
'_' => 'updateReadStories',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'max_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'5' => [
'_' => 'updateStoryID',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
'random_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'M,' => [
'_' => 'updateStoriesStealthMode',
'stealth_mode' => match (stream_get_contents($stream, 4)) {
'\'.q' => self::deserialize_storiesStealthMode($stream),
'r0' => self::deserialize_type_StoriesStealthMode(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'vb}' => [
'_' => 'updateSentStoryReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
'reaction' => match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'M' => [
'_' => 'updateBotChatBoost',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'boost' => match (stream_get_contents($stream, 4)) {
'q*' => self::deserialize_boost($stream),
'r0' => self::deserialize_type_Boost(self::gzdecode($stream)),
default => self::err($stream)
}
,
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
' ' => [
'_' => 'updateChannelViewForumAsMessages',
'channel_id' => unpack('q', stream_get_contents($stream, 8))[1],
'enabled' => match (stream_get_contents($stream, 4)) {'ur' => true,'7y' => false, default => self::err($stream) },
],
'?' => self::deserialize_updatePeerWallpaper($stream),
'!' => [
'_' => 'updateBotMessageReaction',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'actor' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'old_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'new_reactions' => self::deserialize_type_array_of_Reaction(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
'Yw	' => [
'_' => 'updateBotMessageReactions',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'reactions' => self::deserialize_type_array_of_ReactionCount(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'qts' => unpack('l', stream_get_contents($stream, 4))[1],
],
't' => self::deserialize_updateSavedDialogPinned($stream),
'lh' => self::deserialize_updatePinnedSavedDialogs($stream),
'2t9' => [
'_' => 'updateSavedReactionTags',
],
'ib' => [
'_' => 'updateSmsJob',
'job_id' => self::deserialize_string($stream),
],
'
G' => [
'_' => 'updateQuickReplies',
'quick_replies' => self::deserialize_type_array_of_QuickReply(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'=' => [
'_' => 'updateNewQuickReply',
'quick_reply' => match (stream_get_contents($stream, 4)) {
'+' => [
'_' => 'quickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'shortcut' => self::deserialize_string($stream),
'top_message' => unpack('l', stream_get_contents($stream, 4))[1],
'count' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => self::deserialize_type_QuickReply(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'S' => [
'_' => 'updateDeleteQuickReply',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'
>' => [
'_' => 'updateQuickReplyMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'oV' => [
'_' => 'updateDeleteQuickReplyMessages',
'shortcut_id' => unpack('l', stream_get_contents($stream, 4))[1],
'messages' => self::deserialize_type_array_of_int(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_Update(self::gzdecode($stream)),
default => self::err($stream)
}
,
'date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'[r' => [
'_' => 'updatesCombined',
'updates' => self::deserialize_type_array_of_Update(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'users' => self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'chats' => self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'seq_start' => unpack('l', stream_get_contents($stream, 4))[1],
'seq' => unpack('l', stream_get_contents($stream, 4))[1],
],
'@Bt' => [
'_' => 'updates',
'updates' => self::deserialize_type_array_of_Update(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'users' => self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'chats' => self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
'date' => unpack('l', stream_get_contents($stream, 4))[1],
'seq' => unpack('l', stream_get_contents($stream, 4))[1],
],
'' => self::deserialize_updateShortSentMessage($stream),
'r0' => $this->deserialize_type_Updates(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_payments___savedInfo(mixed $stream): mixed {
$tmp = ['_' => 'payments.savedInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_saved_credentials'] = ($flags & 2) !== 0;
if (($flags & 1) !== 0) $tmp['saved_info'] = match (stream_get_contents($stream, 4)) {
'?' => self::deserialize_paymentRequestedInfo($stream),
'r0' => self::deserialize_type_PaymentRequestedInfo(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_BankCardOpenUrl(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'h' => [
'_' => 'bankCardOpenUrl',
'url' => self::deserialize_string($stream),
'name' => self::deserialize_string($stream),
],
'r0' => $this->deserialize_type_BankCardOpenUrl(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_payments___checkedGiftCode(mixed $stream): mixed {
$tmp = ['_' => 'payments.checkedGiftCode'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['via_giveaway'] = ($flags & 4) !== 0;
if (($flags & 16) !== 0) $tmp['from_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 8) !== 0) $tmp['giveaway_msg_id'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['to_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['months'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['used_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_payments___giveawayInfo(mixed $stream): mixed {
$tmp = ['_' => 'payments.giveawayInfo'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['participating'] = ($flags & 1) !== 0;
$tmp['preparing_results'] = ($flags & 8) !== 0;
$tmp['start_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 2) !== 0) $tmp['joined_too_early_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['admin_disallowed_chat_id'] = unpack('q', stream_get_contents($stream, 8))[1];
if (($flags & 16) !== 0) $tmp['disallowed_country'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_payments___giveawayInfoResults(mixed $stream): mixed {
$tmp = ['_' => 'payments.giveawayInfoResults'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['winner'] = ($flags & 1) !== 0;
$tmp['refunded'] = ($flags & 2) !== 0;
$tmp['start_date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 1) !== 0) $tmp['gift_code_slug'] = self::deserialize_string($stream);
$tmp['finish_date'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['winners_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['activated_count'] = unpack('l', stream_get_contents($stream, 4))[1];
return $tmp;

    }
    private  function deserialize_type_array_of_GroupCallStreamChannel(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'H' => [
'_' => 'groupCallStreamChannel',
'channel' => unpack('l', stream_get_contents($stream, 4))[1],
'scale' => unpack('l', stream_get_contents($stream, 4))[1],
'last_timestamp_ms' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_GroupCallStreamChannel(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_langPackLanguage(mixed $stream): mixed {
$tmp = ['_' => 'langPackLanguage'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['official'] = ($flags & 1) !== 0;
$tmp['rtl'] = ($flags & 4) !== 0;
$tmp['beta'] = ($flags & 8) !== 0;
$tmp['name'] = self::deserialize_string($stream);
$tmp['native_name'] = self::deserialize_string($stream);
$tmp['lang_code'] = self::deserialize_string($stream);
if (($flags & 2) !== 0) $tmp['base_lang_code'] = self::deserialize_string($stream);
$tmp['plural_code'] = self::deserialize_string($stream);
$tmp['strings_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['translated_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['translations_url'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_StatsDateRangeDays(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'7' => [
'_' => 'statsDateRangeDays',
'min_date' => unpack('l', stream_get_contents($stream, 4))[1],
'max_date' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_StatsDateRangeDays(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_StatsAbsValueAndPrev(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'ެC' => [
'_' => 'statsAbsValueAndPrev',
'current' => unpack('d', stream_get_contents($stream, 8))[1],
'previous' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_StatsAbsValueAndPrev(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_StatsPercentValue(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'/' => [
'_' => 'statsPercentValue',
'part' => unpack('d', stream_get_contents($stream, 8))[1],
'total' => unpack('d', stream_get_contents($stream, 8))[1],
],
'r0' => $this->deserialize_type_StatsPercentValue(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_statsGraph(mixed $stream): mixed {
$tmp = ['_' => 'statsGraph'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['json'] = match (stream_get_contents($stream, 4)) {
't}' => json_decode(self::deserialize_string($stream), true, 512, \JSON_THROW_ON_ERROR),
'r0' => self::deserialize_type_DataJSON(self::gzdecode($stream)),
default => self::err($stream)
}
;
if (($flags & 1) !== 0) $tmp['zoom_token'] = self::deserialize_string($stream);
return $tmp;

    }
    private  function deserialize_type_StatsGraph(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'-\'J' => [
'_' => 'statsGraphAsync',
'token' => self::deserialize_string($stream),
],
'"ܾ' => [
'_' => 'statsGraphError',
'error' => self::deserialize_string($stream),
],
'd' => self::deserialize_statsGraph($stream),
'r0' => $this->deserialize_type_StatsGraph(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_PostInteractionCounters(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'postInteractionCountersMessage',
'msg_id' => unpack('l', stream_get_contents($stream, 4))[1],
'views' => unpack('l', stream_get_contents($stream, 4))[1],
'forwards' => unpack('l', stream_get_contents($stream, 4))[1],
'reactions' => unpack('l', stream_get_contents($stream, 4))[1],
],
'\'H' => [
'_' => 'postInteractionCountersStory',
'story_id' => unpack('l', stream_get_contents($stream, 4))[1],
'views' => unpack('l', stream_get_contents($stream, 4))[1],
'forwards' => unpack('l', stream_get_contents($stream, 4))[1],
'reactions' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_PostInteractionCounters(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_StatsGroupTopPoster(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'' => [
'_' => 'statsGroupTopPoster',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'messages' => unpack('l', stream_get_contents($stream, 4))[1],
'avg_chars' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_StatsGroupTopPoster(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_StatsGroupTopAdmin(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'LX' => [
'_' => 'statsGroupTopAdmin',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'deleted' => unpack('l', stream_get_contents($stream, 4))[1],
'kicked' => unpack('l', stream_get_contents($stream, 4))[1],
'banned' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_StatsGroupTopAdmin(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_StatsGroupTopInviter(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'w_S' => [
'_' => 'statsGroupTopInviter',
'user_id' => unpack('q', stream_get_contents($stream, 8))[1],
'invitations' => unpack('l', stream_get_contents($stream, 4))[1],
],
'r0' => $this->deserialize_type_StatsGroupTopInviter(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_type_array_of_PublicForward(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'J' => [
'_' => 'publicForwardMessage',
'message' => match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'Э' => [
'_' => 'publicForwardStory',
'peer' => match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
,
'story' => match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
,
],
'r0' => $this->deserialize_type_PublicForward(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_stats___publicForwards(mixed $stream): mixed {
$tmp = ['_' => 'stats.publicForwards'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['forwards'] = self::deserialize_type_array_of_PublicForward(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
if (($flags & 1) !== 0) $tmp['next_offset'] = self::deserialize_string($stream);
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_ExportedChatlistInvite(mixed $stream): mixed {
return match (stream_get_contents($stream, 4)) {
'Q' => [
'_' => 'exportedChatlistInvite',
'flags' => unpack('V', stream_get_contents($stream, 4))[1],
'title' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
'peers' => self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => $this->deserialize_type_ExportedChatlistInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
    }
    private  function deserialize_type_array_of_ExportedChatlistInvite(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'Q' => [
'_' => 'exportedChatlistInvite',
'flags' => unpack('V', stream_get_contents($stream, 4))[1],
'title' => self::deserialize_string($stream),
'url' => self::deserialize_string($stream),
'peers' => self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            }),
],
'r0' => self::deserialize_type_ExportedChatlistInvite(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_chatlists___chatlistInvite(mixed $stream): mixed {
$tmp = ['_' => 'chatlists.chatlistInvite'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['title'] = self::deserialize_string($stream);
if (($flags & 1) !== 0) $tmp['emoticon'] = self::deserialize_string($stream);
$tmp['peers'] = self::deserialize_type_array_of_Peer(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
return $tmp;

    }
    private  function deserialize_type_array_of_PeerStories(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'5' => self::deserialize_peerStories($stream),
'r0' => self::deserialize_type_PeerStories(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_stories___allStories(mixed $stream): mixed {
$tmp = ['_' => 'stories.allStories'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['has_more'] = ($flags & 1) !== 0;
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['state'] = self::deserialize_string($stream);
$tmp['peer_stories'] = self::deserialize_type_array_of_PeerStories(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['chats'] = self::deserialize_type_array_of_Chat(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['users'] = self::deserialize_type_array_of_User(match(stream_get_contents($stream, 4)) {    
                'ĵ' => $stream,    
                'r0' => self::gzdecode_vector($stream)
            });
$tmp['stealth_mode'] = match (stream_get_contents($stream, 4)) {
'\'.q' => self::deserialize_storiesStealthMode($stream),
'r0' => self::deserialize_type_StoriesStealthMode(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_storyView(mixed $stream): mixed {
$tmp = ['_' => 'storyView'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blocked'] = ($flags & 1) !== 0;
$tmp['blocked_my_stories_from'] = ($flags & 2) !== 0;
$tmp['user_id'] = unpack('q', stream_get_contents($stream, 8))[1];
$tmp['date'] = unpack('l', stream_get_contents($stream, 4))[1];
if (($flags & 4) !== 0) $tmp['reaction'] = match (stream_get_contents($stream, 4)) {
'y' => [
'_' => 'reactionEmpty',
],
'"' => [
'_' => 'reactionEmoji',
'emoticon' => self::deserialize_string($stream),
],
's5' => [
'_' => 'reactionCustomEmoji',
'document_id' => unpack('q', stream_get_contents($stream, 8))[1],
],
'r0' => self::deserialize_type_Reaction(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_storyViewPublicForward(mixed $stream): mixed {
$tmp = ['_' => 'storyViewPublicForward'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blocked'] = ($flags & 1) !== 0;
$tmp['blocked_my_stories_from'] = ($flags & 2) !== 0;
$tmp['message'] = match (stream_get_contents($stream, 4)) {
'ʦ' => self::deserialize_messageEmpty($stream),
'~l' => self::deserialize_message($stream),
'bX+' => self::deserialize_messageService($stream),
'r0' => self::deserialize_type_Message(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_storyViewPublicRepost(mixed $stream): mixed {
$tmp = ['_' => 'storyViewPublicRepost'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['blocked'] = ($flags & 1) !== 0;
$tmp['blocked_my_stories_from'] = ($flags & 2) !== 0;
$tmp['peer_id'] = match (stream_get_contents($stream, 4)) {
'"QY' => self::deserialize_peerUser($stream),
'6' => -unpack('q', stream_get_contents($stream, 8))[1],
'7' => self::deserialize_peerChannel($stream),
'r0' => self::deserialize_type_Peer(self::gzdecode($stream)),
default => self::err($stream)
}
;
$tmp['story'] = match (stream_get_contents($stream, 4)) {
'OQ' => [
'_' => 'storyItemDeleted',
'id' => unpack('l', stream_get_contents($stream, 4))[1],
],
'ɭ' => self::deserialize_storyItemSkipped($stream),
'$jy' => self::deserialize_storyItem($stream),
'r0' => self::deserialize_type_StoryItem(self::gzdecode($stream)),
default => self::err($stream)
}
;
return $tmp;

    }
    private  function deserialize_type_array_of_StoryView(mixed $stream): array {

                $result = [];
                for ($x = unpack("V", stream_get_contents($stream, 4))[1]; $x > 0; --$x) {    
                    $result []= match (stream_get_contents($stream, 4)) {
'꽰' => self::deserialize_storyView($stream),
'g' => self::deserialize_storyViewPublicForward($stream),
'It' => self::deserialize_storyViewPublicRepost($stream),
'r0' => $this->deserialize_type_StoryView(self::gzdecode($stream)),
default => self::err($stream)
}
;
                }
                return $result;    
            
    }
    private  function deserialize_stories___storyViewsList(mixed $stream): mixed {
$tmp = ['_' => 'stories.storyViewsList'];
$flags = unpack('V', stream_get_contents($stream, 4))[1];
$tmp['count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['views_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['forwards_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['reactions_count'] = unpack('l', stream_get_contents($stream, 4))[1];
$tmp['views'] = self::deserialize_type_array_of_StoryView(match(stream_get_contents($