<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Premium
{
    /**
     * Obtains info about the boosts that were applied to a certain channel or supergroup (admins only).
     *
     * @param bool $gifts Whether to return only info about boosts received from [gift codes and giveaways created by the channel/supergroup »](https://core.telegram.org/api/giveaways)
     * @param array|int|string $peer The channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param string $offset Offset for pagination, obtained from [premium.boostsList](https://docs.madelineproto.xyz/API_docs/constructors/premium.boostsList.html).`next_offset`
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'premium.boostsList', count: int, boosts: list<array{_: 'boost', gift: bool, giveaway: bool, unclaimed: bool, id: string, user_id?: int, giveaway_msg_id?: int, date: int, expires: int, used_gift_slug?: string, multiplier?: int, stars?: int}>, next_offset?: string, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/premium.BoostsList.html
     */
    public function getBoostsList(bool|null $gifts = null, array|int|string|null $peer = null, string|null $offset = '', int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain which peers are we currently [boosting](https://core.telegram.org/api/boost), and how many [boost slots](https://core.telegram.org/api/boost) we have left.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'premium.myBoosts', my_boosts: list<array{_: 'myBoost', slot: int, peer?: array|int|string, date: int, expires: int, cooldown_until_date?: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/premium.MyBoosts.html
     */
    public function getMyBoosts(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Apply one or more [boosts »](https://core.telegram.org/api/boost) to a peer.
     *
     * @param list<int> $slots Which [boost slots](https://core.telegram.org/api/boost) to assign to this peer.
     * @param array|int|string $peer The peer to boost. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'premium.myBoosts', my_boosts: list<array{_: 'myBoost', slot: int, peer?: array|int|string, date: int, expires: int, cooldown_until_date?: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/premium.MyBoosts.html
     */
    public function applyBoost(array|null $slots = null, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Gets the current [number of boosts](https://core.telegram.org/api/boost) of a channel/supergroup.
     *
     * @param array|int|string $peer The peer. @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'premium.boostsStatus', my_boost: bool, level: int, current_level_boosts: int, boosts: int, gift_boosts?: int, next_level_boosts?: int, premium_audience?: array{_: 'statsPercentValue', part: float, total: float}, boost_url: string, prepaid_giveaways?: list<array{_: 'prepaidGiveaway', id: int, months: int, quantity: int, date: int}|array{_: 'prepaidStarsGiveaway', id: int, stars: int, quantity: int, boosts: int, date: int}>, my_boost_slots?: list<int>} @see https://docs.madelineproto.xyz/API_docs/types/premium.BoostsStatus.html
     */
    public function getBoostsStatus(array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Returns the lists of boost that were applied to a channel/supergroup by a specific user (admins only).
     *
     * @param array|int|string $peer The channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array|int|string $user_id The user @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'premium.boostsList', count: int, boosts: list<array{_: 'boost', gift: bool, giveaway: bool, unclaimed: bool, id: string, user_id?: int, giveaway_msg_id?: int, date: int, expires: int, used_gift_slug?: string, multiplier?: int, stars?: int}>, next_offset?: string, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/premium.BoostsList.html
     */
    public function getUserBoosts(array|int|string|null $peer = null, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;
}
