<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Channels
{
    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) history as read.
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $max_id ID of message up to which messages should be marked as read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function readHistory(array|int|string|null $channel = null, int|null $max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Delete messages in a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $id IDs of messages to delete
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedMessages', pts: int, pts_count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedMessages.html
     */
    public function deleteMessages(array|int|string|null $channel = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Reports some messages from a user in a supergroup as spam; requires administrator rights in the supergroup.
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant whose messages should be reported @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of spam messages
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reportSpam(array|int|string|null $channel = null, array|int|string|null $participant = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Get [channel/supergroup](https://core.telegram.org/api/channel) messages.
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int|array>|array<never, never> $id Array of IDs of messages to get @see https://docs.madelineproto.xyz/API_docs/types/InputMessage.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getMessages(array|int|string|null $channel = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get the participants of a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array{_: 'channelParticipantsRecent'}|array{_: 'channelParticipantsAdmins'}|array{_: 'channelParticipantsKicked', q?: string}|array{_: 'channelParticipantsBots'}|array{_: 'channelParticipantsBanned', q?: string}|array{_: 'channelParticipantsSearch', q?: string}|array{_: 'channelParticipantsContacts', q?: string}|array{_: 'channelParticipantsMentions', q?: string, top_msg_id?: int} $filter Which participant types to fetch @see https://docs.madelineproto.xyz/API_docs/types/ChannelParticipantsFilter.html
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $offset [Offset](https://core.telegram.org/api/offsets)
     * @param int $limit [Limit](https://core.telegram.org/api/offsets)
     * @param list<int|string>|array<never, never> $hash Array of [Hash](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/int|string.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'channels.channelParticipants', count: int, participants: list<array{_: 'channelParticipant', user_id: int, date: int, subscription_until_date?: int}|array{_: 'channelParticipantSelf', via_request: bool, user_id: int, inviter_id: int, date: int, subscription_until_date?: int}|array{_: 'channelParticipantCreator', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool, post_stories: bool, edit_stories: bool, delete_stories: bool}, user_id: int, rank?: string}|array{_: 'channelParticipantAdmin', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool, post_stories: bool, edit_stories: bool, delete_stories: bool}, can_edit: bool, self: bool, user_id: int, inviter_id?: int, promoted_by: int, date: int, rank?: string}|array{_: 'channelParticipantBanned', peer: array|int|string, banned_rights: array{_: 'chatBannedRights', view_messages: bool, send_messages: bool, send_media: bool, send_stickers: bool, send_gifs: bool, send_games: bool, send_inline: bool, embed_links: bool, send_polls: bool, change_info: bool, invite_users: bool, pin_messages: bool, manage_topics: bool, send_photos: bool, send_videos: bool, send_roundvideos: bool, send_audios: bool, send_voices: bool, send_docs: bool, send_plain: bool, until_date: int}, left: bool, kicked_by: int, date: int}|array{_: 'channelParticipantLeft', peer: array|int|string}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'channels.channelParticipantsNotModified'} @see https://docs.madelineproto.xyz/API_docs/types/channels.ChannelParticipants.html
     */
    public function getParticipants(array $filter, array|int|string|null $channel = null, int|null $offset = 0, int|null $limit = 0, array $hash = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get info about a [channel/supergroup](https://core.telegram.org/api/channel) participant.
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant to get info about @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'channels.channelParticipant', participant: array{_: 'channelParticipant', user_id: int, date: int, subscription_until_date?: int}|array{_: 'channelParticipantSelf', via_request: bool, user_id: int, inviter_id: int, date: int, subscription_until_date?: int}|array{_: 'channelParticipantCreator', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool, post_stories: bool, edit_stories: bool, delete_stories: bool}, user_id: int, rank?: string}|array{_: 'channelParticipantAdmin', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool, post_stories: bool, edit_stories: bool, delete_stories: bool}, can_edit: bool, self: bool, user_id: int, inviter_id?: int, promoted_by: int, date: int, rank?: string}|array{_: 'channelParticipantBanned', peer: array|int|string, banned_rights: array{_: 'chatBannedRights', view_messages: bool, send_messages: bool, send_media: bool, send_stickers: bool, send_gifs: bool, send_games: bool, send_inline: bool, embed_links: bool, send_polls: bool, change_info: bool, invite_users: bool, pin_messages: bool, manage_topics: bool, send_photos: bool, send_videos: bool, send_roundvideos: bool, send_audios: bool, send_voices: bool, send_docs: bool, send_plain: bool, until_date: int}, left: bool, kicked_by: int, date: int}|array{_: 'channelParticipantLeft', peer: array|int|string}, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/channels.ChannelParticipant.html
     */
    public function getParticipant(array|int|string|null $channel = null, array|int|string|null $participant = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Create a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param bool $broadcast Whether to create a [channel](https://core.telegram.org/api/channel)
     * @param bool $megagroup Whether to create a [supergroup](https://core.telegram.org/api/channel)
     * @param bool $for_import Whether the supergroup is being created to import messages from a foreign chat service using [messages.initHistoryImport](https://docs.madelineproto.xyz/API_docs/methods/messages.initHistoryImport.html)
     * @param bool $forum Whether to create a [forum](https://core.telegram.org/api/forum)
     * @param string $title Channel title
     * @param string $about Channel description
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int} $geo_point Geogroup location, see [here »](https://core.telegram.org/api/nearby) for more info on geogroups. @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param string $address Geogroup address, see [here »](https://core.telegram.org/api/nearby) for more info on geogroups.
     * @param int $ttl_period Time-to-live of all messages that will be sent in the supergroup: once message.date+message.ttl\_period === time(), the message will be deleted on the server, and must be deleted locally as well. You can use [messages.setDefaultHistoryTTL](https://docs.madelineproto.xyz/API_docs/methods/messages.setDefaultHistoryTTL.html) to edit this value later.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function createChannel(bool|null $broadcast = null, bool|null $megagroup = null, bool|null $for_import = null, bool|null $forum = null, string|null $title = '', string|null $about = '', array|null $geo_point = null, string|null $address = null, int|null $ttl_period = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Modify the admin rights of a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array{_: 'chatAdminRights', change_info?: bool, post_messages?: bool, edit_messages?: bool, delete_messages?: bool, ban_users?: bool, invite_users?: bool, pin_messages?: bool, add_admins?: bool, anonymous?: bool, manage_call?: bool, other?: bool, manage_topics?: bool, post_stories?: bool, edit_stories?: bool, delete_stories?: bool} $admin_rights The admin rights @see https://docs.madelineproto.xyz/API_docs/types/ChatAdminRights.html
     * @param array|int|string $channel The [supergroup/channel](https://core.telegram.org/api/channel). @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $user_id The ID of the user whose admin rights should be modified @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param string $rank Indicates the role (rank) of the admin in the group: just an arbitrary string
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editAdmin(array $admin_rights, array|int|string|null $channel = null, array|int|string|null $user_id = null, string|null $rank = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit the name of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $title New name
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editTitle(array|int|string|null $channel = null, string|null $title = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Change the photo of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel Channel/supergroup whose photo should be edited @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputChatPhotoEmpty'}|array{_: 'inputChatUploadedPhoto', file?: mixed, video?: mixed, video_start_ts?: float, video_emoji_markup?: array{_: 'videoSize', type?: string, w?: int, h?: int, size?: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id?: int, background_colors?: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset?: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'}, sticker_id?: int, background_colors?: list<int>}}|array{_: 'inputChatPhoto', id?: array} $photo New photo @see https://docs.madelineproto.xyz/API_docs/types/InputChatPhoto.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editPhoto(array|int|string|null $channel = null, array|null $photo = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Check if a username is free and can be assigned to a channel/supergroup.
     *
     * @param array|int|string $channel The [channel/supergroup](https://core.telegram.org/api/channel) that will assigned the specified username @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $username The username to check
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function checkUsername(array|int|string|null $channel = null, string|null $username = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Change or remove the username of a supergroup/channel.
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $username New username, pass an empty string to remove the username
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function updateUsername(array|int|string|null $channel = null, string|null $username = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Join a channel/supergroup.
     *
     * @param array|int|string $channel Channel/supergroup to join @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function joinChannel(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Leave a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) to leave @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function leaveChannel(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Invite users to a channel/supergroup.
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<array|int|string>|array<never, never> $users Array of Users to invite @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.invitedUsers', updates: array, missing_invitees: list<array{_: 'missingInvitee', premium_would_allow_invite: bool, premium_required_for_pm: bool, user_id: int}>} @see https://docs.madelineproto.xyz/API_docs/types/messages.InvitedUsers.html
     */
    public function inviteToChannel(array|int|string|null $channel = null, array $users = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) to delete @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteChannel(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get link and embed info of a message in a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param bool $grouped Whether to include other grouped media (for albums)
     * @param bool $thread Whether to also include a thread ID, if available, inside of the link
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $id Message ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'exportedMessageLink', link: string, html: string} @see https://docs.madelineproto.xyz/API_docs/types/ExportedMessageLink.html
     */
    public function exportMessageLink(bool|null $grouped = null, bool|null $thread = null, array|int|string|null $channel = null, int|null $id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Enable/disable message signatures in channels.
     *
     * @param bool $signatures_enabled If set, enables message signatures.
     * @param bool $profiles_enabled If set, messages from channel admins will link to their profiles, just like for group messages: can only be set if the `signatures_enabled` flag is set.
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleSignatures(bool|null $signatures_enabled = null, bool|null $profiles_enabled = null, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [channels/supergroups/geogroups](https://core.telegram.org/api/channel) we're admin in. Usually called when the user exceeds the [limit](https://docs.madelineproto.xyz/API_docs/constructors/config.html) for owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), and the user is given the choice to remove one of his channels/supergroups/geogroups.
     *
     * @param bool $by_location Get geogroups
     * @param bool $check_limit If set and the user has reached the limit of owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), instead of returning the channel list one of the specified [errors](#possible-errors) will be returned.<br>Useful to check if a new public channel can indeed be created, even before asking the user to enter a channel username to use in [channels.checkUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.checkUsername.html)/[channels.updateUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.updateUsername.html).
     * @param bool $for_personal Set this flag to only fetch the full list of channels that may be passed to [account.updatePersonalChannel](https://docs.madelineproto.xyz/API_docs/methods/account.updatePersonalChannel.html) to [display them on our profile page](https://core.telegram.org/api/profile#personal-channel).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getAdminedPublicChannels(bool|null $by_location = null, bool|null $check_limit = null, bool|null $for_personal = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Ban/unban/kick a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array{_: 'chatBannedRights', view_messages?: bool, send_messages?: bool, send_media?: bool, send_stickers?: bool, send_gifs?: bool, send_games?: bool, send_inline?: bool, embed_links?: bool, send_polls?: bool, change_info?: bool, invite_users?: bool, pin_messages?: bool, manage_topics?: bool, send_photos?: bool, send_videos?: bool, send_roundvideos?: bool, send_audios?: bool, send_voices?: bool, send_docs?: bool, send_plain?: bool, until_date?: int} $banned_rights The banned rights @see https://docs.madelineproto.xyz/API_docs/types/ChatBannedRights.html
     * @param array|int|string $channel The [supergroup/channel](https://core.telegram.org/api/channel). @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant to ban @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editBanned(array $banned_rights, array|int|string|null $channel = null, array|int|string|null $participant = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get the admin log of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $q Search query, can be empty
     * @param array{_: 'channelAdminLogEventsFilter', join?: bool, leave?: bool, invite?: bool, ban?: bool, unban?: bool, kick?: bool, unkick?: bool, promote?: bool, demote?: bool, info?: bool, settings?: bool, pinned?: bool, edit?: bool, delete?: bool, group_call?: bool, invites?: bool, send?: bool, forums?: bool, sub_extend?: bool} $events_filter Event filter @see https://docs.madelineproto.xyz/API_docs/types/ChannelAdminLogEventsFilter.html
     * @param list<array|int|string> $admins Array of Only show events from these admins @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $max_id Maximum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * @param int $min_id Minimum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'channels.adminLogResults', events: list<array>, chats: list<array>, users: list<array>} @see https://docs.madelineproto.xyz/API_docs/types/channels.AdminLogResults.html
     */
    public function getAdminLog(array|int|string|null $channel = null, string|null $q = '', array|null $events_filter = null, array|null $admins = null, int|null $max_id = 0, int|null $min_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Associate a stickerset to the supergroup.
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'} $stickerset The stickerset to associate @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setStickers(array|int|string|null $channel = null, array|null $stickerset = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) message contents as read.
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $id IDs of messages whose contents should be marked as read
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function readMessageContents(array|int|string|null $channel = null, array $id = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Delete the history of a [supergroup](https://core.telegram.org/api/channel).
     *
     * @param bool $for_everyone Whether the history should be deleted for everyone
     * @param array|int|string $channel [Supergroup](https://core.telegram.org/api/channel) whose history must be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $max_id ID of message **up to which** the history must be deleted
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteHistory(bool|null $for_everyone = null, array|int|string|null $channel = null, int|null $max_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Hide/unhide message history for new channel/supergroup users.
     *
     * @param bool $enabled Hide/unhide
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function togglePreHistoryHidden(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get a list of [channels/supergroups](https://core.telegram.org/api/channel) we left, requires a [takeout session, see here » for more info](https://core.telegram.org/api/takeout).
     *
     * @param int $takeoutId Takeout ID, generated using account.initTakeoutSession, see [the takeout docs](https://core.telegram.org/api/takeout) for more info.
     * @param int $offset Offset for [pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getLeftChannels(int $takeoutId, int|null $offset = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get all groups that can be used as [discussion groups](https://core.telegram.org/api/discussion).
     *
     * Returned [basic group chats](https://core.telegram.org/api/channel#basic-groups) must be first upgraded to [supergroups](https://core.telegram.org/api/channel#supergroups) before they can be set as a discussion group.
     * To set a returned supergroup as a discussion group, access to its old messages must be enabled using [channels.togglePreHistoryHidden](https://docs.madelineproto.xyz/API_docs/methods/channels.togglePreHistoryHidden.html), first.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getGroupsForDiscussion(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Associate a group to a channel as [discussion group](https://core.telegram.org/api/discussion) for that channel.
     *
     * @param array|int|string $broadcast Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $group [Discussion group](https://core.telegram.org/api/discussion) to associate to the channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setDiscussionGroup(array|int|string|null $broadcast = null, array|int|string|null $group = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Transfer channel ownership.
     *
     * @param string|array $password [2FA password](https://core.telegram.org/api/srp) of account @see https://docs.madelineproto.xyz/API_docs/types/InputCheckPasswordSRP.html
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $user_id New channel owner @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editCreator(string|array $password, array|int|string|null $channel = null, array|int|string|null $user_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit location of geogroup, see [here »](https://core.telegram.org/api/nearby) for more info on geogroups.
     *
     * @param array|int|string $channel [Geogroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int} $geo_point New geolocation @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param string $address Address string
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function editLocation(array|int|string|null $channel = null, array|null $geo_point = null, string|null $address = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Toggle supergroup slow mode: if enabled, users will only be able to send one message every `seconds` seconds.
     *
     * @param array|int|string $channel The [supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $seconds Users will only be able to send one message every `seconds` seconds, `0` to disable the limitation
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleSlowMode(array|int|string|null $channel = null, int|null $seconds = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get inactive channels and supergroups.
     *
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.inactiveChats', dates: list<int>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.InactiveChats.html
     */
    public function getInactiveChannels(?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Convert a [supergroup](https://core.telegram.org/api/channel) to a [gigagroup](https://core.telegram.org/api/channel), when requested by [channel suggestions](https://core.telegram.org/api/config#channel-suggestions).
     *
     * @param array|int|string $channel The [supergroup](https://core.telegram.org/api/channel) to convert @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function convertToGigagroup(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtains a list of peers that can be used to send messages in a specific group.
     *
     * @param bool $for_paid_reactions
     * @param array|int|string $peer The group where we intend to send messages @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'channels.sendAsPeers', peers: list<array{_: 'sendAsPeer', peer: array|int|string, premium_required: bool}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/channels.SendAsPeers.html
     */
    public function getSendAs(bool|null $for_paid_reactions = null, array|int|string|null $peer = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete all messages sent by a specific participant of a given supergroup.
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant The participant whose messages should be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteParticipantHistory(array|int|string|null $channel = null, array|int|string|null $participant = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set whether all users [should join a discussion group in order to comment on a post »](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group).
     *
     * @param bool $enabled Toggle
     * @param array|int|string $channel Discussion group @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleJoinToSend(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set whether all users should [request admin approval to join the group »](https://core.telegram.org/api/invites#join-requests).
     *
     * @param bool $enabled Toggle
     * @param array|int|string $channel Group @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleJoinRequest(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Reorder active usernames.
     *
     * @param array|int|string $channel The supergroup or channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<string>|array<never, never> $order The new order for active usernames. All active usernames must be specified.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reorderUsernames(array|int|string|null $channel = null, array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Activate or deactivate a purchased [fragment.com](https://fragment.com) username associated to a [supergroup or channel](https://core.telegram.org/api/channel) we own.
     *
     * @param bool $active Whether to activate or deactivate the username
     * @param array|int|string $channel [Supergroup or channel](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $username Username
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function toggleUsername(bool $active, array|int|string|null $channel = null, string|null $username = '', ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Disable all purchased usernames of a supergroup or channel.
     *
     * @param array|int|string $channel Supergroup or channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function deactivateAllUsernames(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Enable or disable [forum functionality](https://core.telegram.org/api/forum) in a supergroup.
     *
     * @param bool $enabled Enable or disable forum functionality
     * @param array|int|string $channel Supergroup ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleForum(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Create a [forum topic](https://core.telegram.org/api/forum); requires [`manage_topics` rights](https://core.telegram.org/api/rights).
     *
     * @param array|int|string $channel [The forum](https://core.telegram.org/api/forum) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $title Topic title (maximum UTF-8 length: 128)
     * @param int $icon_color If no custom emoji icon is specified, specifies the color of the fallback topic icon (RGB), one of `0x6FB9F0`, `0xFFD67E`, `0xCB86DB`, `0x8EEE98`, `0xFF93B2`, or `0xFB6F5F`.
     * @param int $icon_emoji_id ID of the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon. [Telegram Premium](https://core.telegram.org/api/premium) users can use any custom emoji, other users can only use the custom emojis contained in the [inputStickerSetEmojiDefaultTopicIcons](https://docs.madelineproto.xyz/API_docs/constructors/inputStickerSetEmojiDefaultTopicIcons.html) emoji pack.
     * @param array|int|string $send_as Create the topic as the specified peer @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function createForumTopic(array|int|string|null $channel = null, string|null $title = '', int|null $icon_color = null, int|null $icon_emoji_id = null, array|int|string|null $send_as = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get [topics of a forum](https://core.telegram.org/api/forum).
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $q Search query
     * @param int $offset_date [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), date of the last message of the last found topic. Use 0 or any date in the future to get results from the last topic.
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), ID of the last message of the last found topic (or initially `0`).
     * @param int $offset_topic [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets), ID of the last found topic (or initially `0`).
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets). For optimal performance, the number of returned topics is chosen by the server and can be smaller than the specified limit.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.forumTopics', order_by_create_date: bool, count: int, topics: list<array{_: 'forumTopicDeleted', id: int}|array{_: 'forumTopic', from_id: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until?: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_muted?: bool, stories_hide_sender?: bool, stories_ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, my: bool, closed: bool, pinned: bool, short: bool, hidden: bool, id: int, date: int, title: string, icon_color: int, icon_emoji_id?: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, draft?: array{_: 'draftMessageEmpty', date?: int}|array{_: 'draftMessage', no_webpage: bool, invert_media: bool, reply_to?: array{_: 'inputReplyToMessage', reply_to_msg_id: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer: array|int|string, story_id: int}, message: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media?: \danog\MadelineProto\EventHandler\Media|string|array, date: int, effect?: int}}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}, hash: list<int|string>}, report_delivery_until_date?: int, paid_message_stars?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, reactions_are_possible: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}|array{_: 'phoneCallDiscardReasonMigrateConferenceCall', slug: string}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributePattern', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributeBackdrop', name: string, backdrop_id: int, center_color: int, edge_color: int, pattern_color: int, text_color: int, rarity_permille: int}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array|int|string, sender_id?: array|int|string, date: int, message?: array{_: 'textWithEntities', text: array, entities: list<array>}}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, name_hidden: bool, saved: bool, converted: bool, upgraded: bool, refunded: bool, can_upgrade: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}, convert_stars?: int, upgrade_msg_id?: int, upgrade_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int}|array{_: 'messageActionStarGiftUnique', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributePattern', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributeBackdrop', name: string, backdrop_id: int, center_color: int, edge_color: int, pattern_color: int, text_color: int, rarity_permille: int}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array|int|string, sender_id?: array|int|string, date: int, message?: array{_: 'textWithEntities', text: array, entities: list<array>}}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, upgrade: bool, transferred: bool, saved: bool, refunded: bool, can_export_at?: int, transfer_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int, resale_stars?: int, can_transfer_at?: int, can_resell_at?: int}|array{_: 'messageActionPaidMessagesRefunded', count: int, stars: int}|array{_: 'messageActionPaidMessagesPrice', stars: int}|array{_: 'messageActionConferenceCall', missed: bool, active: bool, video: bool, call_id: int, duration?: int, other_participants?: list<array|int|string>}, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>, pts: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.ForumTopics.html
     */
    public function getForumTopics(array|int|string|null $channel = null, string|null $q = null, int|null $offset_date = 0, int|null $offset_id = 0, int|null $offset_topic = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Get forum topics by their ID.
     *
     * @param array|int|string $channel Forum @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $topics Topic IDs
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.forumTopics', order_by_create_date: bool, count: int, topics: list<array{_: 'forumTopicDeleted', id: int}|array{_: 'forumTopic', from_id: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until?: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_muted?: bool, stories_hide_sender?: bool, stories_ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, stories_other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, my: bool, closed: bool, pinned: bool, short: bool, hidden: bool, id: int, date: int, title: string, icon_color: int, icon_emoji_id?: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, draft?: array{_: 'draftMessageEmpty', date?: int}|array{_: 'draftMessage', no_webpage: bool, invert_media: bool, reply_to?: array{_: 'inputReplyToMessage', reply_to_msg_id: int, top_msg_id?: int, reply_to_peer_id?: array|int|string, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'inputReplyToStory', peer: array|int|string, story_id: int}, message: string, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, media?: \danog\MadelineProto\EventHandler\Media|string|array, date: int, effect?: int}}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, invert_media: bool, offline: bool, video_processing_pending: bool, id: int, from_id?: array|int|string, from_boosts_applied?: int, saved_peer_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, via_bot_id?: int, via_business_bot_id?: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_markup?: array, entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, views?: int, forwards?: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers?: list<array|int|string>, channel_id?: int, max_id?: int, read_max_id?: int}, edit_date?: int, post_author?: string, grouped_id?: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, restriction_reason?: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period?: int, quick_reply_shortcut_id?: int, effect?: int, factcheck?: array{_: 'factCheck', need_check: bool, country?: string, text?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}, hash: list<int|string>}, report_delivery_until_date?: int, paid_message_stars?: int}|array{_: 'messageService', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, reactions_are_possible: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, quote: bool, reply_to_msg_id?: int, reply_to_peer_id?: array|int|string, reply_from?: array{_: 'messageFwdHeader', imported: bool, saved_out: bool, from_id?: array|int|string, from_name?: string, date: int, channel_post?: int, post_author?: string, saved_from_peer?: array|int|string, saved_from_msg_id?: int, saved_from_id?: array|int|string, saved_from_name?: string, saved_date?: int, psa_type?: string}, reply_media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, ttl_seconds?: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, video: bool, round: bool, voice: bool, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, alt_documents?: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}>, video_cover?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, video_timestamp?: int, ttl_seconds?: int}|array{_: 'messageMediaWebPage', force_large_media: bool, force_small_media: bool, manual: bool, safe: bool, webpage: array{_: 'webPageEmpty', id: array, url?: array}|array{_: 'webPagePending', id: array, url?: array, date: array}|array{_: 'webPage', has_large_media: array, video_cover_photo: array, id: array, url: array, display_url: array, hash: array, type?: array, site_name?: array, title?: array, description?: array, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, embed_url?: array, embed_type?: array, embed_width?: array, embed_height?: array, duration?: array, author?: array, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, cached_page?: array, attributes?: list<array>}|array{_: 'webPageNotModified', cached_page_views?: array}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', id: array, access_hash: array, short_name: array, title: array, description: array, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: array, access_hash: array, size: array, mime_type: array, attributes: list<array>}|array{_: 'webDocumentNoProxy', url: array, size: array, mime_type: array, attributes: list<array>}, receipt_msg_id?: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: array, lat: array, access_hash: array, accuracy_radius?: array}, heading?: int, period: int, proximity_notification_radius?: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', question: array, id: array, closed: array, public_voters: array, multiple_choice: array, quiz: array, answers: list<array>, close_period?: array, close_date?: array}, results: array{_: 'pollResults', min: array, results?: list<array>, total_voters?: array, recent_voters?: list<array>, solution?: array, solution_entities?: list<array>}}|array{_: 'messageMediaDice', value: int, emoticon: string}|array{_: 'messageMediaStory', peer: array|int|string, via_mention: bool, id: int, story?: array{_: 'storyItemDeleted', id: array}|array{_: 'storyItemSkipped', close_friends: array, id: array, date: array, expire_date: array}}|array{_: 'messageMediaGiveaway', only_new_subscribers: bool, winners_are_visible: bool, channels: list<int>, countries_iso2?: list<string>, prize_description?: string, quantity: int, months?: int, stars?: int, until_date: int}|array{_: 'messageMediaGiveawayResults', only_new_subscribers: bool, refunded: bool, channel_id: int, additional_peers_count?: int, launch_msg_id: int, winners_count: int, unclaimed_count: int, winners: list<int>, months?: int, stars?: int, prize_description?: string, until_date: int}|array{_: 'messageMediaPaidMedia', stars_amount: int, extended_media: list<array{_: 'messageExtendedMediaPreview', w?: array, h?: array, thumb?: array, video_duration?: array}>}, reply_to_top_id?: int, quote_text?: string, quote_entities?: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>, quote_offset?: int}|array{_: 'messageReplyStoryHeader', peer: array|int|string, story_id: int}, date: int, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', title: string, chat_id: array|int|string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name?: string, phone?: string, email?: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id?: string, subscription_until_date?: int}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug?: string, subscription_until_date?: int}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}|array{_: 'phoneCallDiscardReasonMigrateConferenceCall', slug: string}, duration?: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', attach_menu: bool, from_request: bool, domain?: string, app?: array{_: 'botAppNotModified'}|array{_: 'botApp', id: int, access_hash: int, short_name: string, title: string, description: string, photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}, document?: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, hash: list<int|string>}}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files?: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, duration?: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from?: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}|array{_: 'inputGroupCallSlug', slug: string}|array{_: 'inputGroupCallInviteMessage', msg_id: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id?: int}|array{_: 'messageActionTopicEdit', title?: string, icon_emoji_id?: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'messageActionRequestedPeer', button_id: int, peers: list<array|int|string>}|array{_: 'messageActionSetChatWallPaper', wallpaper: array{_: 'wallPaper', id: int, creator: bool, default: bool, pattern: bool, dark: bool, access_hash: int, slug: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}|array{_: 'wallPaperNoFile', id: int, default: bool, dark: bool, settings?: array{_: 'wallPaperSettings', blur: bool, motion: bool, background_color?: int, second_background_color?: int, third_background_color?: int, fourth_background_color?: int, intensity?: int, rotation?: int, emoticon?: string}}, same: bool, for_both: bool}|array{_: 'messageActionGiftCode', via_giveaway: bool, unclaimed: bool, boost_peer?: array|int|string, months: int, slug: string, currency?: string, amount?: int, crypto_currency?: string, crypto_amount?: int, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}}|array{_: 'messageActionGiveawayLaunch', stars?: int}|array{_: 'messageActionGiveawayResults', stars: bool, winners_count: int, unclaimed_count: int}|array{_: 'messageActionBoostApply', boosts: int}|array{_: 'messageActionRequestedPeerSentMe', button_id: int, peers: list<array{_: 'requestedPeerUser', user_id: int, first_name?: string, last_name?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChat', chat_id: array|int|string, title?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}|array{_: 'requestedPeerChannel', channel_id: int, title?: string, username?: string, photo?: array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes?: list<array>, dc_id: array}}>}|array{_: 'messageActionPaymentRefunded', peer: array|int|string, charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, currency: string, total_amount: int, payload?: string}|array{_: 'messageActionGiftStars', currency: string, amount: int, stars: int, crypto_currency?: string, crypto_amount?: int, transaction_id?: string}|array{_: 'messageActionPrizeStars', boost_peer: array|int|string, unclaimed: bool, stars: int, transaction_id: string, giveaway_msg_id: int}|array{_: 'messageActionStarGift', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributePattern', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributeBackdrop', name: string, backdrop_id: int, center_color: int, edge_color: int, pattern_color: int, text_color: int, rarity_permille: int}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array|int|string, sender_id?: array|int|string, date: int, message?: array{_: 'textWithEntities', text: array, entities: list<array>}}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, name_hidden: bool, saved: bool, converted: bool, upgraded: bool, refunded: bool, can_upgrade: bool, message?: array{_: 'textWithEntities', text: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', offset: int, length: int, user_id: array|int|string}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}|array{_: 'messageEntityBlockquote', collapsed: bool, offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}>}, convert_stars?: int, upgrade_msg_id?: int, upgrade_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int}|array{_: 'messageActionStarGiftUnique', gift: array{_: 'starGift', limited: bool, sold_out: bool, birthday: bool, id: int, sticker: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, stars: int, availability_remains?: int, availability_total?: int, availability_resale?: int, convert_stars: int, first_sale_date?: int, last_sale_date?: int, upgrade_stars?: int, resell_min_stars?: int, title?: string}|array{_: 'starGiftUnique', id: int, title: string, slug: string, num: int, owner_id?: array|int|string, owner_name?: string, owner_address?: string, attributes: list<array{_: 'starGiftAttributeModel', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributePattern', name: string, document: array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs?: list<array>, video_thumbs?: list<array>, dc_id: array, attributes: list<array>}, rarity_permille: int}|array{_: 'starGiftAttributeBackdrop', name: string, backdrop_id: int, center_color: int, edge_color: int, pattern_color: int, text_color: int, rarity_permille: int}|array{_: 'starGiftAttributeOriginalDetails', recipient_id: array|int|string, sender_id?: array|int|string, date: int, message?: array{_: 'textWithEntities', text: array, entities: list<array>}}>, availability_issued: int, availability_total: int, gift_address?: string, resell_stars?: int}, upgrade: bool, transferred: bool, saved: bool, refunded: bool, can_export_at?: int, transfer_stars?: int, from_id?: array|int|string, peer?: array|int|string, saved_id?: int, resale_stars?: int, can_transfer_at?: int, can_resell_at?: int}|array{_: 'messageActionPaidMessagesRefunded', count: int, stars: int}|array{_: 'messageActionPaidMessagesPrice', stars: int}|array{_: 'messageActionConferenceCall', missed: bool, active: bool, video: bool, call_id: int, duration?: int, other_participants?: list<array|int|string>}, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, reactions_as_tags: bool, results: list<array{_: 'reactionCount', chosen_order?: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}, count: int}>, recent_reactions?: list<array{_: 'messagePeerReaction', peer_id: array|int|string, big: bool, unread: bool, my: bool, date: int, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}|array{_: 'reactionPaid'}}>, top_reactors?: list<array{_: 'messageReactor', top: bool, my: bool, anonymous: bool, peer_id?: array|int|string, count: int}>}, ttl_period?: int}>, chats: list<array|int|string>, users: list<array|int|string>, pts: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.ForumTopics.html
     */
    public function getForumTopicsByID(array|int|string|null $channel = null, array $topics = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Edit [forum topic](https://core.telegram.org/api/forum); requires [`manage_topics` rights](https://core.telegram.org/api/rights).
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $topic_id Topic ID
     * @param string $title If present, will update the topic title (maximum UTF-8 length: 128).
     * @param int $icon_emoji_id If present, updates the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon. [Telegram Premium](https://core.telegram.org/api/premium) users can use any custom emoji, other users can only use the custom emojis contained in the [inputStickerSetEmojiDefaultTopicIcons](https://docs.madelineproto.xyz/API_docs/constructors/inputStickerSetEmojiDefaultTopicIcons.html) emoji pack. Pass 0 to switch to the fallback topic icon.
     * @param bool $closed If present, will update the open/closed status of the topic.
     * @param bool $hidden If present, will hide/unhide the topic (only valid for the "General" topic, `id=1`).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editForumTopic(array|int|string|null $channel = null, int|null $topic_id = 0, string|null $title = null, int|null $icon_emoji_id = null, bool|null $closed = null, bool|null $hidden = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Pin or unpin [forum topics](https://core.telegram.org/api/forum).
     *
     * @param bool $pinned Whether to pin or unpin the topic
     * @param array|int|string $channel Supergroup ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $topic_id [Forum topic ID](https://core.telegram.org/api/forum)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updatePinnedForumTopic(bool $pinned, array|int|string|null $channel = null, int|null $topic_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Delete message history of a [forum topic](https://core.telegram.org/api/forum).
     *
     * @param array|int|string $channel Forum @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $top_msg_id Topic ID
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteTopicHistory(array|int|string|null $channel = null, int|null $top_msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Reorder pinned forum topics.
     *
     * @param bool $force If not set, the order of only the topics present both server-side and in `order` will be changed (i.e. mentioning topics not pinned server-side in `order` will not pin them, and not mentioning topics pinned server-side will not unpin them).  <br>If set, the entire server-side pinned topic list will be replaced with `order` (i.e. mentioning topics not pinned server-side in `order` will pin them, and not mentioning topics pinned server-side will unpin them)
     * @param array|int|string $channel Supergroup ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $order [Topic IDs »](https://core.telegram.org/api/forum)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function reorderPinnedForumTopics(bool|null $force = null, array|int|string|null $channel = null, array $order = [], ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Enable or disable the [native antispam system](https://core.telegram.org/api/antispam).
     *
     * @param bool $enabled Enable or disable the native antispam system.
     * @param array|int|string $channel Supergroup ID. The specified supergroup must have at least `telegram_antispam_group_size_min` members to enable antispam functionality, as specified by the [client configuration parameters](https://core.telegram.org/api/config#client-configuration). @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleAntiSpam(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Report a [native antispam](https://core.telegram.org/api/antispam) false positive.
     *
     * @param array|int|string $channel Supergroup ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $msg_id Message ID that was mistakenly deleted by the [native antispam](https://core.telegram.org/api/antispam) system, taken from the [admin log](https://core.telegram.org/api/recent-actions)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function reportAntiSpamFalsePositive(array|int|string|null $channel = null, int|null $msg_id = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Hide or display the participants list in a [supergroup](https://core.telegram.org/api/channel).
     *
     * The supergroup must have at least `hidden_members_group_size_min` participants in order to use this method, as specified by the [client configuration parameters »](https://core.telegram.org/api/config#client-configuration).
     *
     * @param bool $enabled If true, will hide the participants list; otherwise will unhide it.
     * @param array|int|string $channel Supergroup ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleParticipantsHidden(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Update the [accent color and background custom emoji »](https://core.telegram.org/api/colors) of a channel.
     *
     * @param bool $for_profile Whether to change the accent color emoji pattern of the profile page; otherwise, the accent color and emoji pattern of messages will be changed. <br>Channels can change both message and profile palettes; supergroups can only change the profile palette, of course after reaching the [appropriate boost level](https://core.telegram.org/api/colors).
     * @param array|int|string $channel Channel whose accent color should be changed. @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $color [ID of the accent color palette »](https://core.telegram.org/api/colors) to use (not RGB24, see [here »](https://core.telegram.org/api/colors) for more info); if not set, the default palette is used.
     * @param int $background_emoji_id Custom emoji ID used in the accent color pattern.
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updateColor(bool|null $for_profile = null, array|int|string|null $channel = null, int|null $color = null, int|null $background_emoji_id = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Users may also choose to display messages from all topics of a [forum](https://core.telegram.org/api/forum) as if they were sent to a normal group, using a "View as messages" setting in the local client: this setting only affects the current account, and is synced to other logged in sessions using this method.
     *
     * Invoking this method will update the value of the `view_forum_as_messages` flag of [channelFull](https://docs.madelineproto.xyz/API_docs/constructors/channelFull.html) or [dialog](https://docs.madelineproto.xyz/API_docs/constructors/dialog.html) and emit an [updateChannelViewForumAsMessages](https://docs.madelineproto.xyz/API_docs/constructors/updateChannelViewForumAsMessages.html).
     *
     * @param bool $enabled The new value of the `view_forum_as_messages` flag.
     * @param array|int|string $channel The forum @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleViewForumAsMessages(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Obtain a list of similarly themed public channels, selected based on similarities in their **subscriber bases**.
     *
     * @param array|int|string $channel The method will return channels related to the passed `channel`. If not set, the method will returns channels related to channels the user has joined. @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getChannelRecommendations(array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set an [emoji status](https://core.telegram.org/api/emoji-status) for a channel or supergroup.
     *
     * @param array|int|string $channel The channel/supergroup, must have at least [channel\_emoji\_status\_level\_min](https://core.telegram.org/api/config#channel-emoji-status-level-min)/[group\_emoji\_status\_level\_min](https://core.telegram.org/api/config#group-emoji-status-level-min) boosts. @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'emojiStatusEmpty'}|array{_: 'emojiStatus', document_id?: int, until?: int}|array{_: 'emojiStatusCollectible', collectible_id?: int, document_id?: int, title?: string, slug?: string, pattern_document_id?: int, center_color?: int, edge_color?: int, pattern_color?: int, text_color?: int, until?: int}|array{_: 'inputEmojiStatusCollectible', collectible_id?: int, until?: int} $emoji_status [Emoji status](https://core.telegram.org/api/emoji-status) to set @see https://docs.madelineproto.xyz/API_docs/types/EmojiStatus.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updateEmojiStatus(array|int|string|null $channel = null, array|null $emoji_status = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Admins with [ban\_users admin rights »](https://docs.madelineproto.xyz/API_docs/constructors/chatAdminRights.html) may allow users that apply a certain number of [booosts »](https://core.telegram.org/api/boost) to the group to bypass [slow mode »](https://docs.madelineproto.xyz/API_docs/methods/channels.toggleSlowMode.html) and [other »](https://core.telegram.org/api/rights#default-rights) supergroup restrictions, see [here »](https://core.telegram.org/api/boost#bypass-slowmode-and-chat-restrictions) for more info.
     *
     * @param array|int|string $channel The supergroup. @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $boosts The number of required boosts (1-8, 0 to disable).
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function setBoostsToUnblockRestrictions(array|int|string|null $channel = null, int|null $boosts = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Set a [custom emoji stickerset](https://core.telegram.org/api/custom-emoji) for supergroups. Only usable after reaching at least the [boost level »](https://core.telegram.org/api/boost) specified in the [`group_emoji_stickers_level_min` »](https://core.telegram.org/api/config#group-emoji-stickers-level-min) config parameter.
     *
     * @param array|int|string $channel The supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}|array{_: 'inputStickerSetEmojiChannelDefaultStatuses'} $stickerset The custom emoji stickerset to associate to the supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     */
    public function setEmojiStickers(array|int|string|null $channel = null, array|null $stickerset = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): bool;

    /**
     * Disable ads on the specified channel, for all users.
     *
     * Available only after reaching at least the [boost level »](https://core.telegram.org/api/boost) specified in the [`channel_restrict_sponsored_level_min` »](https://core.telegram.org/api/config#channel-restrict-sponsored-level-min) config parameter.
     *
     * @param bool $restricted Whether to disable or re-enable ads.
     * @param array|int|string $channel The channel. @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function restrictSponsoredMessages(bool $restricted, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     * Globally search for posts from public [channels »](https://core.telegram.org/api/channel) (*including* those we aren't a member of) containing a specific hashtag.
     *
     * @param string $hashtag The hashtag to search, without the `#` character.
     * @param int $offset_rate Initially 0, then set to the [`next_rate` parameter of messages.messagesSlice](https://docs.madelineproto.xyz/API_docs/constructors/messages.messagesSlice.html)
     * @param array|int|string $offset_peer [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array{_: 'messages.messages', messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesSlice', inexact: array, count: array, next_rate?: array, offset_id_offset?: array, messages: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.channelMessages', inexact: array, pts: array, count: array, offset_id_offset?: array, messages: list<array>, topics: list<array>, chats: list<array>, users: list<array>}|array{_: 'messages.messagesNotModified', count: array} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function searchPosts(string|null $hashtag = '', int|null $offset_rate = 0, array|int|string|null $offset_peer = null, int|null $offset_id = 0, int|null $limit = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updatePaidMessagesPrice(array|int|string|null $channel = null, int|null $send_paid_messages_stars = 0, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;

    /**
     *
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param ?int $floodWaitLimit Can be used to specify a custom flood wait limit: if a FLOOD_WAIT_ rate limiting error is received with a waiting period bigger than this integer, an RPCErrorException will be thrown; otherwise, MadelineProto will simply wait for the specified amount of time. Defaults to the value specified in the settings: https://docs.madelineproto.xyz/PHP/danog/MadelineProto/Settings/RPC.html#setfloodtimeout-int-floodtimeout-self
     * @param ?string $queueId If specified, ensures strict server-side execution order of concurrent calls with the same queue ID.
     * @param ?\Amp\Cancellation $cancellation Cancellation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleAutotranslation(bool $enabled, array|int|string|null $channel = null, ?int $floodWaitLimit = null, ?string $queueId = null, ?\Amp\Cancellation $cancellation = null): array;
}
